/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.util;

import org.apache.james.managesieve.api.ArgumentException;
import org.apache.james.managesieve.util.ParserUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ParserUtilsTest {
    ParserUtilsTest() {
    }

    @Test
    void getSizeShouldThrowOnNullInput() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize(null)).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldThrowOnEmptyInput() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldThrowOnMalformedData1() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"abc")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldThrowOnMalformedData2() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"{ab")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldThrowOnMalformedData3() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"{ab}")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldThrowOnMalformedData4() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"{ab+}")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldThrowOnMalformedData5() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"{ab125+}")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void getSizeShouldWork() throws Exception {
        Assertions.assertThat((long)ParserUtils.getSize((String)"{45+}")).isEqualTo(45L);
    }

    @Test
    void getSizeShouldThrowOnExtraArguments() {
        Assertions.assertThatThrownBy(() -> ParserUtils.getSize((String)"{45+} extra")).isInstanceOf(ArgumentException.class);
    }

    @Test
    void unquoteShouldReturnNullOnNullInput() {
        Assertions.assertThat((String)ParserUtils.unquote(null)).isEqualTo(null);
    }

    @Test
    void unquoteShouldReturnEmptyStringOnEmptyInput() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"")).isEqualTo("");
    }

    @Test
    void unquoteShouldNotUnquoteUnquotedQuotes() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"a")).isEqualTo("a");
    }

    @Test
    void unquoteShouldNotUnquoteNonStartingQuotes() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"a\"")).isEqualTo("a\"");
    }

    @Test
    void unquoteShouldNotUnquoteNonEndingQuotes() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"\"a")).isEqualTo("\"a");
    }

    @Test
    void unquoteShouldNotUnquoteQuotesThatDoNotEnglobeWallString() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"a\"b\"c")).isEqualTo("a\"b\"c");
    }

    @Test
    void unquoteShouldNotUnquoteQuotesThatDoNotEnglobeWallString1() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"\"b\"c")).isEqualTo("\"b\"c");
    }

    @Test
    void unquoteShouldNotUnquoteQuotesThatDoNotEnglobeWallString2() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"a\"b\"")).isEqualTo("a\"b\"");
    }

    @Test
    void unquoteShouldWorkWithDoubleQuote() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"\"a\"")).isEqualTo("a");
    }

    @Test
    void unquoteShouldNotUnquoteNonTrimmedData() {
        Assertions.assertThat((String)ParserUtils.unquote((String)" \"a\"")).isEqualTo(" \"a\"");
    }

    @Test
    void unquoteShouldManageSingleQuotes() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"a'")).isEqualTo("a'");
    }

    @Test
    void unquoteShouldManageSingleQuotes1() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"'a")).isEqualTo("'a");
    }

    @Test
    void unquoteShouldManageSingleQuotes2() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"a'b")).isEqualTo("a'b");
    }

    @Test
    void unquoteShouldWorkWithSingleQuotes() {
        Assertions.assertThat((String)ParserUtils.unquote((String)"'a'")).isEqualTo("a");
    }
}

