/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3.webadmin;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.collect.ImmutableList;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.cassandra.CassandraBlobModule;
import org.apache.james.blob.cassandra.CassandraBlobStoreFactory;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.modules.CassandraMessageModule;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.pop3.webadmin.Pop3MetaDataFixInconsistenciesTaskRegistration;
import org.apache.james.pop3server.mailbox.CassandraPop3MetadataStore;
import org.apache.james.pop3server.mailbox.Pop3MetadataModule;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesAdditionalInformationDTO;
import org.apache.james.pop3server.mailbox.task.MetaDataFixInconsistenciesService;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import spark.ResponseTransformer;
import spark.Service;

class Pop3MetaDataFixInconsistenciesRoutesTest {
    private static final String BASE_PATH = "/mailboxes";
    private static final CassandraId MAILBOX_ID = CassandraId.timeBased();
    private static final CassandraMessageId MESSAGE_ID_1 = new CassandraMessageId.Factory().fromString("d2bee791-7e63-11ea-883c-95b84008f979");
    private static final CassandraMessageId MESSAGE_ID_2 = new CassandraMessageId.Factory().fromString("eeeeeeee-7e63-11ea-883c-95b84008f979");
    private static final MessageUid MESSAGE_UID_1 = MessageUid.of((long)1L);
    private static final MessageUid MESSAGE_UID_2 = MessageUid.of((long)2L);
    private static final String CONTENT_MESSAGE = "CONTENT 123 BLA BLA";
    private static final ModSeq MOD_SEQ_1 = ModSeq.of((long)1L);
    private static final ModSeq MOD_SEQ_2 = ModSeq.of((long)2L);
    private static final HashBlobId HEADER_BLOB_ID_1 = new HashBlobId.Factory().forPayload("abc".getBytes());
    private static final CassandraMessageMetadata MESSAGE_1 = CassandraMessageMetadata.builder().ids(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)MAILBOX_ID, (MessageId)MESSAGE_ID_1, MESSAGE_UID_1)).modSeq(MOD_SEQ_1).flags(new Flags()).threadId(ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID_1)).build()).internalDate(new Date()).bodyStartOctet(Long.valueOf(18L)).size(Long.valueOf(36L)).headerContent(Optional.of(HEADER_BLOB_ID_1)).build();
    private static final CassandraMessageMetadata MESSAGE_2 = CassandraMessageMetadata.builder().ids(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)MAILBOX_ID, (MessageId)MESSAGE_ID_2, MESSAGE_UID_2)).modSeq(MOD_SEQ_2).flags(new Flags()).threadId(ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID_2)).build()).internalDate(new Date()).bodyStartOctet(Long.valueOf(18L)).size(Long.valueOf(36L)).headerContent(Optional.of(HEADER_BLOB_ID_1)).build();
    private static final SimpleMailboxMessage MAILBOX_MESSAGE_1 = SimpleMailboxMessage.builder().messageId((MessageId)MESSAGE_ID_1).mailboxId((MailboxId)MAILBOX_ID).uid(MESSAGE_UID_1).internalDate(new Date()).threadId(ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID_1)).bodyStartOctet(16).size((long)"CONTENT 123 BLA BLA".length()).content((Content)new ByteContent("CONTENT 123 BLA BLA".getBytes(StandardCharsets.UTF_8))).flags(new Flags()).properties(new PropertyBuilder()).addAttachments((Collection)ImmutableList.of()).build();
    private WebAdminServer webAdminServer;
    private MemoryTaskManager taskManager;
    private CassandraMessageIdToImapUidDAO imapUidDAO;
    private CassandraMessageDAOV3 cassandraMessageDAOV3;
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraSchemaVersionModule.MODULE, CassandraMessageModule.MODULE, CassandraBlobModule.MODULE, Pop3MetadataModule.MODULE}));

    Pop3MetaDataFixInconsistenciesRoutesTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        CassandraPop3MetadataStore pop3MetadataStore = new CassandraPop3MetadataStore((CqlSession)cassandra.getConf());
        this.imapUidDAO = new CassandraMessageIdToImapUidDAO((CqlSession)cassandra.getConf(), (BlobId.Factory)new HashBlobId.Factory(), CassandraConfiguration.DEFAULT_CONFIGURATION);
        this.cassandraMessageDAOV3 = new CassandraMessageDAOV3((CqlSession)cassandra.getConf(), cassandra.getTypesProvider(), CassandraBlobStoreFactory.forTesting((CqlSession)cassandra.getConf(), (MetricFactory)new RecordingMetricFactory()).passthrough(), (BlobId.Factory)new HashBlobId.Factory());
        MetaDataFixInconsistenciesService fixInconsistenciesService = new MetaDataFixInconsistenciesService(this.imapUidDAO, (Pop3MetadataStore)pop3MetadataStore, this.cassandraMessageDAOV3);
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        Pop3MetaDataFixInconsistenciesRoute routeTestee = new Pop3MetaDataFixInconsistenciesRoute((TaskManager)this.taskManager, fixInconsistenciesService);
        TasksRoutes tasksRoutes = new TasksRoutes((TaskManager)this.taskManager, new JsonTransformer(new JsonTransformerModule[0]), DTOConverter.of((DTOModule[])new DTOModule[]{MetaDataFixInconsistenciesAdditionalInformationDTO.module()}));
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{routeTestee, tasksRoutes}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath(BASE_PATH).build();
    }

    @AfterEach
    void stop() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void taskShouldSuccess() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).post()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void taskShouldSuccessWithRunningOption() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).queryParam("messagesPerSecond", new Object[]{"5"}).post()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void taskShouldFailWhenMessagesPerSecondsIsInvalid() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).queryParam("messagesPerSecond", new Object[]{"invalid"}).post()).then()).statusCode(400)).body("details", Matchers.containsString((String)"'messagesPerSecond' must be numeric"), new Object[0]);
    }

    @Test
    void taskShouldFailWhenMessagesPerSecondsIsNotStrictlyPositive() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).queryParam("messagesPerSecond", new Object[]{"-1"}).post()).then()).statusCode(400)).body("details", Matchers.containsString((String)"'messagesPerSecond' must be strictly positive"), new Object[0]);
    }

    @Test
    void taskShouldReturnDetail() {
        String taskId = (String)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"Pop3MetaDataFixInconsistenciesTask"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"Pop3MetaDataFixInconsistenciesTask"), new Object[0])).body("additionalInformation.runningOptions.messagesPerSecond", Matchers.is((Object)100), new Object[0])).body("additionalInformation.processedImapUidEntries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.processedPop3MetaDataStoreEntries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.stalePOP3Entries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.missingPOP3Entries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.fixedInconsistencies", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.errors", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void taskWithMessagesPerSecondShouldReturnDetail() {
        String taskId = (String)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).queryParam("messagesPerSecond", new Object[]{"250"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"Pop3MetaDataFixInconsistenciesTask"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"Pop3MetaDataFixInconsistenciesTask"), new Object[0])).body("additionalInformation.runningOptions.messagesPerSecond", Matchers.is((Object)250), new Object[0])).body("additionalInformation.processedImapUidEntries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.processedPop3MetaDataStoreEntries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.stalePOP3Entries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.missingPOP3Entries", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.fixedInconsistencies", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.errors", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void errorsPropertyShouldBeNotEmptyWhenProcessFailure() {
        this.imapUidDAO.insert(MESSAGE_1).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).queryParam("messagesPerSecond", new Object[]{"250"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"Pop3MetaDataFixInconsistenciesTask"), new Object[0])).body("status", Matchers.is((Object)"failed"), new Object[0])).body("additionalInformation.errors[0].mailboxId", Matchers.is((Object)MAILBOX_ID.serialize()), new Object[0])).body("additionalInformation.errors[0].messageId", Matchers.is((Object)MESSAGE_ID_1.serialize()), new Object[0]);
    }

    @Test
    void fixedInconsistenciesPropertyShouldBeNotEmptyWhenProcessCompleted() throws MailboxException {
        this.imapUidDAO.insert(MESSAGE_1).block();
        this.cassandraMessageDAOV3.save((MailboxMessage)MAILBOX_MESSAGE_1).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("task", new Object[]{"fixPop3Inconsistencies"}).queryParam("messagesPerSecond", new Object[]{"250"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("type", Matchers.is((Object)"Pop3MetaDataFixInconsistenciesTask"), new Object[0])).body("status", Matchers.is((Object)"completed"), new Object[0])).body("additionalInformation.fixedInconsistencies[0].mailboxId", Matchers.is((Object)MAILBOX_ID.serialize()), new Object[0])).body("additionalInformation.fixedInconsistencies[0].messageId", Matchers.is((Object)MESSAGE_ID_1.serialize()), new Object[0]);
    }

    private static final class Pop3MetaDataFixInconsistenciesRoute
    implements Routes {
        private final TaskManager taskManager;
        private final MetaDataFixInconsistenciesService fixInconsistenciesService;

        private Pop3MetaDataFixInconsistenciesRoute(TaskManager taskManager, MetaDataFixInconsistenciesService fixInconsistenciesService) {
            this.taskManager = taskManager;
            this.fixInconsistenciesService = fixInconsistenciesService;
        }

        public String getBasePath() {
            return Pop3MetaDataFixInconsistenciesRoutesTest.BASE_PATH;
        }

        public void define(Service service) {
            service.post(Pop3MetaDataFixInconsistenciesRoutesTest.BASE_PATH, TaskFromRequestRegistry.builder().registrations(new TaskFromRequestRegistry.TaskRegistration[]{new Pop3MetaDataFixInconsistenciesTaskRegistration(this.fixInconsistenciesService)}).parameterName("task").buildAsRoute(this.taskManager), (ResponseTransformer)new JsonTransformer(new JsonTransformerModule[0]));
        }
    }
}

