/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.memory.InMemoryEventStore;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryReferenceWithCounterTask;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.MemoryTaskExecutionDetailsProjection;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskExecutionDetailsProjection;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.routes.TasksCleanupRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.services.TasksCleanupService;
import org.apache.james.webadmin.tasks.TasksCleanupTaskAdditionalInformationDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

public class TasksCleanupRoutesTest {
    private static final TaskExecutionDetails TASK_EXECUTION_DETAILS = new TaskExecutionDetails(TaskId.fromString((String)"2c7f4081-aa30-11e9-bf6c-2d3b9e84aafd"), TaskType.of((String)"type"), TaskManager.Status.COMPLETED, ZonedDateTime.now().minus(20L, ChronoUnit.DAYS), new Hostname("foo"), Optional::empty, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private WebAdminServer webAdminServer;
    private MemoryTaskManager taskManager;
    private InMemoryEventStore eventStore;
    private MemoryTaskExecutionDetailsProjection taskExecutionDetailsProjection;

    @BeforeEach
    void setUp() {
        Clock clock = Clock.systemDefaultZone();
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.eventStore = new InMemoryEventStore();
        this.taskExecutionDetailsProjection = new MemoryTaskExecutionDetailsProjection();
        TasksCleanupService tasksCleanupService = new TasksCleanupService((TaskExecutionDetailsProjection)this.taskExecutionDetailsProjection, (EventStore)this.eventStore);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new TasksCleanupRoutes((TaskManager)this.taskManager, clock, tasksCleanupService, jsonTransformer), new TasksRoutes((TaskManager)this.taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{TasksCleanupTaskAdditionalInformationDTO.module()}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/tasks").build();
    }

    @AfterEach
    void afterEach() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void olderThanRequestParameterShouldBeCompulsory() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().delete()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0])).body("details", Matchers.is((Object)"missing or invalid `olderThan` parameter"), new Object[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"n", "1b", "oneHour", ""})
    void olderThanRequestParameterShouldBeValid(String olderThan) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("olderThan", new Object[]{olderThan}).delete()).then()).statusCode(400)).body("statusCode", Matchers.is((Object)400), new Object[0])).body("type", Matchers.is((Object)ErrorResponder.ErrorType.INVALID_ARGUMENT.getType()), new Object[0])).body("message", Matchers.is((Object)"Invalid arguments supplied in the user request"), new Object[0]);
    }

    @Test
    void validRequestShouldCreateANewTask() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("olderThan", new Object[]{"15day"}).delete()).then()).statusCode(201)).body("taskId", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    void tasksCleanupShouldCompleteWhenEmptyEntry() {
        String taskId = (String)((Response)RestAssured.given().queryParam("olderThan", new Object[]{"15day"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("additionalInformation.removedTaskCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.processedTaskCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.olderThan", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.timestamp", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void tasksCleanupShouldRemoveOldTaskData() {
        this.taskExecutionDetailsProjection.update(TASK_EXECUTION_DETAILS);
        TaskAggregateId taskAggregateId = new TaskAggregateId(TASK_EXECUTION_DETAILS.taskId());
        Created event = new Created(taskAggregateId, EventId.first(), (Task)new MemoryReferenceWithCounterTask(counter -> Task.Result.COMPLETED), new Hostname("foo"));
        Mono.from((Publisher)this.eventStore.append((Event)event)).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("olderThan", new Object[]{"15day"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("additionalInformation.removedTaskCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.processedTaskCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.olderThan", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.timestamp", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
        Assertions.assertThat((Object)((History)Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)taskAggregateId)).block())).isEqualTo((Object)History.empty());
        Assertions.assertThat((int)this.taskExecutionDetailsProjection.list().size()).isEqualTo(0);
    }

    @Test
    void tasksCleanupShouldRemoveOldTaskDataWhenHaveSeveralEntries() {
        this.taskExecutionDetailsProjection.update(TASK_EXECUTION_DETAILS);
        Created event = new Created(new TaskAggregateId(TASK_EXECUTION_DETAILS.taskId()), EventId.first(), (Task)new MemoryReferenceWithCounterTask(counter -> Task.Result.COMPLETED), new Hostname("foo"));
        Mono.from((Publisher)this.eventStore.append((Event)event)).block();
        TaskExecutionDetails taskExecutionDetails2 = new TaskExecutionDetails(TaskId.generateTaskId(), TaskType.of((String)"type"), TaskManager.Status.COMPLETED, ZonedDateTime.now().minus(20L, ChronoUnit.DAYS), new Hostname("foo"), Optional::empty, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.taskExecutionDetailsProjection.update(taskExecutionDetails2);
        Created event2 = new Created(new TaskAggregateId(taskExecutionDetails2.taskId()), EventId.first(), (Task)new MemoryReferenceWithCounterTask(counter -> Task.Result.COMPLETED), new Hostname("foo"));
        Mono.from((Publisher)this.eventStore.append((Event)event2)).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("olderThan", new Object[]{"15day"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("additionalInformation.removedTaskCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.processedTaskCount", Matchers.is((Object)2), new Object[0])).body("additionalInformation.olderThan", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.timestamp", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void tasksCleanupShouldRemoveOnlyOldData() {
        this.taskExecutionDetailsProjection.update(TASK_EXECUTION_DETAILS);
        TaskAggregateId taskAggregateId = new TaskAggregateId(TASK_EXECUTION_DETAILS.taskId());
        Created event = new Created(taskAggregateId, EventId.first(), (Task)new MemoryReferenceWithCounterTask(counter -> Task.Result.COMPLETED), new Hostname("foo"));
        Mono.from((Publisher)this.eventStore.append((Event)event)).block();
        TaskId tasksId2 = TaskId.generateTaskId();
        TaskExecutionDetails taskExecutionDetails2 = new TaskExecutionDetails(tasksId2, TaskType.of((String)"type"), TaskManager.Status.COMPLETED, ZonedDateTime.now(), new Hostname("foo"), Optional::empty, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.taskExecutionDetailsProjection.update(taskExecutionDetails2);
        TaskAggregateId taskAggregateId2 = new TaskAggregateId(taskExecutionDetails2.taskId());
        Created event2 = new Created(taskAggregateId2, EventId.first(), (Task)new MemoryReferenceWithCounterTask(counter -> Task.Result.COMPLETED), new Hostname("foo"));
        Mono.from((Publisher)this.eventStore.append((Event)event2)).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("olderThan", new Object[]{"15day"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("additionalInformation.removedTaskCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.processedTaskCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.olderThan", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.timestamp", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
        Assertions.assertThat((Object)((History)Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)taskAggregateId)).block())).isEqualTo((Object)History.empty());
        Assertions.assertThat((Object)((History)Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)taskAggregateId2)).block())).isEqualTo((Object)History.of((Event[])new Event[]{event2}));
        Assertions.assertThat((List)CollectionConverters.asJava((Seq)this.taskExecutionDetailsProjection.list().map(TaskExecutionDetails::getTaskId))).containsOnly((Object[])new TaskId[]{tasksId2});
    }

    @ParameterizedTest
    @MethodSource(value={"inProgressStatus"})
    void tasksCleanupShouldNotRemoveInProgressTask(TaskManager.Status status) {
        TaskExecutionDetails taskExecutionDetail = new TaskExecutionDetails(TaskId.generateTaskId(), TaskType.of((String)"type"), status, ZonedDateTime.now(), new Hostname("foo"), Optional::empty, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.taskExecutionDetailsProjection.update(taskExecutionDetail);
        TaskAggregateId taskAggregateId = new TaskAggregateId(taskExecutionDetail.taskId());
        Created event = new Created(taskAggregateId, EventId.first(), (Task)new MemoryReferenceWithCounterTask(counter -> Task.Result.COMPLETED), new Hostname("foo"));
        Mono.from((Publisher)this.eventStore.append((Event)event)).block();
        String taskId = (String)((Response)RestAssured.given().queryParam("olderThan", new Object[]{"15day"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("additionalInformation.removedTaskCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.processedTaskCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.olderThan", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.timestamp", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("additionalInformation.type", Matchers.is((Object)"tasks-cleanup"), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
        Assertions.assertThat((Object)((History)Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)taskAggregateId)).block())).isEqualTo((Object)History.of((Event[])new Event[]{event}));
        Assertions.assertThat((int)this.taskExecutionDetailsProjection.list().size()).isEqualTo(1);
    }

    static Stream<Arguments> inProgressStatus() {
        return Stream.of(Arguments.of((Object[])new Object[]{TaskManager.Status.IN_PROGRESS}), Arguments.of((Object[])new Object[]{TaskManager.Status.WAITING}));
    }
}

