/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import java.util.Optional;
import org.apache.james.backends.cassandra.migration.CassandraMigrationService;
import org.apache.james.backends.cassandra.migration.CassandraSchemaTransitions;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.backends.cassandra.migration.MigrationTask;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.SchemaTransition;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.json.DTOConverter;
import org.apache.james.json.DTOModule;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryTaskManager;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.dto.WebAdminMigrationTaskAdditionalInformationDTO;
import org.apache.james.webadmin.routes.CassandraMigrationRoutes;
import org.apache.james.webadmin.routes.TasksRoutes;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import reactor.core.publisher.Mono;

class CassandraMigrationRoutesTest {
    private static final SchemaVersion LATEST_VERSION = new SchemaVersion(3);
    private static final SchemaVersion CURRENT_VERSION = new SchemaVersion(2);
    private static final SchemaVersion OLDER_VERSION = new SchemaVersion(1);
    private static final SchemaTransition FROM_OLDER_TO_CURRENT = SchemaTransition.to((SchemaVersion)CURRENT_VERSION);
    private static final SchemaTransition FROM_CURRENT_TO_LATEST = SchemaTransition.to((SchemaVersion)LATEST_VERSION);
    private WebAdminServer webAdminServer;
    private CassandraSchemaVersionDAO schemaVersionDAO;
    private MemoryTaskManager taskManager;

    CassandraMigrationRoutesTest() {
    }

    private void createServer() {
        Migration successfulMigration = () -> {};
        CassandraSchemaTransitions transitions = new CassandraSchemaTransitions((Map)ImmutableMap.of((Object)FROM_OLDER_TO_CURRENT, (Object)successfulMigration, (Object)FROM_CURRENT_TO_LATEST, (Object)successfulMigration));
        this.schemaVersionDAO = (CassandraSchemaVersionDAO)Mockito.mock(CassandraSchemaVersionDAO.class);
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.empty()));
        Mockito.when((Object)this.schemaVersionDAO.updateVersion((SchemaVersion)ArgumentMatchers.any())).thenReturn((Object)Mono.empty());
        this.taskManager = new MemoryTaskManager(new Hostname("foo"));
        JsonTransformer jsonTransformer = new JsonTransformer(new JsonTransformerModule[0]);
        this.webAdminServer = WebAdminUtils.createWebAdminServer((Routes[])new Routes[]{new CassandraMigrationRoutes(new CassandraMigrationService(this.schemaVersionDAO, transitions, version -> new MigrationTask(this.schemaVersionDAO, transitions, version), LATEST_VERSION), (TaskManager)this.taskManager, jsonTransformer), new TasksRoutes((TaskManager)this.taskManager, jsonTransformer, DTOConverter.of((DTOModule[])new DTOModule[]{WebAdminMigrationTaskAdditionalInformationDTO.module()}))}).start();
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((WebAdminServer)this.webAdminServer).setBasePath("/cassandra/version").build();
    }

    @BeforeEach
    void setUp() {
        this.createServer();
    }

    @AfterEach
    void tearDown() {
        this.webAdminServer.destroy();
        this.taskManager.stop();
    }

    @Test
    void getShouldReturnTheCurrentVersion() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(CURRENT_VERSION)));
        Integer version = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().jsonPath().getInt("version");
        Assertions.assertThat((Integer)version).isEqualTo(CURRENT_VERSION.getValue());
    }

    @Test
    void getShouldReturnTheLatestVersionWhenSetUpTheLatestVersion() {
        Integer version = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/latest", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).extract().jsonPath().getInt("version");
        Assertions.assertThat((Integer)version).isEqualTo(LATEST_VERSION.getValue());
    }

    @Disabled
    @Test
    void postShouldReturnConflictWhenMigrationOnRunning() {
        ((ValidatableResponse)((Response)RestAssured.when().post("/upgrade", new Object[0])).then()).statusCode(409);
    }

    @Test
    void postShouldReturnErrorCodeWhenInvalidVersion() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(OLDER_VERSION)));
        Map errors = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("NonInt").with().post("/upgrade", new Object[0])).then()).statusCode(400)).contentType(ContentType.JSON)).extract().body().jsonPath().getMap(".");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)errors).containsEntry((Object)"statusCode", (Object)400)).containsEntry((Object)"type", (Object)"InvalidArgument")).containsEntry((Object)"message", (Object)"Invalid arguments supplied in the user request")).containsEntry((Object)"details", (Object)"Expecting version to be specified as an integer");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaVersionDAO});
    }

    @Test
    void postShouldDoMigrationToNewVersion() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(OLDER_VERSION)));
        String taskId = (String)((Response)RestAssured.with().body(String.valueOf(CURRENT_VERSION.getValue())).post("/upgrade", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.atLeastOnce())).getCurrentSchemaVersion();
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.times((int)1))).updateVersion((SchemaVersion)ArgumentMatchers.eq((Object)CURRENT_VERSION));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaVersionDAO});
    }

    @Test
    void postShouldCreateTaskWhenCurrentVersionIsNewerThan() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(CURRENT_VERSION)));
        String taskId = (String)((Response)RestAssured.given().body(String.valueOf(OLDER_VERSION.getValue())).with().post("/upgrade", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    @Test
    void postShouldNotUpdateVersionWhenCurrentVersionIsNewerThan() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(CURRENT_VERSION)));
        String taskId = (String)((Response)RestAssured.given().body(String.valueOf(OLDER_VERSION.getValue())).with().post("/upgrade", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.atLeastOnce())).getCurrentSchemaVersion();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaVersionDAO});
    }

    @Test
    void postShouldPositionLocationHeader() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(CURRENT_VERSION)));
        ((ValidatableResponse)((Response)RestAssured.given().body(String.valueOf(OLDER_VERSION.getValue())).when().post("/upgrade", new Object[0])).then()).header("Location", Matchers.notNullValue());
    }

    @Test
    void postShouldDoMigrationToLatestVersion() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(OLDER_VERSION)));
        String taskId = (String)((Response)RestAssured.with().post("/upgrade/latest", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.atLeastOnce())).getCurrentSchemaVersion();
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.times((int)1))).updateVersion((SchemaVersion)ArgumentMatchers.eq((Object)CURRENT_VERSION));
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.times((int)1))).updateVersion((SchemaVersion)ArgumentMatchers.eq((Object)LATEST_VERSION));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaVersionDAO});
    }

    @Test
    void postShouldReturnTaskIdAndLocation() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(OLDER_VERSION)));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().post("/upgrade/latest", new Object[0])).then()).header("Location", Matchers.is((Matcher)Matchers.notNullValue()))).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void createdTaskShouldHaveDetails() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(OLDER_VERSION)));
        String taskId = (String)((Response)RestAssured.with().post("/upgrade/latest", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)MigrationTask.CASSANDRA_MIGRATION.asString()), new Object[0])).body("additionalInformation.toVersion", Matchers.is((Object)LATEST_VERSION.getValue()), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void postShouldCreateTaskWhenItIsUpToDate() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(LATEST_VERSION)));
        String taskId = (String)((Response)RestAssured.with().post("/upgrade/latest", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
    }

    @Test
    void postShouldNotUpdateVersionWhenItIsUpToDate() {
        Mockito.when((Object)this.schemaVersionDAO.getCurrentSchemaVersion()).thenReturn((Object)Mono.just(Optional.of(LATEST_VERSION)));
        String taskId = (String)((Response)RestAssured.with().post("/upgrade/latest", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((CassandraSchemaVersionDAO)Mockito.verify((Object)this.schemaVersionDAO, (VerificationMode)Mockito.atLeastOnce())).getCurrentSchemaVersion();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.schemaVersionDAO});
    }
}

