/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.webadmin.dto.CassandraVersionRequest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VersionRequestTest {
    VersionRequestTest() {
    }

    @Test
    void parseShouldThrowWhenNullVersion() {
        Assertions.assertThatThrownBy(() -> CassandraVersionRequest.parse(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void parseShouldThrowWhenNonIntegerVersion() {
        Assertions.assertThatThrownBy(() -> CassandraVersionRequest.parse((String)"NoInt")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldThrowWhenNegativeVersion() {
        Assertions.assertThatThrownBy(() -> CassandraVersionRequest.parse((String)"-1")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldThrowWhenZeroVersion() {
        Assertions.assertThatThrownBy(() -> CassandraVersionRequest.parse((String)"0")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldParseTheVersionValue() {
        CassandraVersionRequest cassandraVersionRequest = CassandraVersionRequest.parse((String)"1");
        Assertions.assertThat((Object)cassandraVersionRequest.getValue()).isEqualTo((Object)new SchemaVersion(1));
    }
}

