/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import jakarta.inject.Inject;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadLookupDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeleteMessageListener
implements EventListener.ReactiveGroupEventListener {
    private static final Optional<CassandraId> ALL_MAILBOXES = Optional.empty();
    private final CassandraThreadDAO threadDAO;
    private final CassandraThreadLookupDAO threadLookupDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraAttachmentDAOV2 attachmentDAO;
    private final ACLMapper aclMapper;
    private final CassandraUserMailboxRightsDAO rightsDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final CassandraDeletedMessageDAO deletedMessageDAO;
    private final CassandraMailboxCounterDAO counterDAO;
    private final CassandraMailboxRecentsDAO recentsDAO;
    private final BlobStore blobStore;
    private final CassandraConfiguration cassandraConfiguration;
    private final Set<DeletionCallback> deletionCallbackList;

    @Inject
    public DeleteMessageListener(CassandraThreadDAO threadDAO, CassandraThreadLookupDAO threadLookupDAO, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO, CassandraMessageDAOV3 messageDAOV3, CassandraAttachmentDAOV2 attachmentDAO, ACLMapper aclMapper, CassandraUserMailboxRightsDAO rightsDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraFirstUnseenDAO firstUnseenDAO, CassandraDeletedMessageDAO deletedMessageDAO, CassandraMailboxCounterDAO counterDAO, CassandraMailboxRecentsDAO recentsDAO, BlobStore blobStore, CassandraConfiguration cassandraConfiguration, Set<DeletionCallback> deletionCallbackList) {
        this.threadDAO = threadDAO;
        this.threadLookupDAO = threadLookupDAO;
        this.imapUidDAO = imapUidDAO;
        this.messageIdDAO = messageIdDAO;
        this.messageDAOV3 = messageDAOV3;
        this.attachmentDAO = attachmentDAO;
        this.aclMapper = aclMapper;
        this.rightsDAO = rightsDAO;
        this.applicableFlagDAO = applicableFlagDAO;
        this.firstUnseenDAO = firstUnseenDAO;
        this.deletedMessageDAO = deletedMessageDAO;
        this.counterDAO = counterDAO;
        this.recentsDAO = recentsDAO;
        this.blobStore = blobStore;
        this.cassandraConfiguration = cassandraConfiguration;
        this.deletionCallbackList = deletionCallbackList;
    }

    public Group getDefaultGroup() {
        return new DeleteMessageListenerGroup();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)event;
            return this.handleMessageDeletion(expunged);
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)event;
            CassandraId mailboxId = (CassandraId)mailboxDeletion.getMailboxId();
            return this.handleMailboxDeletion(mailboxId, mailboxDeletion.getMailboxPath());
        }
        return Mono.empty();
    }

    private Mono<Void> handleMailboxDeletion(CassandraId mailboxId, MailboxPath path) {
        int prefetch = 1;
        return Flux.mergeDelayError((int)prefetch, (Publisher[])new Publisher[]{this.messageIdDAO.retrieveMessages(mailboxId, MessageRange.all(), Limit.unlimited()).map(CassandraMessageMetadata::getComposedMessageId).map(ComposedMessageIdWithMetaData::getComposedMessageId).concatMap(metadata -> this.handleMessageDeletionAsPartOfMailboxDeletion((CassandraMessageId)metadata.getMessageId(), mailboxId, path.getUser()).then(this.imapUidDAO.delete((CassandraMessageId)metadata.getMessageId(), mailboxId)).then(this.messageIdDAO.delete(mailboxId, metadata.getUid()))), this.deleteAcl(mailboxId), this.applicableFlagDAO.delete(mailboxId), this.firstUnseenDAO.removeAll(mailboxId), this.deletedMessageDAO.removeAll(mailboxId), this.counterDAO.delete(mailboxId), this.recentsDAO.delete(mailboxId)}).then();
    }

    private Mono<Void> handleMessageDeletion(MailboxEvents.Expunged expunged) {
        return Flux.fromIterable(expunged.getExpunged().values()).map(MessageMetaData::getMessageId).map(CassandraMessageId.class::cast).concatMap(messageId -> this.handleMessageDeletion((CassandraMessageId)messageId, expunged.getMailboxId(), expunged.getMailboxPath().getUser())).then();
    }

    private Mono<Void> deleteAcl(CassandraId mailboxId) {
        return this.aclMapper.getACL(mailboxId).flatMap(acl -> this.rightsDAO.update(mailboxId, ACLDiff.computeDiff((MailboxACL)acl, (MailboxACL)MailboxACL.EMPTY)).then(this.aclMapper.delete(mailboxId)));
    }

    private Mono<Void> handleMessageDeletion(CassandraMessageId messageId, MailboxId mailboxId, Username owner) {
        return Mono.just((Object)messageId).filterWhen(this::isReferenced).flatMap(id -> this.readMessage((CassandraMessageId)id).flatMap(message -> Flux.fromIterable(this.deletionCallbackList).concatMap(callback -> callback.forMessage((MessageRepresentation)message, mailboxId, owner)).then().thenReturn(message)).flatMap(message -> this.deleteUnreferencedAttachments((MessageRepresentation)message).thenReturn(message)).flatMap(this::deleteMessageBlobs).then(this.messageDAOV3.delete(messageId)).then(this.threadLookupDAO.selectOneRow(messageId).flatMap(key -> this.threadDAO.deleteSome(key.getUsername(), key.getMimeMessageIds()).collectList())).then(this.threadLookupDAO.deleteOneRow(messageId)));
    }

    private Mono<Void> handleMessageDeletionAsPartOfMailboxDeletion(CassandraMessageId messageId, CassandraId excludedId, Username owner) {
        return Mono.just((Object)messageId).filterWhen(id -> this.isReferenced((CassandraMessageId)id, excludedId)).flatMap(id -> this.readMessage((CassandraMessageId)id).flatMap(message -> Flux.fromIterable(this.deletionCallbackList).concatMap(callback -> callback.forMessage((MessageRepresentation)message, excludedId, owner)).then().thenReturn(message)).flatMap(message -> this.deleteUnreferencedAttachments((MessageRepresentation)message).thenReturn(message)).flatMap(this::deleteMessageBlobs).then(this.messageDAOV3.delete(messageId)).then(this.threadLookupDAO.selectOneRow(messageId).flatMap(key -> this.threadDAO.deleteSome(key.getUsername(), key.getMimeMessageIds()).collectList())).then(this.threadLookupDAO.deleteOneRow(messageId)));
    }

    private Mono<MessageRepresentation> deleteMessageBlobs(MessageRepresentation message) {
        return Flux.merge((Publisher[])new Publisher[]{this.blobStore.delete(this.blobStore.getDefaultBucketName(), message.getHeaderId()), this.blobStore.delete(this.blobStore.getDefaultBucketName(), message.getBodyId())}).then().thenReturn((Object)message);
    }

    private Mono<MessageRepresentation> readMessage(CassandraMessageId id) {
        return this.messageDAOV3.retrieveMessage(id, MessageMapper.FetchType.METADATA);
    }

    private Mono<Void> deleteUnreferencedAttachments(MessageRepresentation message) {
        return Flux.fromIterable(message.getAttachments()).concatMap(attachment -> this.attachmentDAO.getAttachment((AttachmentId)attachment.getAttachmentId()).map(CassandraAttachmentDAOV2.DAOAttachment::getBlobId).flatMap(blobId -> Mono.from((Publisher)this.blobStore.delete(this.blobStore.getDefaultBucketName(), blobId))).then(this.attachmentDAO.delete((AttachmentId)attachment.getAttachmentId()))).then();
    }

    private Mono<Boolean> isReferenced(CassandraMessageId id) {
        return this.imapUidDAO.retrieve(id, ALL_MAILBOXES, this.chooseReadConsistencyUponWrites()).hasElements().map(FunctionalUtils.negate());
    }

    private Mono<Boolean> isReferenced(CassandraMessageId id, CassandraId excludedId) {
        return this.imapUidDAO.retrieve(id, ALL_MAILBOXES, this.chooseReadConsistencyUponWrites()).filter(metadata -> !metadata.getComposedMessageId().getComposedMessageId().getMailboxId().equals((Object)excludedId)).hasElements().map(FunctionalUtils.negate());
    }

    private JamesExecutionProfiles.ConsistencyChoice chooseReadConsistencyUponWrites() {
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return JamesExecutionProfiles.ConsistencyChoice.STRONG;
        }
        return JamesExecutionProfiles.ConsistencyChoice.WEAK;
    }

    public static class DeleteMessageListenerGroup
    extends Group {
    }

    @FunctionalInterface
    public static interface DeletionCallback {
        default public Mono<Void> forMessage(MessageRepresentation message, MailboxId mailboxId, Username owner) {
            return this.forMessage(DeletedMessageCopyCommand.of(message, mailboxId, owner));
        }

        public Mono<Void> forMessage(DeletedMessageCopyCommand var1);
    }

    public static class DeletedMessageCopyCommand {
        private final MessageId messageId;
        private final MailboxId mailboxId;
        private final Username owner;
        private final Date internalDate;
        private final long size;
        private final boolean hasAttachments;
        private final BlobId headerId;
        private final BlobId bodyId;

        public static DeletedMessageCopyCommand of(MessageRepresentation message, MailboxId mailboxId, Username owner) {
            return new DeletedMessageCopyCommand(message.getMessageId(), mailboxId, owner, message.getInternalDate(), message.getSize(), !message.getAttachments().isEmpty(), message.getHeaderId(), message.getBodyId());
        }

        public DeletedMessageCopyCommand(MessageId messageId, MailboxId mailboxId, Username owner, Date internalDate, long size, boolean hasAttachments, BlobId headerId, BlobId bodyId) {
            this.messageId = messageId;
            this.mailboxId = mailboxId;
            this.owner = owner;
            this.internalDate = internalDate;
            this.size = size;
            this.hasAttachments = hasAttachments;
            this.headerId = headerId;
            this.bodyId = bodyId;
        }

        public Username getOwner() {
            return this.owner;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public Date getInternalDate() {
            return this.internalDate;
        }

        public long getSize() {
            return this.size;
        }

        public boolean hasAttachments() {
            return this.hasAttachments;
        }

        public BlobId getHeaderId() {
            return this.headerId;
        }

        public BlobId getBodyId() {
            return this.bodyId;
        }
    }
}

