/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadService;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.routes.Applicable;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolutionResult;
import org.apache.james.jmap.routes.BlobResolver;
import org.apache.james.jmap.routes.NonApplicable$;
import org.apache.james.jmap.routes.UploadedBlob;
import org.apache.james.mailbox.MailboxSession;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005Y3Aa\u0002\u0005\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003!\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u001d1\u0004A1A\u0005\n]Ba\u0001\u0011\u0001!\u0002\u0013A\u0004\"B!\u0001\t\u0003\u0012%AD+qY>\fGMU3t_24XM\u001d\u0006\u0003\u0013)\taA]8vi\u0016\u001c(BA\u0006\r\u0003\u0011QW.\u00199\u000b\u00055q\u0011!\u00026b[\u0016\u001c(BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e\u001d\u001b\u0005A\u0011BA\u000f\t\u00051\u0011En\u001c2SKN|GN^3s\u00035)\b\u000f\\8bIN+'O^5dKV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u00051Q\u000f\u001d7pC\u0012T!!\n\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002(E\tiQ\u000b\u001d7pC\u0012\u001cVM\u001d<jG\u0016\fa\"\u001e9m_\u0006$7+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003W1\u0002\"a\u0007\u0001\t\u000by\u0019\u0001\u0019\u0001\u0011)\u0005\rq\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0019IgN[3di*\t1'A\u0004kC.\f'\u000f^1\n\u0005U\u0002$AB%oU\u0016\u001cG/\u0001\u0004qe\u00164\u0017\u000e_\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB*ue&tw-A\u0004qe\u00164\u0017\u000e\u001f\u0011\u0002\u000fI,7o\u001c7wKR\u00191I\u0012(\u0011\u0005m!\u0015BA#\t\u0005Q\u0011En\u001c2SKN|G.\u001e;j_:\u0014Vm];mi\")qI\u0002a\u0001\u0011\u00061!\r\\8c\u0013\u0012\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0006\u0002\t5\f\u0017\u000e\\\u0005\u0003\u001b*\u0013aA\u00117pE&#\u0007\"B(\u0007\u0001\u0004\u0001\u0016AD7bS2\u0014w\u000e_*fgNLwN\u001c\t\u0003#Rk\u0011A\u0015\u0006\u0003'2\tq!\\1jY\n|\u00070\u0003\u0002V%\nqQ*Y5mE>D8+Z:tS>t\u0007")
public class UploadResolver
implements BlobResolver {
    private final UploadService uploadService;
    private final String prefix;

    public UploadService uploadService() {
        return this.uploadService;
    }

    private String prefix() {
        return this.prefix;
    }

    @Override
    public BlobResolutionResult resolve(BlobId blobId, MailboxSession mailboxSession) {
        if (!blobId.value().startsWith(this.prefix())) {
            return NonApplicable$.MODULE$;
        }
        String uploadIdAsString = blobId.value().substring(this.prefix().length());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> UploadId.from((String)uploadIdAsString));
        if (try_ instanceof Failure) {
            return NonApplicable$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            UploadId uploadId = (UploadId)success.value();
            return new Applicable((SMono<Blob>)SMono$.MODULE$.apply(this.uploadService().retrieve(uploadId, mailboxSession.getUser())).map((Function1 & Serializable)upload -> new UploadedBlob(blobId, (Upload)upload)).onErrorResume((Function1 & Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable instanceof UploadNotFoundException) {
                    return SMono$.MODULE$.error((Throwable)new BlobNotFoundException(blobId));
                }
                throw new MatchError((Object)throwable);
            }));
        }
        throw new MatchError((Object)try_);
    }

    @Inject
    public UploadResolver(UploadService uploadService) {
        this.uploadService = uploadService;
        this.prefix = "uploads-";
    }
}

