/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.routes.Applicable;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolutionResult;
import org.apache.james.jmap.routes.BlobResolver;
import org.apache.james.jmap.routes.MessageBlob;
import org.apache.james.jmap.routes.NonApplicable$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005Q3Aa\u0002\u0005\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003!\u0011!i\u0003A!b\u0001\n\u0003q\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bQ\u0002A\u0011A\u001b\t\u000b\t\u0003A\u0011I\"\u0003'5+7o]1hK\ncwN\u0019*fg>dg/\u001a:\u000b\u0005%Q\u0011A\u0002:pkR,7O\u0003\u0002\f\u0019\u0005!!.\\1q\u0015\tia\"A\u0003kC6,7O\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\ta!\t\\8c%\u0016\u001cx\u000e\u001c<fe\u0006\u0001R.Z:tC\u001e,\u0017\n\u001a$bGR|'/_\u000b\u0002AA\u0011\u0011%\u000b\b\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nQ!\\8eK2T!A\n\u0007\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011\u0001fI\u0001\n\u001b\u0016\u001c8/Y4f\u0013\u0012L!AK\u0016\u0003\u000f\u0019\u000b7\r^8ss*\u0011\u0001fI\u0001\u0012[\u0016\u001c8/Y4f\u0013\u00124\u0015m\u0019;pef\u0004\u0013\u0001E7fgN\fw-Z%e\u001b\u0006t\u0017mZ3s+\u0005y\u0003C\u0001\u00192\u001b\u0005)\u0013B\u0001\u001a&\u0005AiUm]:bO\u0016LE-T1oC\u001e,'/A\tnKN\u001c\u0018mZ3JI6\u000bg.Y4fe\u0002\na\u0001P5oSRtDc\u0001\u001c8qA\u00111\u0004\u0001\u0005\u0006=\u0015\u0001\r\u0001\t\u0005\u0006[\u0015\u0001\ra\f\u0015\u0003\u000bi\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\r%t'.Z2u\u0015\u0005y\u0014a\u00026bW\u0006\u0014H/Y\u0005\u0003\u0003r\u0012a!\u00138kK\u000e$\u0018a\u0002:fg>dg/\u001a\u000b\u0004\t\u001e{\u0005CA\u000eF\u0013\t1\u0005B\u0001\u000bCY>\u0014'+Z:pYV$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006\u0011\u001a\u0001\r!S\u0001\u0007E2|'-\u00133\u0011\u0005)kU\"A&\u000b\u00051S\u0011\u0001B7bS2L!AT&\u0003\r\tcwNY%e\u0011\u0015\u0001f\u00011\u0001R\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004\"\u0001\r*\n\u0005M+#AD'bS2\u0014w\u000e_*fgNLwN\u001c")
public class MessageBlobResolver
implements BlobResolver {
    private final MessageId.Factory messageIdFactory;
    private final MessageIdManager messageIdManager;

    public MessageId.Factory messageIdFactory() {
        return this.messageIdFactory;
    }

    public MessageIdManager messageIdManager() {
        return this.messageIdManager;
    }

    @Override
    public BlobResolutionResult resolve(BlobId blobId, MailboxSession mailboxSession) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.messageIdFactory().fromString(blobId.value()));
        if (try_ instanceof Failure) {
            return NonApplicable$.MODULE$;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            MessageId messageId = (MessageId)success.value();
            return new Applicable((SMono<Blob>)SMono$.MODULE$.fromPublisher(this.messageIdManager().getMessagesReactive((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)messageId, (List)Nil$.MODULE$)).asJava(), FetchGroup.FULL_CONTENT, mailboxSession)).map((Function1 & Serializable)x$1 -> new MessageBlob(blobId, (MessageResult)x$1)).switchIfEmpty(SMono$.MODULE$.error((Throwable)new BlobNotFoundException(blobId))));
        }
        throw new MatchError((Object)try_);
    }

    @Inject
    public MessageBlobResolver(MessageId.Factory messageIdFactory, MessageIdManager messageIdManager) {
        this.messageIdFactory = messageIdFactory;
        this.messageIdManager = messageIdManager;
    }
}

