/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Set;
import org.apache.james.jmap.core.CapabilityFactory;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.ErrorCode$InvalidResultReference$;
import org.apache.james.jmap.core.ErrorCode$ServerFail$;
import org.apache.james.jmap.core.ErrorCode$UnknownMethod$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.MissingCapabilityException;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.routes.InvalidResultReferenceException;
import org.apache.james.jmap.routes.JMAPApi$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.UnsupportedCapabilitiesException;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SFluxLike;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%\ta\u000b\u0005\u0007e\u0005\u0001\u000b\u0011\u0002\u0017\u0007\t\u0001\u001a\u0002a\r\u0005\ti\u0015\u0011\t\u0011)A\u0005k!Aa)\u0002B\u0001B\u0003%q\t\u0003\u0005\\\u000b\t\u0005\t\u0015!\u0003]\u0011\u0015AS\u0001\"\u0001a\u0011\u001d)WA1A\u0005\n\u0019Da!]\u0003!\u0002\u00139\u0007\"\u0002\u0015\u0006\t\u0003\u0011\bbBA\r\u000b\u0011\u0005\u00111\u0004\u0005\b\u0003#*A\u0011BA*\u0011\u001d\tI\"\u0002C\u0005\u0003\u0003Cq!!%\u0006\t\u0013\t\u0019\nC\u0004\u0002\u001c\u0016!I!!(\u0002\u000f)k\u0015\tU!qS*\u0011A#F\u0001\u0007e>,H/Z:\u000b\u0005Y9\u0012\u0001\u00026nCBT!\u0001G\r\u0002\u000b)\fW.Z:\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001!\ty\u0012!D\u0001\u0014\u0005\u001dQU*\u0011)Ba&\u001c\"!\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta$\u0001\u0004M\u001f\u001e;UIU\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011qfG\u0001\u0006g24GG[\u0005\u0003c9\u0012a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\n\u0003\u000b\t\nq!\\3uQ>$7\u000fE\u00027{\u0001s!aN\u001e\u0011\u0005a\"S\"A\u001d\u000b\u0005ij\u0012A\u0002\u001fs_>$h(\u0003\u0002=I\u00051\u0001K]3eK\u001aL!AP \u0003\u0007M+GO\u0003\u0002=IA\u0011\u0011\tR\u0007\u0002\u0005*\u00111)F\u0001\u0007[\u0016$\bn\u001c3\n\u0005\u0015\u0013%AB'fi\"|G-A\neK\u001a\fW\u000f\u001c;DCB\f'-\u001b7ji&,7\u000fE\u00027{!\u0003\"!\u0013-\u000f\u0005)+fBA&T\u001d\ta%K\u0004\u0002N#:\u0011a\n\u0015\b\u0003q=K\u0011\u0001H\u0005\u00035mI!\u0001G\r\n\u0005Y9\u0012B\u0001+\u0016\u0003\u0011\u0019wN]3\n\u0005Y;\u0016\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'O\u0003\u0002U+%\u0011\u0011L\u0017\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\u0005Y;\u0016!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002^=6\tq+\u0003\u0002`/\nA\"*\\1q%\u001a\u001c\u0007H\u000e\u001a2\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005\u00147\r\u001a\t\u0003?\u0015AQ\u0001N\u0005A\u0002UBQAR\u0005A\u0002\u001dCQaW\u0005A\u0002q\u000bQ\"\\3uQ>$7OQ=OC6,W#A4\u0011\tYB'\u000eQ\u0005\u0003S~\u00121!T1q!\tYgN\u0004\u0002KY&\u0011QnV\u0001\u000b\u0013:4xnY1uS>t\u0017BA8q\u0005)iU\r\u001e5pI:\u000bW.\u001a\u0006\u0003[^\u000ba\"\\3uQ>$7OQ=OC6,\u0007\u0005F\u0003bgr\f)\u0001C\u0003u\u0019\u0001\u0007Q/A\u0006kCZ\fW*\u001a;i_\u0012\u001c\bc\u0001<|\u00016\tqO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!AP<\t\u000bud\u0001\u0019\u0001@\u0002+M,\b\u000f]8si\u0016$7)\u00199bE&d\u0017\u000e^5fgB\u0019ao_@\u0011\u0007u\u000b\t!C\u0002\u0002\u0004]\u0013\u0011cQ1qC\nLG.\u001b;z\r\u0006\u001cGo\u001c:z\u0011\u0015YF\u00021\u0001]Q\ra\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0019IgN[3di*\u0011\u00111C\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\t9\"!\u0004\u0003\r%s'.Z2u\u0003\u001d\u0001(o\\2fgN$b!!\b\u00028\u0005\u0005\u0003CBA\u0010\u0003[\t\t$\u0004\u0002\u0002\")!\u00111EA\u0013\u0003%\u0001XO\u00197jg\",'OC\u0002&\u0003OQ1\u0001VA\u0015\u0015\t\tY#A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005=\u0012\u0011\u0005\u0002\u0006'6{gn\u001c\t\u0004;\u0006M\u0012bAA\u001b/\nq!+Z:q_:\u001cXm\u00142kK\u000e$\bbBA\u001d\u001b\u0001\u0007\u00111H\u0001\u000ee\u0016\fX/Z:u\u001f\nTWm\u0019;\u0011\u0007u\u000bi$C\u0002\u0002@]\u0013QBU3rk\u0016\u001cHo\u00142kK\u000e$\bbBA\"\u001b\u0001\u0007\u0011QI\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&/\u00059Q.Y5mE>D\u0018\u0002BA(\u0003\u0013\u0012a\"T1jY\n|\u0007pU3tg&|g.A\u0012qe>\u001cWm]:TKF,XM\u001c;jC2d\u00170\u00118e+B$\u0017\r^3D_:$X\r\u001f;\u0015\u0015\u0005U\u0013qNA9\u0003g\ni\b\u0005\u0004\u0002 \u00055\u0012q\u000b\t\u0007\u00033\n\u0019'!\u001b\u000f\t\u0005m\u0013q\f\b\u0004q\u0005u\u0013\"A\u0013\n\u0007\u0005\u0005D%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\u0004'\u0016\f(bAA1IA\u0019\u0011)a\u001b\n\u0007\u00055$IA\u000bJ]Z|7-\u0019;j_:<\u0016\u000e\u001e5D_:$X\r\u001f;\t\u000f\u0005eb\u00021\u0001\u0002<!9\u00111\t\bA\u0002\u0005\u0015\u0003bBA;\u001d\u0001\u0007\u0011qO\u0001\u0012aJ|7-Z:tS:<7i\u001c8uKb$\bcA\u0010\u0002z%\u0019\u00111P\n\u0003#A\u0013xnY3tg&twmQ8oi\u0016DH\u000f\u0003\u0004\u0002\u00009\u0001\raR\u0001\rG\u0006\u0004\u0018MY5mSRLWm\u001d\u000b\t\u0003\u0007\u000bI)a#\u0002\u000eB1\u0011qDAC\u0003SJA!a\"\u0002\"\t)1K\u00127vq\"1\u0011qP\bA\u0002\u001dCq!a\u0011\u0010\u0001\u0004\t)\u0005C\u0004\u0002\u0010>\u0001\r!!\u001b\u0002\u0015%tgo\\2bi&|g.\u0001\u000eqe>\u001cWm]:NKRDw\u000eZ,ji\"l\u0015\r^2i\u001d\u0006lW\r\u0006\u0005\u0002\u0004\u0006U\u0015qSAM\u0011\u0019\ty\b\u0005a\u0001\u000f\"9\u0011q\u0012\tA\u0002\u0005%\u0004bBA\"!\u0001\u0007\u0011QI\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0015\r\u0005}\u0015\u0011WAZ!!\tI&!)\u0002&\u0006-\u0016\u0002BAR\u0003O\u0012a!R5uQ\u0016\u0014\bcA/\u0002(&\u0019\u0011\u0011V,\u000355K7o]5oO\u000e\u000b\u0007/\u00192jY&$\u00180\u0012=dKB$\u0018n\u001c8\u0011\u0007\r\ni+C\u0002\u00020\u0012\u0012A!\u00168ji\"1\u0011qP\tA\u0002\u001dCa!!.\u0012\u0001\u00049\u0015\u0001\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7\u000f")
public class JMAPApi {
    private final scala.collection.immutable.Set<Refined<String, string.Uri>> defaultCapabilities;
    private final JmapRfc8621Configuration configuration;
    private final Map<Invocation.MethodName, Method> methodsByName;

    public static Logger LOGGER() {
        return JMAPApi$.MODULE$.LOGGER();
    }

    private Map<Invocation.MethodName, Method> methodsByName() {
        return this.methodsByName;
    }

    public SMono<ResponseObject> process(RequestObject requestObject, MailboxSession mailboxSession) {
        ProcessingContext processingContext = new ProcessingContext((Map<ClientId, ServerId>)Predef$.MODULE$.Map().empty(), (Map<Invocation.MethodCallId, Invocation>)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Set unsupportedCapabilities = (scala.collection.immutable.Set)requestObject.using().$minus$minus(this.defaultCapabilities);
        scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities = requestObject.using();
        if (unsupportedCapabilities.nonEmpty()) {
            return SMono$.MODULE$.error((Throwable)new UnsupportedCapabilitiesException((scala.collection.immutable.Set<Refined<String, string.Uri>>)unsupportedCapabilities));
        }
        return this.processSequentiallyAndUpdateContext(requestObject, mailboxSession, processingContext, capabilities).map((Function1 & Serializable)invocations -> new ResponseObject(ResponseObject$.MODULE$.SESSION_STATE(), (Seq<Invocation>)((Seq)invocations.map((Function1 & Serializable)x$1 -> x$1.invocation()))));
    }

    private SMono<Seq<InvocationWithContext>> processSequentiallyAndUpdateContext(RequestObject requestObject, MailboxSession mailboxSession, ProcessingContext processingContext, scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities) {
        return SFlux$.MODULE$.fromIterable(requestObject.methodCalls()).fold((Object)Nil$.MODULE$, (Function2 & Serializable)(acc, elem) -> {
            SMono lastProcessingContext = (SMono)acc.headOption().map((Function1 & Serializable)last -> SMono$.MODULE$.fromPublisher((Publisher)Flux.from((Publisher)last.map((Function1 & Serializable)x$2 -> x$2.processingContext())).last())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)processingContext));
            SFlux invocation = lastProcessingContext.flatMapMany((Function1 & Serializable)context -> this.process(capabilities, mailboxSession, new InvocationWithContext((Invocation)elem, (ProcessingContext)context)));
            SFlux sFlux = invocation.cache(invocation.cache$default$1(), invocation.cache$default$2());
            return acc.$colon$colon((Object)sFlux);
        }).map((Function1 & Serializable)x$3 -> x$3.reverse()).flatMap((Function1 & Serializable)list -> {
            SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)list);
            Function1 & Serializable x$1 = (Function1 & Serializable)e -> e;
            int x$2 = qual$1.concatMap$default$2();
            return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
        });
    }

    private SFlux<InvocationWithContext> process(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession, InvocationWithContext invocation) {
        SFlux sFlux;
        Either<InvalidResultReferenceException, Invocation> either = invocation.processingContext().resolveBackReferences(invocation.invocation());
        if (either instanceof Left) {
            Left left = (Left)either;
            InvalidResultReferenceException e = (InvalidResultReferenceException)left.value();
            sFlux = SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidResultReference$.MODULE$, "Failed resolving back-reference: " + e.message(), invocation.invocation().methodCallId()), invocation.processingContext())}));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Invocation resolvedInvocation = (Invocation)right.value();
            sFlux = this.processMethodWithMatchName(capabilities, new InvocationWithContext(resolvedInvocation, invocation.processingContext()), mailboxSession).map((Function1 & Serializable)x$4 -> x$4.recordInvocation());
        } else {
            throw new MatchError(either);
        }
        return SFlux$.MODULE$.fromPublisher((Publisher)sFlux);
    }

    private SFlux<InvocationWithContext> processMethodWithMatchName(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return ((SFluxLike)this.methodsByName().get((Object)invocation.invocation().methodName()).map((Function1 & Serializable)method -> (SFlux)this.validateCapabilities(capabilities, method.requiredCapabilities()).fold((Function1 & Serializable)e -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, e.description(), invocation.invocation().methodCallId()), invocation.processingContext())})), (Function1 & Serializable)x$5 -> SFlux$.MODULE$.fromPublisher(method.process(capabilities, invocation, mailboxSession)))).getOrElse((Function0 & Serializable)() -> SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, invocation.invocation().methodCallId()), invocation.processingContext())})))).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.just((Object)new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$ServerFail$.MODULE$, throwable.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())));
    }

    private Either<MissingCapabilityException, BoxedUnit> validateCapabilities(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities) {
        scala.collection.immutable.Set missingCapabilities = (scala.collection.immutable.Set)requiredCapabilities.$minus$minus(capabilities).$plus$plus((IterableOnce)this.configuration.disabledCapabilities().intersect(capabilities));
        if (missingCapabilities.nonEmpty()) {
            return new Left((Object)new MissingCapabilityException("Missing capability(ies): " + missingCapabilities.mkString(", ")));
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    public JMAPApi(scala.collection.immutable.Set<Method> methods, scala.collection.immutable.Set<Refined<String, string.Uri>> defaultCapabilities, JmapRfc8621Configuration configuration) {
        this.defaultCapabilities = defaultCapabilities;
        this.configuration = configuration;
        this.methodsByName = ((IterableOnceOps)methods.map((Function1 & Serializable)method -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)method.methodName()), method))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Inject
    public JMAPApi(Set<Method> javaMethods, Set<CapabilityFactory> supportedCapabilities, JmapRfc8621Configuration configuration) {
        this((scala.collection.immutable.Set<Method>)CollectionConverters$.MODULE$.SetHasAsScala(javaMethods).asScala().toSet(), (scala.collection.immutable.Set<Refined<String, string.Uri>>)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(supportedCapabilities).asScala().map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final String apply(CapabilityFactory x) {
                return x.id();
            }
        })).toSet(), configuration);
    }
}

