/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.google.common.base.CharMatcher;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.routes.Blob;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.jmap.routes.DownloadRoutes$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import shapeless._0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015v!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u0015\u0006\u0001\u000b\u0011\u0002#\t\u000f-\u000b!\u0019!C\u0001\u0019\"1\u0001+\u0001Q\u0001\n53A\u0001O\u0016\u0001#\"Aal\u0002BC\u0002\u0013\u0005q\f\u0003\u0005g\u000f\t\u0005\t\u0015!\u0003a\u0011!9wA!b\u0001\n\u0003A\u0007\u0002\u00037\b\u0005\u0003\u0005\u000b\u0011B5\t\u00115<!Q1A\u0005\u00029D\u0001\"^\u0004\u0003\u0002\u0003\u0006Ia\u001c\u0005\tm\u001e\u0011)\u0019!C\u0001o\"I\u0011\u0011A\u0004\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u0007\u0001\u001e!\t!a\u0001\t\u0013\u0005=rA1A\u0005\n\u0005E\u0002\u0002CA%\u000f\u0001\u0006I!a\r\t\u0013\u0005-sA1A\u0005\n\u0005E\u0002\u0002CA'\u000f\u0001\u0006I!a\r\t\u0013\u0005=sA1A\u0005\n\u0005E\u0002\u0002CA)\u000f\u0001\u0006I!a\r\t\u0013\u0005MsA1A\u0005\n\u0005E\u0002\u0002CA+\u000f\u0001\u0006I!a\r\t\u0013\u0005]sA1A\u0005\n\u0005e\u0003\u0002CA0\u000f\u0001\u0006I!a\u0017\t\u0013\u0005\u0005tA1A\u0005\n\u0005\r\u0004\u0002CA6\u000f\u0001\u0006I!!\u001a\t\r1:A\u0011IA7\u0011\u001d\t)i\u0002C\u0005\u0003\u000fCq!!\"\b\t\u0013\t\t\rC\u0004\u0002j\u001e!I!a;\t\u000f\u0005Mx\u0001\"\u0003\u0002v\"9!QD\u0004\u0005\n\t}\u0001b\u0002B\u0015\u000f\u0011%!1\u0006\u0005\b\u0005c9A\u0011\u0002B\u001a\u0011\u001d\u0011ig\u0002C\u0005\u0005_BqA!\u001f\b\t\u0013\u0011Y\bC\u0004\u0003\u0000\u001d!IA!!\t\u000f\t}t\u0001\"\u0003\u0003\f\"9!1S\u0004\u0005\n\tU\u0015A\u0004#po:dw.\u00193S_V$Xm\u001d\u0006\u0003Y5\naA]8vi\u0016\u001c(B\u0001\u00180\u0003\u0011QW.\u00199\u000b\u0005A\n\u0014!\u00026b[\u0016\u001c(B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00028\u00035\t1F\u0001\bE_^tGn\\1e%>,H/Z:\u0014\u0005\u0005Q\u0004CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002m\u00051AjT$H\u000bJ+\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fN\nQa\u001d7gi)L!!\u0013$\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\n1BQ+G\r\u0016\u0013vlU%[\u000bV\tQ\n\u0005\u0002<\u001d&\u0011q\n\u0010\u0002\u0004\u0013:$\u0018\u0001\u0004\"V\r\u001a+%kX*J5\u0016\u00033cA\u0004S5B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&AB(cU\u0016\u001cG\u000f\u0005\u0002\\96\tQ&\u0003\u0002^[\tQ!*T!Q%>,H/Z:\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2.\u0003\u0011AG\u000f\u001e9\n\u0005\u0015\u0014'!D!vi\",g\u000e^5dCR|'/\u0001\bbkRDWM\u001c;jG\u0006$xN\u001d\u0011\u0002\u001b\tdwN\u0019*fg>dg/\u001a:t+\u0005I\u0007CA\u001ck\u0013\tY7FA\u0007CY>\u0014'+Z:pYZ,'o]\u0001\u000fE2|'MU3t_24XM]:!\u0003E\u0019Xm]:j_:$&/\u00198tY\u0006$xN]\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!/L\u0001\u0005G>\u0014X-\u0003\u0002uc\n\t2+Z:tS>tGK]1og2\fGo\u001c:\u0002%M,7o]5p]R\u0013\u0018M\\:mCR|'\u000fI\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0007\u0005\u0004\u0018N\u0003\u0002~_\u00059Q.\u001a;sS\u000e\u001c\u0018BA@{\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004CCCA\u0003\u0003\u000f\t\t#a\t\u0002&A\u0011qg\u0002\u0005\u0006=B\u0001\r\u0001\u0019\u0015\t\u0003\u000f\tY!a\u0007\u0002\u001eA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0002\u0016\u00059!.Y6beR\f\u0017\u0002BA\r\u0003\u001f\u0011QAT1nK\u0012\fQA^1mk\u0016\f#!a\b\u0002\u0011I35)\f\u001d7eEBQa\u001a\tA\u0002%DQ!\u001c\tA\u0002=DQA\u001e\tA\u0002aD3\u0001EA\u0015!\u0011\ti!a\u000b\n\t\u00055\u0012q\u0002\u0002\u0007\u0013:TWm\u0019;\u0002\u001d\u0005\u001c7m\\;oi&#\u0007+\u0019:b[V\u0011\u00111\u0007\t\u0005\u0003k\t\u0019E\u0004\u0003\u00028\u0005}\u0002cAA\u001dy5\u0011\u00111\b\u0006\u0004\u0003{)\u0014A\u0002\u001fs_>$h(C\u0002\u0002Bq\na\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!y\u0005y\u0011mY2pk:$\u0018\n\u001a)be\u0006l\u0007%A\u0006cY>\u0014\u0017\n\u001a)be\u0006l\u0017\u0001\u00042m_\nLE\rU1sC6\u0004\u0013!\u00038b[\u0016\u0004\u0016M]1n\u0003)q\u0017-\\3QCJ\fW\u000eI\u0001\u0011G>tG/\u001a8u)f\u0004X\rU1sC6\f\u0011cY8oi\u0016tG\u000fV=qKB\u000b'/Y7!\u0003-!wn\u001e8m_\u0006$WK]5\u0016\u0005\u0005m\u0003cA*\u0002^%\u0019\u0011Q\t+\u0002\u0019\u0011|wO\u001c7pC\u0012,&/\u001b\u0011\u0002+A,g\u000eZ5oO\u0012{wO\u001c7pC\u0012lU\r\u001e:jGV\u0011\u0011Q\r\t\u0004s\u0006\u001d\u0014bAA5u\n1Q*\u001a;sS\u000e\fa\u0003]3oI&tw\rR8x]2|\u0017\rZ'fiJL7\r\t\u000b\u0003\u0003_\u0002b!!\u001d\u0002|\u0005}TBAA:\u0015\u0011\t)(a\u001e\u0002\rM$(/Z1n\u0015\r\tIHV\u0001\u0005kRLG.\u0003\u0003\u0002~\u0005M$AB*ue\u0016\fW\u000eE\u0002\\\u0003\u0003K1!a!.\u0005%QU*\u0011)S_V$X-A\u0002hKR$b!!#\u0002\"\u0006]\u0006CBAF\u0003/\u000bY*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003%\u0001XO\u00197jg\",'OC\u0002s\u0003'S!!!&\u0002\u000fI,\u0017m\u0019;pe&!\u0011\u0011TAG\u0005\u0011iuN\\8\u0011\u0007M\u000bi*C\u0002\u0002 R\u0013AAV8jI\"9\u00111\u0015\u0010A\u0002\u0005\u0015\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003O\u000b\u0019,\u0004\u0002\u0002**!\u00111VAW\u0003\u0019\u0019XM\u001d<fe*\u00191-a,\u000b\t\u0005E\u00161S\u0001\u0006]\u0016$H/_\u0005\u0005\u0003k\u000bIKA\tIiR\u00048+\u001a:wKJ\u0014V-];fgRDq!!/\u001f\u0001\u0004\tY,\u0001\u0005sKN\u0004xN\\:f!\u0011\t9+!0\n\t\u0005}\u0016\u0011\u0016\u0002\u0013\u0011R$\boU3sm\u0016\u0014(+Z:q_:\u001cX\r\u0006\u0005\u0002D\u0006U\u0017q[Am!\u0019\t)-a3\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u001f\u000bIMC\u0002>\u0003#KA!!4\u0002H\n)1+T8o_B\u00191(!5\n\u0007\u0005MGH\u0001\u0003V]&$\bbBAR?\u0001\u0007\u0011Q\u0015\u0005\b\u0003s{\u0002\u0019AA^\u0011\u001d\tYn\ba\u0001\u0003;\fa\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019oL\u0001\b[\u0006LGNY8y\u0013\u0011\t9/!9\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\u0006Qq-\u001a;JM>;h.\u001a:\u0015\u0011\u0005\r\u0017Q^Ax\u0003cDq!a)!\u0001\u0004\t)\u000bC\u0004\u0002:\u0002\u0002\r!a/\t\u000f\u0005m\u0007\u00051\u0001\u0002^\u0006aAm\\<oY>\fGM\u00117pERQ\u00111YA|\u0005\u0003\u0011\u0019Aa\u0005\t\u000f\u0005e\u0018\u00051\u0001\u0002|\u0006aq\u000e\u001d;j_:\fGNT1nKB)1(!@\u00024%\u0019\u0011q \u001f\u0003\r=\u0003H/[8o\u0011\u001d\tI,\ta\u0001\u0003wCqA!\u0002\"\u0001\u0004\u00119!A\bcY>\u00147i\u001c8uK:$H+\u001f9f!\u0011\u0011IAa\u0004\u000e\u0005\t-!\u0002\u0002B\u0007\u0003C\fQ!\\8eK2LAA!\u0005\u0003\f\tY1i\u001c8uK:$H+\u001f9f\u0011\u001d\u0011)\"\ta\u0001\u0005/\tAA\u00197pEB\u0019qG!\u0007\n\u0007\tm1F\u0001\u0003CY>\u0014\u0017aG1eI\u000e{g\u000e^3oi\u0012K7\u000f]8tSRLwN\u001c%fC\u0012,'\u000f\u0006\u0003\u0003\"\t\u001d\u0002cB\u001e\u0003$\u0005m\u00161X\u0005\u0004\u0005Ka$!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\tIP\ta\u0001\u0003w\f1c]1oSRL'0\u001a%fC\u0012,'OV1mk\u0016$B!a\r\u0003.!9!qF\u0012A\u0002\u0005M\u0012!A:\u0002-\u0005$GmQ8oi\u0016tG\u000fT3oORD\u0007*Z1eKJ$BA!\t\u00036!9!q\u0007\u0013A\u0002\te\u0012aB:ju\u0016$&/\u001f\t\u0007\u0005w\u0011yDa\u0011\u000e\u0005\tu\"bAA=y%!!\u0011\tB\u001f\u0005\r!&/\u001f\t\u0005\u0005\u000b\u00129G\u0004\u0003\u0003H\t\u0005d\u0002\u0002B%\u0005;rAAa\u0013\u0003\\9!!Q\nB-\u001d\u0011\u0011yEa\u0016\u000f\t\tE#Q\u000b\b\u0005\u0003s\u0011\u0019&C\u00015\u0013\t\u00114'\u0003\u00021c%\u0011afL\u0005\u0003w6JAA!\u0004\u0003`)\u001110L\u0005\u0005\u0005G\u0012)'\u0001\u0003TSj,'\u0002\u0002B\u0007\u0005?JAA!\u001b\u0003l\t!1+\u001b>f\u0015\u0011\u0011\u0019G!\u001a\u0002Y\u0005$GmQ8oi\u0016tG\u000fR5ta>\u001c\u0018\u000e^5p]\"+\u0017\rZ3s%\u0016<\u0017M\u001d3j]\u001e,enY8eS:<GCBA^\u0005c\u0012)\bC\u0004\u0003t\u0015\u0002\r!a\r\u0002\t9\fW.\u001a\u0005\b\u0005o*\u0003\u0019AA^\u0003\u0011\u0011Xm\u001d9\u0002\u001f\u0015t7m\u001c3fI\u001aKG.\u001a(b[\u0016$B!a\u0017\u0003~!9!1\u000f\u0014A\u0002\u0005M\u0012AC9vKJL\b+\u0019:b[R1\u00111 BB\u0005\u000fCqA!\"(\u0001\u0004\t)+A\u0006iiR\u0004(+Z9vKN$\bb\u0002BEO\u0001\u0007\u00111G\u0001\u000ea\u0006\u0014\u0018-\\3uKJt\u0015-\\3\u0015\r\u0005m(Q\u0012BH\u0011\u001d\u0011I\t\u000ba\u0001\u0003gAqA!%)\u0001\u0004\t\u0019$A\u0002ve&\faB]3ta>tG\rR3uC&d7\u000f\u0006\u0004\u0002D\n]%1\u0014\u0005\b\u00053K\u0003\u0019AA^\u0003IAG\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\t\u000f\tu\u0015\u00061\u0001\u0003 \u00069A-\u001a;bS2\u001c\bc\u00019\u0003\"&\u0019!1U9\u0003\u001dA\u0013xN\u00197f[\u0012+G/Y5mg\u0002")
public class DownloadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final BlobResolvers blobResolvers;
    private final SessionTranslator sessionTranslator;
    private final MetricFactory metricFactory;
    private final String accountIdParam;
    private final String blobIdParam;
    private final String nameParam;
    private final String contentTypeParam;
    private final String downloadUri;
    private final Metric pendingDownloadMetric;

    public static int BUFFER_SIZE() {
        return DownloadRoutes$.MODULE$.BUFFER_SIZE();
    }

    public static Logger LOGGER() {
        return DownloadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleInternalError(response, logger, e);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleBadRequest(response, logger, e);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse response, Logger logger, Throwable e) {
        return super.handleAuthenticationFailure(response, logger, e);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public BlobResolvers blobResolvers() {
        return this.blobResolvers;
    }

    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String blobIdParam() {
        return this.blobIdParam;
    }

    private String nameParam() {
        return this.nameParam;
    }

    private String contentTypeParam() {
        return this.contentTypeParam;
    }

    private String downloadUri() {
        return this.downloadUri;
    }

    private Metric pendingDownloadMetric() {
        return this.pendingDownloadMetric;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, this.downloadUri())).action((request, response) -> this.get(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.downloadUri())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private Mono<Void> get(HttpServerRequest request, HttpServerResponse response) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getIfOwner(request, response, (MailboxSession)mailboxSession)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ForbiddenException ? true : throwable instanceof AccountNotFoundException) {
                HttpResponseStatus x$1 = HttpResponseStatus.FORBIDDEN;
                String x$2 = "You cannot download in others accounts";
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$3, x$1, x$4, "You cannot download in others accounts"));
            }
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                DownloadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$5 = HttpResponseStatus.UNAUTHORIZED;
                String x$6 = unauthorizedException.getMessage();
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$7, x$5, x$8, x$6));
            }
            if (throwable instanceof BlobNotFoundException) {
                HttpResponseStatus x$9 = HttpResponseStatus.NOT_FOUND;
                String x$10 = "The resource could not be found";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "The resource could not be found"));
            }
            DownloadRoutes$.MODULE$.LOGGER().error("Unexpected error upon download {}", (Object)request.uri(), (Object)throwable);
            HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$14 = throwable.getMessage();
            String x$15 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14));
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).asJava().then();
    }

    private SMono<BoxedUnit> get(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        return ((SMono)BlobId$.MODULE$.of(request.param((CharSequence)this.blobIdParam())).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)x$4 -> this.blobResolvers().resolve((BlobId)x$4, mailboxSession).doOnSubscribe((Function1 & Serializable)x$5 -> {
            DownloadRoutes.$anonfun$get$5(this, x$5);
            return BoxedUnit.UNIT;
        }))).flatMap((Function1 & Serializable)blob -> this.downloadBlob(this.queryParam(request, this.nameParam()), response, (ContentType)this.queryParam(request, this.contentTypeParam()).map((Function1 & Serializable)value -> ContentType.of((String)value)).getOrElse((Function0 & Serializable)() -> blob.contentType()), (Blob)blob).then()).doOnSuccess((Function1 & Serializable)x$6 -> {
            DownloadRoutes.$anonfun$get$9(this, x$6);
            return BoxedUnit.UNIT;
        });
    }

    private SMono<BoxedUnit> getIfOwner(HttpServerRequest request, HttpServerResponse response, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            return this.sessionTranslator().delegateIfNeeded(mailboxSession, new AccountId(string2)).flatMap((Function1 & Serializable)session -> this.get(request, response, (MailboxSession)session));
        }
        if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            return SMono$.MODULE$.error((Throwable)illegalArgumentException);
        }
        throw new MatchError(either);
    }

    private SMono<BoxedUnit> downloadBlob(Option<String> optionalName, HttpServerResponse response, ContentType blobContentType, Blob blob) {
        Callable<InputStream> resourceSupplier = () -> blob.content();
        Function<InputStream, Mono> sourceSupplier = stream -> SMono$.MODULE$.apply((Publisher)((HttpServerResponse)this.addContentDispositionHeader(optionalName).compose(this.addContentLengthHeader(blob.size())).apply((Object)response)).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)this.sanitizeHeaderValue(blobContentType.asString())).status(HttpResponseStatus.OK).send((Publisher)ReactorUtils.toChunks((InputStream)stream, (int)DownloadRoutes$.MODULE$.BUFFER_SIZE()).map(x$7 -> Unpooled.wrappedBuffer((ByteBuffer)x$7)).subscribeOn(Schedulers.boundedElastic()))).asJava();
        Consumer<InputStream> resourceRelease = stream -> stream.close();
        return SMono$.MODULE$.fromPublisher((Publisher)Mono.using(resourceSupplier, sourceSupplier, resourceRelease)).then();
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentDispositionHeader(Option<String> optionalName) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)optionalName.map((Function1 & Serializable)x$8 -> this.addContentDispositionHeaderRegardingEncoding((String)x$8, (HttpServerResponse)resp)).getOrElse((Function0 & Serializable)() -> resp);
    }

    private String sanitizeHeaderValue(String s) {
        if (HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)s) == -1) {
            return s;
        }
        return "application/octet-stream";
    }

    private Function1<HttpServerResponse, HttpServerResponse> addContentLengthHeader(Try<Refined<Object, boolean.Not<numeric.Less<_0>>>> sizeTry) {
        return (Function1 & Serializable)resp -> (HttpServerResponse)sizeTry.map((Function1 & Serializable)size -> resp.header((CharSequence)"Content-Length", (CharSequence)((Long)((Refined)size).value()).toString())).getOrElse((Function0 & Serializable)() -> resp);
    }

    private HttpServerResponse addContentDispositionHeaderRegardingEncoding(String name, HttpServerResponse resp) {
        if (CharMatcher.ascii().matchesAllOf((CharSequence)name)) {
            return (HttpServerResponse)Try$.MODULE$.apply((Function0 & Serializable)() -> resp.header((CharSequence)"Content-Disposition", (CharSequence)("attachment; filename=\"" + name + "\""))).getOrElse((Function0 & Serializable)() -> resp.header((CharSequence)"Content-Disposition", (CharSequence)this.encodedFileName(name)));
        }
        return resp.header((CharSequence)"Content-Disposition", (CharSequence)this.encodedFileName(name));
    }

    private String encodedFileName(String name) {
        return "attachment; filename*=\"" + EncoderUtil.encodeEncodedWord((String)name, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN) + "\"";
    }

    private Option<String> queryParam(HttpServerRequest httpRequest, String parameterName) {
        return this.queryParam(parameterName, httpRequest.uri());
    }

    private Option<String> queryParam(String parameterName, String uri) {
        return Option$.MODULE$.apply(new QueryStringDecoder(uri).parameters().get(parameterName)).toList().flatMap((Function1 & Serializable)x$9 -> CollectionConverters$.MODULE$.ListHasAsScala(x$9).asScala()).headOption();
    }

    private SMono<BoxedUnit> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$10 -> x$10.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()).then());
    }

    public static final /* synthetic */ void $anonfun$get$5(DownloadRoutes $this, Subscription x$5) {
        $this.pendingDownloadMetric().increment();
    }

    public static final /* synthetic */ void $anonfun$get$9(DownloadRoutes $this, BoxedUnit x$6) {
        $this.pendingDownloadMetric().decrement();
    }

    @Inject
    public DownloadRoutes(@Named(value="RFC-8621") Authenticator authenticator, BlobResolvers blobResolvers, SessionTranslator sessionTranslator, MetricFactory metricFactory) {
        this.authenticator = authenticator;
        this.blobResolvers = blobResolvers;
        this.sessionTranslator = sessionTranslator;
        this.metricFactory = metricFactory;
        this.accountIdParam = "accountId";
        this.blobIdParam = "blobId";
        this.nameParam = "name";
        this.contentTypeParam = "type";
        this.downloadUri = "/download/{" + this.accountIdParam() + "}/{" + this.blobIdParam() + "}";
        this.pendingDownloadMetric = metricFactory.generate("jmap_pending_downloads");
    }
}

