/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Set;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionNotFoundException;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.model.VerificationCode;
import org.apache.james.jmap.api.model.VerificationCode$;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.core.PushSubscriptionPatchObject;
import org.apache.james.jmap.core.PushSubscriptionSetRequest;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UnparsedPushSubscriptionId;
import org.apache.james.jmap.core.ValidatedPushSubscriptionPatchObject;
import org.apache.james.jmap.method.PushSubscriptionSetUpdatePerformer;
import org.apache.james.jmap.method.PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateResults$;
import org.apache.james.jmap.method.PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateSuccess$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\u0006\f\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tM\u0001\u0011\t\u0011)A\u0005O!)Q\u0006\u0001C\u0001]!)A\b\u0001C\u0001{!)A\u000e\u0001C\u0005[\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003{\u0001A\u0011BA \u0011\u001d\ty\u0005\u0001C\u0005\u0003#\u0012q\u0004U;tQN+(m]2sSB$\u0018n\u001c8Va\u0012\fG/\u001a)fe\u001a|'/\\3s\u0015\taQ\"\u0001\u0004nKRDw\u000e\u001a\u0006\u0003\u001d=\tAA[7ba*\u0011\u0001#E\u0001\u0006U\u0006lWm\u001d\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u000eqkND7+\u001e2tGJL\u0007\u000f^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u0001\u0002/^:igV\u00147o\u0019:jaRLwN\u001c\u0006\u0003G5\t1!\u00199j\u0013\t)\u0003E\u0001\u000eQkND7+\u001e2tGJL\u0007\u000f^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\tusB,7\u000b^1uK\u001a\u000b7\r^8ssB\u0011\u0001fK\u0007\u0002S)\u0011!FI\u0001\u0007G\"\fgnZ3\n\u00051J#\u0001\u0005+za\u0016\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0019q&\r\u001a\u0011\u0005A\u0002Q\"A\u0006\t\u000bu\u0019\u0001\u0019\u0001\u0010\t\u000b\u0019\u001a\u0001\u0019A\u0014)\u0005\r!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0019IgN[3di*\t\u0011(A\u0004kC.\f'\u000f^1\n\u0005m2$AB%oU\u0016\u001cG/\u0001\u0004va\u0012\fG/\u001a\u000b\u0004}u#\u0007cA H\u00136\t\u0001I\u0003\u0002B\u0005\u0006I\u0001/\u001e2mSNDWM\u001d\u0006\u00035\rS!\u0001R#\u0002\t\r|'/\u001a\u0006\u0002\r\u00069!/Z1di>\u0014\u0018B\u0001%A\u0005\u0015\u0019Vj\u001c8p!\tQ%L\u0004\u0002L1:\u0011Aj\u0016\b\u0003\u001bZs!AT+\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*\u0016\u0003\u0019a$o\\8u}%\tA#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003\u001d=I!\u0001D\u0007\n\u0005e[\u0011A\t)vg\"\u001cVOY:de&\u0004H/[8o'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'/\u0003\u0002\\9\ni\u0002+^:i'V\u00147o\u0019:jaRLwN\\+qI\u0006$XMU3tk2$8O\u0003\u0002Z\u0017!)a\f\u0002a\u0001?\u0006Q\u0002/^:i'V\u00147o\u0019:jaRLwN\\*fiJ+\u0017/^3tiB\u0011\u0001MY\u0007\u0002C*\u0011A)D\u0005\u0003G\u0006\u0014!\u0004U;tQN+(m]2sSB$\u0018n\u001c8TKR\u0014V-];fgRDQ!\u001a\u0003A\u0002\u0019\fa\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j\u001f\u00059Q.Y5mE>D\u0018BA6i\u00059i\u0015-\u001b7c_b\u001cVm]:j_:\fa#\u001e9eCR,\u0007+^:i'V\u00147o\u0019:jaRLwN\u001c\u000b\u0005]JTx\u0010E\u0002@\u000f>\u0004\"A\u00139\n\u0005Ed&\u0001\b)vg\"\u001cVOY:de&\u0004H/[8o+B$\u0017\r^3SKN,H\u000e\u001e\u0005\u0006g\u0016\u0001\r\u0001^\u0001\u0003S\u0012\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0012\u0002\u000b5|G-\u001a7\n\u0005e4(A\u0005)vg\"\u001cVOY:de&\u0004H/[8o\u0013\u0012DQa_\u0003A\u0002q\faB^1mS\u0012\fG/\u001a3QCR\u001c\u0007\u000e\u0005\u0002a{&\u0011a0\u0019\u0002%-\u0006d\u0017\u000eZ1uK\u0012\u0004Vo\u001d5Tk\n\u001c8M]5qi&|g\u000eU1uG\"|%M[3di\")Q-\u0002a\u0001M\u00061R\u000f\u001d3bi\u00164VM]5gS\u000e\fG/[8o\u0007>$W\rF\u0004o\u0003\u000b\ty!!\u0007\t\u000f\u0005\u001da\u00011\u0001\u0002\n\u0005\u0001\u0002/^:i'V\u00147o\u0019:jaRLwN\u001c\t\u0004k\u0006-\u0011bAA\u0007m\n\u0001\u0002+^:i'V\u00147o\u0019:jaRLwN\u001c\u0005\b\u0003#1\u0001\u0019AA\n\u0003A1XM]5gS\u000e\fG/[8o\u0007>$W\rE\u0002v\u0003+I1!a\u0006w\u0005A1VM]5gS\u000e\fG/[8o\u0007>$W\rC\u0003f\r\u0001\u0007a-A\u0006va\u0012\fG/\u001a+za\u0016\u001cHc\u00028\u0002 \u0005\u0005\u00121\b\u0005\b\u0003\u000f9\u0001\u0019AA\u0005\u0011\u001d\t\u0019c\u0002a\u0001\u0003K\tQ\u0001^=qKN\u0004b!a\n\u00020\u0005Ub\u0002BA\u0015\u0003W\u0001\"\u0001U\r\n\u0007\u00055\u0012$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\t\u0019DA\u0002TKRT1!!\f\u001a!\r)\u0018qG\u0005\u0004\u0003s1(\u0001\u0003+za\u0016t\u0015-\\3\t\u000b\u0015<\u0001\u0019\u00014\u0002\u001bU\u0004H-\u0019;f\u000bb\u0004\u0018N]3t)\u001dq\u0017\u0011IA\"\u0003\u001bBq!a\u0002\t\u0001\u0004\tI\u0001C\u0004\u0002F!\u0001\r!a\u0012\u0002\u0019%t\u0007/\u001e;FqBL'/Z:\u0011\u0007U\fI%C\u0002\u0002LY\u00141\u0004U;tQN+(m]2sSB$\u0018n\u001c8FqBL'/\u001a3US6,\u0007\"B3\t\u0001\u00041\u0017\u0001\u0007;p!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:,\u0006\u000fZ1uKR9q.a\u0015\u0002V\u0005]\u0003bBA\u0004\u0013\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003\u000bJ\u0001\u0019AA$\u0011\u001d\tI&\u0003a\u0001\u0003\u000f\na\"\u001e9eCR,G-\u0012=qSJ,7\u000f")
public class PushSubscriptionUpdatePerformer {
    private final PushSubscriptionRepository pushSubscriptionRepository;
    private final TypeStateFactory typeStateFactory;

    public SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResults> update(PushSubscriptionSetRequest pushSubscriptionSetRequest, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)pushSubscriptionSetRequest.update().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedPushSubscriptionId unparsedId = (UnparsedPushSubscriptionId)tuple2._1();
                PushSubscriptionPatchObject patch = (PushSubscriptionPatchObject)tuple2._2();
                if (unparsedId != null) {
                    UnparsedPushSubscriptionId unparsedPushSubscriptionId = unparsedId;
                    if (patch != null) {
                        PushSubscriptionPatchObject pushSubscriptionPatchObject = patch;
                        Either either = unparsedPushSubscriptionId.parse().flatMap((Function1 & Serializable)id -> pushSubscriptionPatchObject.validate($this.typeStateFactory).map((Function1 & Serializable)validatedPatch -> this.updatePushSubscription((PushSubscriptionId)id, (ValidatedPushSubscriptionPatchObject)validatedPatch, mailboxSession)));
                        return (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateFailure(unparsedPushSubscriptionId, (Throwable)e)), (Function1 & Serializable)smono -> smono.onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateFailure(unparsedPushSubscriptionId, (Throwable)e))));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateResults$.MODULE$);
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updatePushSubscription(PushSubscriptionId id, ValidatedPushSubscriptionPatchObject validatedPatch, MailboxSession mailboxSession) {
        if (validatedPatch.shouldUpdate()) {
            return SMono$.MODULE$.apply(this.pushSubscriptionRepository.get(mailboxSession.getUser(), (Set)ImmutableSet.of((Object)id))).switchIfEmpty(SMono$.MODULE$.error((Throwable)new PushSubscriptionNotFoundException(id))).flatMap((Function1 & Serializable)pushSubscription -> {
                SFlux qual$1 = SFlux$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Publisher[]{(Publisher)validatedPatch.verificationCodeUpdate().map((Function1 & Serializable)verificationCode -> this.updateVerificationCode(pushSubscription, ((VerificationCode)verificationCode).value(), mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()), (Publisher)validatedPatch.typesUpdate().map((Function1 & Serializable)types -> this.updateTypes((PushSubscription)pushSubscription, (scala.collection.immutable.Set<TypeName>)types, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()), (Publisher)validatedPatch.expiresUpdate().map((Function1 & Serializable)expires -> this.updateExpires((PushSubscription)pushSubscription, (PushSubscriptionExpiredTime)expires, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty())}));
                None$ x$1 = qual$1.last$default$1();
                return qual$1.last((Option)x$1);
            });
        }
        return SMono$.MODULE$.empty();
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updateVerificationCode(PushSubscription pushSubscription, String verificationCode, MailboxSession mailboxSession) {
        if (VerificationCode$.MODULE$.equals$extension(verificationCode, (Object)new VerificationCode(pushSubscription.verificationCode()))) {
            return SMono$.MODULE$.apply(this.pushSubscriptionRepository.validateVerificationCode(mailboxSession.getUser(), pushSubscription.id())).then(SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateSuccess(pushSubscription.id(), PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateSuccess$.MODULE$.apply$default$2())));
        }
        return SMono$.MODULE$.error((Throwable)new PushSubscriptionSetUpdatePerformer.WrongVerificationCodeException());
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updateTypes(PushSubscription pushSubscription, scala.collection.immutable.Set<TypeName> types, MailboxSession mailboxSession) {
        return SMono$.MODULE$.apply(this.pushSubscriptionRepository.updateTypes(mailboxSession.getUser(), pushSubscription.id(), CollectionConverters$.MODULE$.SetHasAsJava(types).asJava())).then(SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateSuccess(pushSubscription.id(), PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateSuccess$.MODULE$.apply$default$2())));
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updateExpires(PushSubscription pushSubscription, PushSubscriptionExpiredTime inputExpires, MailboxSession mailboxSession) {
        return SMono$.MODULE$.apply(this.pushSubscriptionRepository.updateExpireTime(mailboxSession.getUser(), pushSubscription.id(), inputExpires.value())).map((Function1 & Serializable)x$1 -> this.toPushSubscriptionUpdate(pushSubscription, inputExpires, (PushSubscriptionExpiredTime)x$1));
    }

    private PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult toPushSubscriptionUpdate(PushSubscription pushSubscription, PushSubscriptionExpiredTime inputExpires, PushSubscriptionExpiredTime updatedExpires2) {
        return new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateSuccess(pushSubscription.id(), (Option<UTCDate>)new Some((Object)updatedExpires2).filter((Function1 & Serializable)updatedExpires -> BoxesRunTime.boxToBoolean((boolean)PushSubscriptionUpdatePerformer.$anonfun$toPushSubscriptionUpdate$1(inputExpires, updatedExpires))).map((Function1 & Serializable)x$2 -> x$2.value()).map((Function1 & Serializable)x$3 -> new UTCDate((ZonedDateTime)x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$toPushSubscriptionUpdate$1(PushSubscriptionExpiredTime inputExpires$2, PushSubscriptionExpiredTime updatedExpires) {
        return !updatedExpires.equals((Object)inputExpires$2);
    }

    @Inject
    public PushSubscriptionUpdatePerformer(PushSubscriptionRepository pushSubscriptionRepository, TypeStateFactory typeStateFactory) {
        this.pushSubscriptionRepository = pushSubscriptionRepository;
        this.typeStateFactory = typeStateFactory;
    }
}

