/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableMap;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.IsSubscribedUpdate;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxPatchObject;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.MailboxSetResponse$;
import org.apache.james.jmap.mail.MailboxUpdateResponse;
import org.apache.james.jmap.mail.NameUpdate;
import org.apache.james.jmap.mail.ParentIdUpdate;
import org.apache.james.jmap.mail.ServerSetPropertyException;
import org.apache.james.jmap.mail.SharedWithPartialUpdate;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.mail.UnsupportedPropertyUpdatedException;
import org.apache.james.jmap.mail.ValidatedMailboxPatchObject;
import org.apache.james.jmap.method.LoopInMailboxGraphException;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$MailboxUpdateResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011er!B1c\u0011\u0003ig!B8c\u0011\u0003\u0001\b\"B<\u0002\t\u0003A\bbB=\u0002\u0005\u0004%IA\u001f\u0005\b\u0003\u0007\t\u0001\u0015!\u0003|\r%\t)!\u0001I\u0001$C\t9A\u0002\u0004\u0003\u0016\u0005\u0001%q\u0003\u0005\u000b\u0003c1!Q3A\u0005\u0002\te\u0001BCA!\r\tE\t\u0015!\u0003\u0003\u001c!1qO\u0002C\u0001\u0005WA\u0011\"a#\u0007\u0003\u0003%\tA!\r\t\u0013\u0005Ue!%A\u0005\u0002\tU\u0002\"CA]\r\u0005\u0005I\u0011IA^\u0011%\tiMBA\u0001\n\u0003\ty\rC\u0005\u0002X\u001a\t\t\u0011\"\u0001\u0003:!I\u0011Q\u001d\u0004\u0002\u0002\u0013\u0005\u0013q\u001d\u0005\n\u0003k4\u0011\u0011!C\u0001\u0005{A\u0011B!\u0001\u0007\u0003\u0003%\tE!\u0011\t\u0013\t\u001da!!A\u0005B\t%\u0001\"\u0003B\u0006\r\u0005\u0005I\u0011\tB\u0007\u0011%\u0011yABA\u0001\n\u0003\u0012)eB\u0005\u0003J\u0005\t\t\u0011#\u0001\u0003L\u0019I!QC\u0001\u0002\u0002#\u0005!Q\n\u0005\u0007oZ!\tA!\u001a\t\u0013\t-a#!A\u0005F\t5\u0001\"\u0003B4-\u0005\u0005I\u0011\u0011B5\u0011%\u0011iGFA\u0001\n\u0003\u0013y\u0007C\u0005\u0003xY\t\t\u0011\"\u0003\u0003z\u00191\u00111B\u0001A\u0003\u001bA!\"!\r\u001d\u0005+\u0007I\u0011AA\u001a\u0011)\t\t\u0005\bB\tB\u0003%\u0011Q\u0007\u0005\u000b\u0003\u0007b\"Q3A\u0005\u0002\u0005\u0015\u0003BCA'9\tE\t\u0015!\u0003\u0002H!Q\u0011q\n\u000f\u0003\u0016\u0004%\t!!\u0015\t\u0015\u0005}CD!E!\u0002\u0013\t\u0019\u0006\u0003\u0004x9\u0011\u0005\u0011\u0011\r\u0005\b\u0003WbB\u0011AA7\u0011\u001d\t\t\t\bC\u0001\u0003\u0007C\u0011\"a#\u001d\u0003\u0003%\t!!$\t\u0013\u0005UE$%A\u0005\u0002\u0005]\u0005\"CAW9E\u0005I\u0011AAX\u0011%\t\u0019\fHI\u0001\n\u0003\t)\fC\u0005\u0002:r\t\t\u0011\"\u0011\u0002<\"I\u0011Q\u001a\u000f\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003/d\u0012\u0011!C\u0001\u00033D\u0011\"!:\u001d\u0003\u0003%\t%a:\t\u0013\u0005UH$!A\u0005\u0002\u0005]\b\"\u0003B\u00019\u0005\u0005I\u0011\tB\u0002\u0011%\u00119\u0001HA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\fq\t\t\u0011\"\u0011\u0003\u000e!I!q\u0002\u000f\u0002\u0002\u0013\u0005#\u0011C\u0004\n\u0005\u0003\u000b\u0011\u0011!E\u0001\u0005\u00073\u0011\"a\u0003\u0002\u0003\u0003E\tA!\"\t\r]$D\u0011\u0001BG\u0011%\u0011Y\u0001NA\u0001\n\u000b\u0012i\u0001C\u0005\u0003hQ\n\t\u0011\"!\u0003\u0010\"I!Q\u000e\u001b\u0002\u0002\u0013\u0005%q\u0013\u0005\n\u0005o\"\u0014\u0011!C\u0005\u0005s2aAa)\u0002\u0001\n\u0015\u0006B\u0003BTu\tU\r\u0011\"\u0001\u0003*\"Q!\u0011\u0017\u001e\u0003\u0012\u0003\u0006IAa+\t\r]TD\u0011\u0001BZ\u0011\u001d\u0011IL\u000fC\u0001\u0005wCqAa5;\t\u0003\u0011)\u000eC\u0005\u0002\fj\n\t\u0011\"\u0001\u0003Z\"I\u0011Q\u0013\u001e\u0012\u0002\u0013\u0005!Q\u001c\u0005\n\u0003sS\u0014\u0011!C!\u0003wC\u0011\"!4;\u0003\u0003%\t!a4\t\u0013\u0005]'(!A\u0005\u0002\t\u0005\b\"CAsu\u0005\u0005I\u0011IAt\u0011%\t)POA\u0001\n\u0003\u0011)\u000fC\u0005\u0003\u0002i\n\t\u0011\"\u0011\u0003j\"I!q\u0001\u001e\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005\u0017Q\u0014\u0011!C!\u0005\u001bA\u0011Ba\u0004;\u0003\u0003%\tE!<\b\u0013\tE\u0018!!A\t\u0002\tMh!\u0003BR\u0003\u0005\u0005\t\u0012\u0001B{\u0011\u00199H\n\"\u0001\u0003z\"I!1\u0002'\u0002\u0002\u0013\u0015#Q\u0002\u0005\n\u0005Ob\u0015\u0011!CA\u0005wD\u0011B!\u001cM\u0003\u0003%\tIa@\t\u0013\t]D*!A\u0005\n\ted!B8c\u0001\r\u0015\u0001BCB\u0004%\n\u0005\t\u0015!\u0003\u0004\n!Q1Q\u0003*\u0003\u0002\u0003\u0006Iaa\u0006\t\u0015\r}!K!A!\u0002\u0013\u0019\t\u0003\u0003\u0006\u0004(I\u0013\t\u0011)A\u0005\u0007SAaa\u001e*\u0005\u0002\r]\u0002bBB+%\u0012\u00051q\u000b\u0005\b\u0007k\u0013F\u0011BB\\\u0011\u001d\u0019yM\u0015C\u0005\u0007#Dqaa7S\t\u0013\u0019i\u000eC\u0004\u0004hJ#Ia!;\t\u000f\u0011\u001d!\u000b\"\u0003\u0005\n!91q\u001d*\u0005\n\u0011e\u0001b\u0002C\u0012%\u0012%AQ\u0005\u0005\b\t[\u0011F\u0011\u0002C\u0018\u0003ei\u0015-\u001b7c_b\u001cV\r^+qI\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005\r$\u0017AB7fi\"|GM\u0003\u0002fM\u0006!!.\\1q\u0015\t9\u0007.A\u0003kC6,7O\u0003\u0002jU\u00061\u0011\r]1dQ\u0016T\u0011a[\u0001\u0004_J<7\u0001\u0001\t\u0003]\u0006i\u0011A\u0019\u0002\u001a\u001b\u0006LGNY8y'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'o\u0005\u0002\u0002cB\u0011!/^\u0007\u0002g*\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wg\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A7\u0002\r1{uiR#S+\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@k\u0003\u0015\u0019HN\u001a\u001bk\u0013\r\t\t! \u0002\u0007\u0019><w-\u001a:\u0002\u000f1{uiR#SA\t\u0019R*Y5mE>DX\u000b\u001d3bi\u0016\u0014Vm];miN\u0011Q!]\u0015\u0004\u000bq1!\u0001F'bS2\u0014w\u000e_+qI\u0006$XMR1jYV\u0014Xm\u0005\u0005\u001dc\u0006=\u00111CA\r!\r\t\t\"B\u0007\u0002\u0003A\u0019!/!\u0006\n\u0007\u0005]1OA\u0004Qe>$Wo\u0019;\u0011\t\u0005m\u00111\u0006\b\u0005\u0003;\t9C\u0004\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019\u0003\\\u0001\u0007yI|w\u000e\u001e \n\u0003QL1!!\u000bt\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\f\u00020\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011\u0011F:\u0002\u00135\f\u0017\u000e\u001c2pq&#WCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001eI\u0006!Q.Y5m\u0013\u0011\ty$!\u000f\u0003#Us\u0007/\u0019:tK\u0012l\u0015-\u001b7c_bLE-\u0001\u0006nC&d'm\u001c=JI\u0002\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0003\u0003BA\u000e\u0003\u0013JA!a\u0013\u00020\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u000bKb\u001cW\r\u001d;j_:\u0004\u0013!\u00029bi\u000eDWCAA*!\u0015\u0011\u0018QKA-\u0013\r\t9f\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005]\u00121L\u0005\u0005\u0003;\nIDA\u000eWC2LG-\u0019;fI6\u000b\u0017\u000e\u001c2pqB\u000bGo\u00195PE*,7\r^\u0001\u0007a\u0006$8\r\u001b\u0011\u0015\u0011\u0005\r\u0014QMA4\u0003S\u00022!!\u0005\u001d\u0011\u001d\t\td\ta\u0001\u0003kAq!a\u0011$\u0001\u0004\t9\u0005C\u0004\u0002P\r\u0002\r!a\u0015\u0002\r\u0019LG\u000e^3s)\u0011\ty'! \u0011\u000bI\f)&!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001ee\u0003\u0011\u0019wN]3\n\t\u0005m\u0014Q\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA@I\u0001\u0007\u0011\u0011O\u0001\u0015C\u000e\u001cW\r\u001d;bE2,\u0007K]8qKJ$\u0018.Z:\u0002#\u0005\u001cX*Y5mE>D8+\u001a;FeJ|'/\u0006\u0002\u0002\u0006B!\u00111OAD\u0013\u0011\tI)!\u001e\u0003\u0011M+G/\u0012:s_J\fAaY8qsRA\u00111MAH\u0003#\u000b\u0019\nC\u0005\u00022\u0019\u0002\n\u00111\u0001\u00026!I\u00111\t\u0014\u0011\u0002\u0003\u0007\u0011q\t\u0005\n\u0003\u001f2\u0003\u0013!a\u0001\u0003'\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a*\"\u0011QGANW\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013Ut7\r[3dW\u0016$'bAATg\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0016\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003cSC!a\u0012\u0002\u001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\\U\u0011\t\u0019&a'\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\f\u0005\u0003\u0002@\u0006%WBAAa\u0015\u0011\t\u0019-!2\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\fAA[1wC&!\u00111ZAa\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u001b\t\u0004e\u0006M\u0017bAAkg\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\\Aq!\r\u0011\u0018Q\\\u0005\u0004\u0003?\u001c(aA!os\"I\u00111\u001d\u0017\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\bCBAv\u0003c\fY.\u0004\u0002\u0002n*\u0019\u0011q^:\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002t\u00065(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!?\u0002\u0000B\u0019!/a?\n\u0007\u0005u8OA\u0004C_>dW-\u00198\t\u0013\u0005\rh&!AA\u0002\u0005m\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!0\u0003\u0006!I\u00111]\u0018\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011[\u0001\ti>\u001cFO]5oOR\u0011\u0011QX\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e(1\u0003\u0005\n\u0003G\u0014\u0014\u0011!a\u0001\u00037\u0014A#T1jY\n|\u00070\u00169eCR,7+^2dKN\u001c8\u0003\u0003\u0004r\u0003\u001f\t\u0019\"!\u0007\u0016\u0005\tm\u0001\u0003\u0002B\u000f\u0005Oi!Aa\b\u000b\t\t\u0005\"1E\u0001\u0006[>$W\r\u001c\u0006\u0004\u0005K1\u0017aB7bS2\u0014w\u000e_\u0005\u0005\u0005S\u0011yBA\u0005NC&d'm\u001c=JIR!!Q\u0006B\u0018!\r\t\tB\u0002\u0005\b\u0003cI\u0001\u0019\u0001B\u000e)\u0011\u0011iCa\r\t\u0013\u0005E\"\u0002%AA\u0002\tmQC\u0001B\u001cU\u0011\u0011Y\"a'\u0015\t\u0005m'1\b\u0005\n\u0003Gt\u0011\u0011!a\u0001\u0003#$B!!?\u0003@!I\u00111\u001d\t\u0002\u0002\u0003\u0007\u00111\u001c\u000b\u0005\u0003{\u0013\u0019\u0005C\u0005\u0002dF\t\t\u00111\u0001\u0002RR!\u0011\u0011 B$\u0011%\t\u0019\u000fFA\u0001\u0002\u0004\tY.\u0001\u000bNC&d'm\u001c=Va\u0012\fG/Z*vG\u000e,7o\u001d\t\u0004\u0003#12#\u0002\f\u0003P\tm\u0003\u0003\u0003B)\u0005/\u0012YB!\f\u000e\u0005\tM#b\u0001B+g\u00069!/\u001e8uS6,\u0017\u0002\u0002B-\u0005'\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\u0011iFa\u0019\u000e\u0005\t}#\u0002\u0002B1\u0003\u000b\f!![8\n\t\u00055\"q\f\u000b\u0003\u0005\u0017\nQ!\u00199qYf$BA!\f\u0003l!9\u0011\u0011G\rA\u0002\tm\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005c\u0012\u0019\bE\u0003s\u0003+\u0012Y\u0002C\u0005\u0003vi\t\t\u00111\u0001\u0003.\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tm\u0004\u0003BA`\u0005{JAAa \u0002B\n1qJ\u00196fGR\fA#T1jY\n|\u00070\u00169eCR,g)Y5mkJ,\u0007cAA\tiM)AGa\"\u0003\\Aa!\u0011\u000bBE\u0003k\t9%a\u0015\u0002d%!!1\u0012B*\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005\u0007#\u0002\"a\u0019\u0003\u0012\nM%Q\u0013\u0005\b\u0003c9\u0004\u0019AA\u001b\u0011\u001d\t\u0019e\u000ea\u0001\u0003\u000fBq!a\u00148\u0001\u0004\t\u0019\u0006\u0006\u0003\u0003\u001a\n\u0005\u0006#\u0002:\u0002V\tm\u0005#\u0003:\u0003\u001e\u0006U\u0012qIA*\u0013\r\u0011yj\u001d\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tU\u0004(!AA\u0002\u0005\r$\u0001F'bS2\u0014w\u000e_+qI\u0006$XMU3tk2$8o\u0005\u0004;c\u0006M\u0011\u0011D\u0001\be\u0016\u001cX\u000f\u001c;t+\t\u0011Y\u000b\u0005\u0004\u0002\u001c\t5\u0016qB\u0005\u0005\u0005_\u000byCA\u0002TKF\f\u0001B]3tk2$8\u000f\t\u000b\u0005\u0005k\u00139\fE\u0002\u0002\u0012iBqAa*>\u0001\u0004\u0011Y+A\u0004va\u0012\fG/\u001a3\u0016\u0005\tu\u0006\u0003\u0003B`\u0005\u000f\u0014YB!4\u000f\t\t\u0005'1\u0019\t\u0004\u0003?\u0019\u0018b\u0001Bcg\u00061\u0001K]3eK\u001aLAA!3\u0003L\n\u0019Q*\u00199\u000b\u0007\t\u00157\u000f\u0005\u0003\u00028\t=\u0017\u0002\u0002Bi\u0003s\u0011Q#T1jY\n|\u00070\u00169eCR,'+Z:q_:\u001cX-\u0001\u0006o_R,\u0006\u000fZ1uK\u0012,\"Aa6\u0011\u0011\t}&qYA\u001b\u0003\u000b#BA!.\u0003\\\"I!q\u0015!\u0011\u0002\u0003\u0007!1V\u000b\u0003\u0005?TCAa+\u0002\u001cR!\u00111\u001cBr\u0011%\t\u0019\u000fRA\u0001\u0002\u0004\t\t\u000e\u0006\u0003\u0002z\n\u001d\b\"CAr\r\u0006\u0005\t\u0019AAn)\u0011\tiLa;\t\u0013\u0005\rx)!AA\u0002\u0005EG\u0003BA}\u0005_D\u0011\"a9K\u0003\u0003\u0005\r!a7\u0002)5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;t!\r\t\t\u0002T\n\u0006\u0019\n](1\f\t\t\u0005#\u00129Fa+\u00036R\u0011!1\u001f\u000b\u0005\u0005k\u0013i\u0010C\u0004\u0003(>\u0003\rAa+\u0015\t\r\u000511\u0001\t\u0006e\u0006U#1\u0016\u0005\n\u0005k\u0002\u0016\u0011!a\u0001\u0005k\u001b\"AU9\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003\u0004\f\rEQBAB\u0007\u0015\r\u0019y\u0001Z\u0001\u0005UN|g.\u0003\u0003\u0004\u0014\r5!!E'bS2\u0014w\u000e_*fe&\fG.\u001b>fe\u0006qQ.Y5mE>DX*\u00198bO\u0016\u0014\b\u0003BB\r\u00077i!Aa\t\n\t\ru!1\u0005\u0002\u000f\u001b\u0006LGNY8y\u001b\u0006t\u0017mZ3s\u0003M\u0019XOY:de&\u0004H/[8o\u001b\u0006t\u0017mZ3s!\u0011\u0019Iba\t\n\t\r\u0015\"1\u0005\u0002\u0014'V\u00147o\u0019:jaRLwN\\'b]\u0006<WM]\u0001\u0011[\u0006LGNY8y\u0013\u00124\u0015m\u0019;pef\u0004Baa\u000b\u000429!!QDB\u0017\u0013\u0011\u0019yCa\b\u0002\u00135\u000b\u0017\u000e\u001c2pq&#\u0017\u0002BB\u001a\u0007k\u0011qAR1di>\u0014\u0018P\u0003\u0003\u00040\t}ACCB\u001d\u0007w\u0019ida\u0010\u0004BA\u0011aN\u0015\u0005\b\u0007\u000f9\u0006\u0019AB\u0005\u0011\u001d\u0019)b\u0016a\u0001\u0007/Aqaa\bX\u0001\u0004\u0019\t\u0003C\u0004\u0004(]\u0003\ra!\u000b)\u0007]\u001b)\u0005\u0005\u0003\u0004H\rESBAB%\u0015\u0011\u0019Ye!\u0014\u0002\r%t'.Z2u\u0015\t\u0019y%A\u0004kC.\f'\u000f^1\n\t\rM3\u0011\n\u0002\u0007\u0013:TWm\u0019;\u0002\u001fU\u0004H-\u0019;f\u001b\u0006LGNY8yKN$\u0002b!\u0017\u0004\u0006\u000e=5\u0011\u0014\t\u0007\u00077\u001aIg!\u001c\u000e\u0005\ru#\u0002BB0\u0007C\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007Q\u001c\u0019G\u0003\u0003\u0002x\r\u0015$BAB4\u0003\u001d\u0011X-Y2u_JLAaa\u001b\u0004^\t)1+T8o_B\u00191q\u000e\u001e\u000f\u0007\rE\u0004A\u0004\u0003\u0004t\r\re\u0002BB;\u0007\u0003sAaa\u001e\u0004\u00009!1\u0011PB?\u001d\u0011\tyba\u001f\n\u0003-L!!\u001b6\n\u0005\u001dD\u0017BA3g\u0013\t\u0019G\rC\u0004\u0004\bb\u0003\ra!#\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!1\u0011DBF\u0013\u0011\u0019iIa\t\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"91\u0011\u0013-A\u0002\rM\u0015!E7bS2\u0014w\u000e_*fiJ+\u0017/^3tiB!\u0011qGBK\u0013\u0011\u00199*!\u000f\u0003#5\u000b\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000fC\u0004\u0004\u001cb\u0003\ra!(\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\u0011\r\t}6qTBR\u0013\u0011\u0019\tKa3\u0003\u0007M+G\u000f\u0005\u0003\u0004&\u000e=f\u0002BBT\u0007WsAaa\u001d\u0004*&\u0019\u0011q\u000f3\n\t\r5\u0016QO\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\rE61\u0017\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\t\r5\u0016QO\u0001\u000ekB$\u0017\r^3NC&d'm\u001c=\u0015\u0019\re6QXB`\u0007\u0003\u001c)m!4\u0011\r\rm3\u0011NB^!\r\u0019y'\u0002\u0005\b\u0007\u000fK\u0006\u0019ABE\u0011\u001d\t\t$\u0017a\u0001\u00057Aqaa1Z\u0001\u0004\t)$A\tv]B\f'o]3e\u001b\u0006LGNY8y\u0013\u0012Dq!a\u0014Z\u0001\u0004\u00199\r\u0005\u0003\u00028\r%\u0017\u0002BBf\u0003s\u0011!#T1jY\n|\u0007\u0010U1uG\"|%M[3di\"911T-A\u0002\ru\u0015AE;qI\u0006$XmU;cg\u000e\u0014\u0018\u000e\u001d;j_:$\u0002b!/\u0004T\u000eU7\u0011\u001c\u0005\b\u0003cQ\u0006\u0019\u0001B\u000e\u0011\u001d\u00199N\u0017a\u0001\u00033\naB^1mS\u0012\fG/\u001a3QCR\u001c\u0007\u000eC\u0004\u0004\bj\u0003\ra!#\u0002#U\u0004H-\u0019;f\u001b\u0006LGNY8y!\u0006$\b\u000e\u0006\u0006\u0004:\u000e}7\u0011]Br\u0007KDq!!\r\\\u0001\u0004\u0011Y\u0002C\u0004\u0004Dn\u0003\r!!\u000e\t\u000f\r]7\f1\u0001\u0002Z!91qQ.A\u0002\r%\u0015aE1qa2L\b+\u0019:f]RLE-\u00169eCR,G\u0003CBv\u0007o\u001cI\u0010\"\u0002\u0011\u000fI\u001cio!=\u0004r&\u00191q^:\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B\u000f\u0007gLAa!>\u0003 \tYQ*Y5mE>D\b+\u0019;i\u0011\u001d\t\t\u0004\u0018a\u0001\u00057Aqaa?]\u0001\u0004\u0019i0A\nnCf\u0014W\rU1sK:$\u0018\nZ+qI\u0006$X\rE\u0003s\u0003+\u001ay\u0010\u0005\u0003\u00028\u0011\u0005\u0011\u0002\u0002C\u0002\u0003s\u0011a\u0002U1sK:$\u0018\nZ+qI\u0006$X\rC\u0004\u0004\br\u0003\ra!#\u0002\u001f\u0005\u0004\b\u000f\\=OC6,W\u000b\u001d3bi\u0016$baa;\u0005\f\u0011]\u0001b\u0002C\u0007;\u0002\u0007AqB\u0001\u0010[\u0006L(-\u001a(b[\u0016,\u0006\u000fZ1uKB)!/!\u0016\u0005\u0012A!\u0011q\u0007C\n\u0013\u0011!)\"!\u000f\u0003\u00159\u000bW.Z+qI\u0006$X\rC\u0004\u0004\bv\u0003\ra!#\u0015\u0011\r-H1\u0004C\u000f\tCAq!!\r_\u0001\u0004\u0011Y\u0002C\u0004\u0005 y\u0003\raa@\u0002\u001dA\f'/\u001a8u\u0013\u0012,\u0006\u000fZ1uK\"91q\u00110A\u0002\r%\u0015aE;qI\u0006$X-T1jY\n|\u0007PU5hQR\u001cH\u0003CB]\tO!I\u0003b\u000b\t\u000f\u0005Er\f1\u0001\u0003\u001c!91q[0A\u0002\u0005e\u0003bBBD?\u0002\u00071\u0011R\u0001\u0011SN\f5+_:uK6l\u0015-\u001b7c_b$B!!?\u00052!9!Q\u00051A\u0002\u0011M\u0002\u0003BB\r\tkIA\u0001b\u000e\u0003$\tqQ*Z:tC\u001e,W*\u00198bO\u0016\u0014\b")
public class MailboxSetUpdatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxUpdateResults> updateMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, Set<Refined<String, string.Uri>> capabilities) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.update().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMailboxId unparsedMailboxId = (UnparsedMailboxId)tuple2._1();
                MailboxPatchObject patch = (MailboxPatchObject)tuple2._2();
                if (unparsedMailboxId != null) {
                    UnparsedMailboxId unparsedMailboxId2 = unparsedMailboxId;
                    if (patch != null) {
                        MailboxPatchObject mailboxPatchObject = patch;
                        return ((SMono)MailboxGet$.MODULE$.parse($this.mailboxIdFactory, unparsedMailboxId2).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)), (Function1 & Serializable)mailboxId -> this.updateMailbox(mailboxSession, (MailboxId)mailboxId, unparsedMailboxId2, mailboxPatchObject, capabilities))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetUpdatePerformer$MailboxUpdateResults$.MODULE$);
    }

    private SMono<MailboxUpdateResult> updateMailbox(MailboxSession mailboxSession, MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, MailboxPatchObject patch, Set<Refined<String, string.Uri>> capabilities) {
        return (SMono)patch.validate(this.mailboxIdFactory, this.serializer, capabilities, mailboxSession).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)validatedPatch -> this.updateMailboxRights(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession).then(this.updateSubscription(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)).then(this.updateMailboxPath(mailboxId, unparsedMailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)));
    }

    private SMono<MailboxUpdateResult> updateSubscription(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        return (SMono)validatedPatch.isSubscribedUpdate().map((Function1 & Serializable)isSubscribedUpdate -> SMono$.MODULE$.fromCallable(() -> {
            MailboxSetUpdatePerformer.$anonfun$updateSubscription$2(this, mailboxId, mailboxSession, isSubscribedUpdate);
            return BoxedUnit.UNIT;
        }).then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId)));
    }

    private SMono<MailboxUpdateResult> updateMailboxPath(MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        if (validatedPatch.shouldUpdateMailboxPath()) {
            return SMono$.MODULE$.fromCallable(() -> {
                Product product;
                try {
                    MailboxPath newPath;
                    MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId, mailboxSession);
                    if (this.isASystemMailbox(mailbox)) {
                        throw new SystemMailboxChangeException(mailboxId);
                    }
                    if (validatedPatch.parentIdUpdate().flatMap((Function1 & Serializable)x$3 -> x$3.newId()).contains((Object)mailboxId)) {
                        throw new LoopInMailboxGraphException(mailboxId);
                    }
                    MailboxPath oldPath = mailbox.getMailboxPath();
                    Object object = !oldPath.equals((Object)(newPath = (MailboxPath)this.applyParentIdUpdate(mailboxId, validatedPatch.parentIdUpdate(), mailboxSession).andThen(this.applyNameUpdate(validatedPatch.nameUpdate(), mailboxSession)).apply((Object)oldPath))) ? $this.mailboxManager.renameMailbox(mailboxId, newPath, MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS, mailboxSession) : BoxedUnit.UNIT;
                    product = new MailboxUpdateSuccess(mailboxId);
                }
                catch (Exception e) {
                    product = new MailboxUpdateFailure(unparsedMailboxId, e, (Option<ValidatedMailboxPatchObject>)new Some((Object)validatedPatch));
                }
                return product;
            }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
        }
        return SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId));
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, Option<ParentIdUpdate> maybeParentIdUpdate, MailboxSession mailboxSession) {
        return (Function1)maybeParentIdUpdate.map((Function1 & Serializable)parentIdUpdate -> this.applyParentIdUpdate(mailboxId, (ParentIdUpdate)parentIdUpdate, mailboxSession)).getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)x -> x);
    }

    private Function1<MailboxPath, MailboxPath> applyNameUpdate(Option<NameUpdate> maybeNameUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> (MailboxPath)maybeNameUpdate.map((Function1 & Serializable)nameUpdate -> {
            Option originalParentPath = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
            return (MailboxPath)originalParentPath.map((Function1 & Serializable)x$4 -> x$4.child(nameUpdate.newName(), mailboxSession.getPathDelimiter())).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)mailboxSession.getUser(), (String)nameUpdate.newName()));
        }).getOrElse((Function0 & Serializable)() -> originalPath);
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, ParentIdUpdate parentIdUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> {
            String currentName = originalPath.getName(mailboxSession.getPathDelimiter());
            return (MailboxPath)parentIdUpdate.newId().map((Function1 & Serializable)id -> {
                Duration x$1;
                SMono qual$1 = SFlux$.MODULE$.fromPublisher((Publisher)$this.mailboxManager.search(MailboxQuery.builder().userAndNamespaceFrom(originalPath).expression((MailboxNameExpression)new PrefixedWildcard(originalPath.getName() + mailboxSession.getPathDelimiter())).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession)).filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)MailboxSetUpdatePerformer.$anonfun$applyParentIdUpdate$6(id, child))).hasElements();
                boolean createsALoop = BoxesRunTime.unboxToBoolean((Object)qual$1.block(x$1 = qual$1.block$default$1()));
                if (createsALoop) {
                    throw new LoopInMailboxGraphException(mailboxId);
                }
                MailboxPath parentPath = $this.mailboxManager.getMailbox(id, mailboxSession).getMailboxPath();
                return parentPath.child(currentName, mailboxSession.getPathDelimiter());
            }).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)originalPath.getUser(), (String)currentName));
        };
    }

    private SMono<MailboxUpdateResult> updateMailboxRights(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        SMono resetOperation = (SMono)validatedPatch.rightsReset().map((Function1 & Serializable)sharedWithResetUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.setRights(mailboxId, sharedWithResetUpdate.rights().toMailboxAcl().asJava(), mailboxSession);
            return BoxedUnit.UNIT;
        }).then()).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validatedPatch.rightsPartialUpdates());
        Function1 & Serializable x$1 = (Function1 & Serializable)partialUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.applyRightsCommand(mailboxId, partialUpdate.asACLCommand(), mailboxSession);
            return BoxedUnit.UNIT;
        }).doOnSuccess((Function1 & Serializable)x$5 -> {
            MailboxSetUpdatePerformer.$anonfun$updateMailboxRights$6(mailboxSession, partialUpdate, mailboxId, x$5);
            return BoxedUnit.UNIT;
        });
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SMono partialUpdatesOperation = qual$1.flatMap((Function1)x$1, 5, x$3, x$4).then();
        return SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)resetOperation, (List)new .colon.colon((Object)partialUpdatesOperation, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).then().then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ void $anonfun$updateSubscription$2(MailboxSetUpdatePerformer $this, MailboxId mailboxId$2, MailboxSession mailboxSession$3, IsSubscribedUpdate isSubscribedUpdate$1) {
        MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId$2, mailboxSession$3);
        boolean isOwner = mailbox.getMailboxPath().belongsTo(mailboxSession$3);
        boolean shouldSubscribe = BoxesRunTime.unboxToBoolean((Object)isSubscribedUpdate$1.isSubscribed().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)((IsSubscribed)x$2).value())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> isOwner));
        if (shouldSubscribe) {
            $this.subscriptionManager.subscribe(mailboxSession$3, mailbox.getMailboxPath());
            return;
        }
        $this.subscriptionManager.unsubscribe(mailboxSession$3, mailbox.getMailboxPath());
    }

    public static final /* synthetic */ boolean $anonfun$applyParentIdUpdate$6(MailboxId id$1, MailboxMetaData child) {
        return child.getId().equals(id$1);
    }

    public static final /* synthetic */ void $anonfun$updateMailboxRights$6(MailboxSession mailboxSession$8, SharedWithPartialUpdate partialUpdate$1, MailboxId mailboxId$6, BoxedUnit x$5) {
        AuditTrail.entry().username(() -> mailboxSession$8.getUser().asString()).protocol("JMAP").action("Mailbox/set update").parameters(() -> ImmutableMap.of((Object)"loggedInUser", (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession$8.getLoggedInUser())).map((Function1 & Serializable)x$6 -> x$6.asString()).getOrElse((Function0 & Serializable)() -> ""), (Object)"delegator", (Object)mailboxSession$8.getUser().asString(), (Object)"delegatee", (Object)partialUpdate$1.username().asString(), (Object)"mailboxId", (Object)mailboxId$6.serialize(), (Object)"rights", (Object)partialUpdate$1.rights().asJava().serialize())).log("JMAP mailbox shared.");
    }

    @Inject
    public MailboxSetUpdatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxUpdateFailure
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;
        private final Option<ValidatedMailboxPatchObject> patch;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public Option<ValidatedMailboxPatchObject> patch() {
            return this.patch;
        }

        public Option<Properties> filter(Properties acceptableProperties) {
            return new Some(this.patch().map((Function1 & Serializable)x$1 -> x$1.updatedProperties().intersect(acceptableProperties)).getOrElse((Function0 & Serializable)() -> acceptableProperties));
        }

        public SetError asMailboxSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Can't update mailbox: Mailbox not found: {}", (Object)mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid mailbox name: {}", (Object)mailboxNameException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Mailbox already exists: {}", (Object)mailboxExistsException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof UnsupportedPropertyUpdatedException) {
                UnsupportedPropertyUpdatedException unsupportedPropertyUpdatedException = (UnsupportedPropertyUpdatedException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Unsupported properties in Mailbox/set update: {}", (Object)unsupportedPropertyUpdatedException.getMessage());
                return SetError$.MODULE$.invalidArguments(new Refined((Object)unsupportedPropertyUpdatedException.property()) + " property do not exist thus cannot be updated", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)unsupportedPropertyUpdatedException.property())}))));
            }
            if (throwable instanceof InvalidUpdateException) {
                InvalidUpdateException invalidUpdateException = (InvalidUpdateException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid update in Mailbox/set update: {}", (Object)invalidUpdateException.getMessage());
                return SetError$.MODULE$.invalidArguments(String.valueOf(invalidUpdateException.cause()), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)invalidUpdateException.property())}))));
            }
            if (throwable instanceof ServerSetPropertyException) {
                ServerSetPropertyException serverSetPropertyException = (ServerSetPropertyException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Unsupported server-set properties in Mailbox/set update: {}", (Object)serverSetPropertyException.getMessage());
                return SetError$.MODULE$.invalidArguments("Can not modify server-set properties", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)serverSetPropertyException.property())}))));
            }
            if (throwable instanceof InvalidPropertyException) {
                InvalidPropertyException invalidPropertyException = (InvalidPropertyException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Invalid properties in Mailbox/set update: {}", (Object)invalidPropertyException.getMessage());
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPropertyException.cause()));
            }
            if (throwable instanceof InvalidPatchException) {
                InvalidPatchException invalidPatchException = (InvalidPatchException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Unsupported patch in Mailbox/set update: {}", (Object)invalidPatchException.getMessage());
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPatchException.cause()));
            }
            if (throwable instanceof SystemMailboxChangeException) {
                SystemMailboxChangeException systemMailboxChangeException = (SystemMailboxChangeException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Attempt to update a system mailbox was rejected: {}", (Object)systemMailboxChangeException.getMessage());
                return SetError$.MODULE$.invalidArguments("Invalid change to a system mailbox", this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof LoopInMailboxGraphException) {
                LoopInMailboxGraphException loopInMailboxGraphException = (LoopInMailboxGraphException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Attempt to create a loop in mailbox graph was rejected: {}", (Object)loopInMailboxGraphException.getMessage());
                return SetError$.MODULE$.invalidArguments("A mailbox parentId property can not be set to itself or one of its child", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof InsufficientRightsException) {
                InsufficientRightsException insufficientRightsException = (InsufficientRightsException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Attempt to create a mailbox while having insufficient rights was rejected: {}", (Object)insufficientRightsException.getMessage());
                return SetError$.MODULE$.invalidArguments("Invalid change to a delegated mailbox", SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().info("Illegal argument in Mailbox/set update", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), (Option<Properties>)None$.MODULE$);
            }
            MailboxSetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetUpdatePerformer$$LOGGER().error("Failed to update mailbox", throwable);
            return SetError$.MODULE$.serverFail(throwable.getMessage());
        }

        public MailboxUpdateFailure copy(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            return new MailboxUpdateFailure(mailboxId, exception, patch);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public Option<ValidatedMailboxPatchObject> copy$default$3() {
            return this.patch();
        }

        public String productPrefix() {
            return "MailboxUpdateFailure";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
                case 1: {
                    return this.exception();
                }
                case 2: {
                    return this.patch();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
                case 1: {
                    return "exception";
                }
                case 2: {
                    return "patch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxUpdateFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxUpdateFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            Option<ValidatedMailboxPatchObject> option = this.patch();
            Option<ValidatedMailboxPatchObject> option2 = mailboxUpdateFailure.patch();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!mailboxUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateFailure(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            this.patch = patch;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxUpdateResult {
    }

    public static class MailboxUpdateResults
    implements Product,
    Serializable {
        private final Seq<MailboxUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxUpdateResult> results() {
            return this.results;
        }

        public Map<MailboxId, MailboxUpdateResponse> updated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateSuccess) {
                    MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateSuccess.mailboxId(), (Object)MailboxSetResponse$.MODULE$.empty()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Map<UnparsedMailboxId, SetError> notUpdated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateFailure) {
                    MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateFailure.mailboxId(), (Object)mailboxUpdateFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxUpdateResults copy(Seq<MailboxUpdateResult> results) {
            return new MailboxUpdateResults(results);
        }

        public Seq<MailboxUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateResults mailboxUpdateResults = (MailboxUpdateResults)x$1;
            Seq<MailboxUpdateResult> seq = this.results();
            Seq<MailboxUpdateResult> seq2 = mailboxUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxUpdateResults.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateResults(Seq<MailboxUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxUpdateSuccess
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxUpdateSuccess copy(MailboxId mailboxId) {
            return new MailboxUpdateSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxUpdateSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

