/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.MailboxCreationId;
import org.apache.james.jmap.mail.MailboxCreationRequest;
import org.apache.james.jmap.mail.MailboxCreationRequest$;
import org.apache.james.jmap.mail.MailboxCreationResponse;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.method.MailboxCreationParseException;
import org.apache.james.jmap.method.MailboxSetCreatePerformer$;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.utils.quotas.QuotaLoaderWithPreloadedDefaultFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011\rt!B3g\u0011\u0003\th!B:g\u0011\u0003!\b\"B>\u0002\t\u0003a\bbB?\u0002\u0005\u0004%IA \u0005\b\u0003\u0017\t\u0001\u0015!\u0003\u0000\r%\ti!\u0001I\u0001$C\ty\u0001C\u0004\u0002\u0012\u00151\t!a\u0005\u0007\r\u0005E\u0018\u0001QAz\u0011)\t\tb\u0002BK\u0002\u0013\u0005\u00111\u0003\u0005\u000b\u0003\u0013:!\u0011#Q\u0001\n\u0005U\u0001BCA{\u000f\tU\r\u0011\"\u0001\u0002x\"Q\u0011q`\u0004\u0003\u0012\u0003\u0006I!!?\t\rm<A\u0011\u0001B\u0001\u0011%\tygBA\u0001\n\u0003\u0011I\u0001C\u0005\u0002x\u001d\t\n\u0011\"\u0001\u0002z!I\u0011qR\u0004\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0003+;\u0011\u0011!C!\u0003/C\u0011\"!+\b\u0003\u0003%\t!a+\t\u0013\u0005Mv!!A\u0005\u0002\tM\u0001\"CAa\u000f\u0005\u0005I\u0011IAb\u0011%\t\tnBA\u0001\n\u0003\u00119\u0002C\u0005\u0002^\u001e\t\t\u0011\"\u0011\u0003\u001c!I\u00111]\u0004\u0002\u0002\u0013\u0005\u0013Q\u001d\u0005\n\u0003O<\u0011\u0011!C!\u0003SD\u0011\"a;\b\u0003\u0003%\tEa\b\b\u0013\t\r\u0012!!A\t\u0002\t\u0015b!CAy\u0003\u0005\u0005\t\u0012\u0001B\u0014\u0011\u0019Y(\u0004\"\u0001\u0003@!I\u0011q\u001d\u000e\u0002\u0002\u0013\u0015\u0013\u0011\u001e\u0005\n\u0005\u0003R\u0012\u0011!CA\u0005\u0007B\u0011B!\u0013\u001b\u0003\u0003%\tIa\u0013\t\u0013\tu#$!A\u0005\n\t}cABA\u0012\u0003\u0001\u000b)\u0003\u0003\u0006\u0002\u0012\u0001\u0012)\u001a!C\u0001\u0003'A!\"!\u0013!\u0005#\u0005\u000b\u0011BA\u000b\u0011)\tY\u0005\tBK\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003+\u0002#\u0011#Q\u0001\n\u0005=\u0003BB>!\t\u0003\t9\u0006C\u0004\u0002`\u0001\"\t!!\u0019\t\u0013\u0005=\u0004%!A\u0005\u0002\u0005E\u0004\"CA<AE\u0005I\u0011AA=\u0011%\ty\tII\u0001\n\u0003\t\t\nC\u0005\u0002\u0016\u0002\n\t\u0011\"\u0011\u0002\u0018\"I\u0011\u0011\u0016\u0011\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003g\u0003\u0013\u0011!C\u0001\u0003kC\u0011\"!1!\u0003\u0003%\t%a1\t\u0013\u0005E\u0007%!A\u0005\u0002\u0005M\u0007\"CAoA\u0005\u0005I\u0011IAp\u0011%\t\u0019\u000fIA\u0001\n\u0003\n)\u000fC\u0005\u0002h\u0002\n\t\u0011\"\u0011\u0002j\"I\u00111\u001e\u0011\u0002\u0002\u0013\u0005\u0013Q^\u0004\n\u0005O\n\u0011\u0011!E\u0001\u0005S2\u0011\"a\t\u0002\u0003\u0003E\tAa\u001b\t\rm$D\u0011\u0001B8\u0011%\t9\u000fNA\u0001\n\u000b\nI\u000fC\u0005\u0003BQ\n\t\u0011\"!\u0003r!I!\u0011\n\u001b\u0002\u0002\u0013\u0005%q\u000f\u0005\n\u0005;\"\u0014\u0011!C\u0005\u0005?2aAa \u0002\u0001\n\u0005\u0005B\u0003BBu\tU\r\u0011\"\u0001\u0003\u0006\"Q!Q\u0012\u001e\u0003\u0012\u0003\u0006IAa\"\t\rmTD\u0011\u0001BH\u0011\u001d\u0011)J\u000fC\u0001\u0005/CqA!+;\t\u0003\u0011Y\u000bC\u0005\u0002pi\n\t\u0011\"\u0001\u00030\"I\u0011q\u000f\u001e\u0012\u0002\u0013\u0005!1\u0017\u0005\n\u0003+S\u0014\u0011!C!\u0003/C\u0011\"!+;\u0003\u0003%\t!a+\t\u0013\u0005M&(!A\u0005\u0002\t]\u0006\"CAau\u0005\u0005I\u0011IAb\u0011%\t\tNOA\u0001\n\u0003\u0011Y\fC\u0005\u0002^j\n\t\u0011\"\u0011\u0003@\"I\u00111\u001d\u001e\u0002\u0002\u0013\u0005\u0013Q\u001d\u0005\n\u0003OT\u0014\u0011!C!\u0003SD\u0011\"a;;\u0003\u0003%\tEa1\b\u0013\t\u001d\u0017!!A\t\u0002\t%g!\u0003B@\u0003\u0005\u0005\t\u0012\u0001Bf\u0011\u0019YH\n\"\u0001\u0003T\"I\u0011q\u001d'\u0002\u0002\u0013\u0015\u0013\u0011\u001e\u0005\n\u0005\u0003b\u0015\u0011!CA\u0005+D\u0011B!\u0013M\u0003\u0003%\tI!7\t\u0013\tuC*!A\u0005\n\t}c!B:g\u0001\t}\u0007B\u0003Bq%\n\u0005\t\u0015!\u0003\u0003d\"Q!q\u001e*\u0003\u0002\u0003\u0006IA!=\t\u0015\tu(K!A!\u0002\u0013\u0011y\u0010\u0003\u0006\u0004\u0006I\u0013\t\u0011)A\u0005\u0007\u000fA!ba\u0007S\u0005\u0003\u0005\u000b\u0011BB\u000f\u0011)\u0019iC\u0015BC\u0002\u0013\u00051q\u0006\u0005\u000b\u0007\u0003\u0012&\u0011!Q\u0001\n\rE\u0002BCB\"%\n\u0015\r\u0011\"\u0001\u0004F!Q11\u000b*\u0003\u0002\u0003\u0006Iaa\u0012\t\rm\u0014F\u0011AB+\u0011\u001d\u0019IH\u0015C\u0001\u0007wBqa!3S\t\u0013\u0019Y\rC\u0004\u0004pJ#Ia!=\t\u000f\u0011\u001d!\u000b\"\u0003\u0005\n!9A\u0011\u0004*\u0005\n\u0011m\u0001b\u0002C\u0015%\u0012%A1\u0006\u0005\b\tw\u0011F\u0011\u0002C\u001f\u0011\u001d\u0019IM\u0015C\u0005\t/\n\u0011$T1jY\n|\u0007pU3u\u0007J,\u0017\r^3QKJ4wN]7fe*\u0011q\r[\u0001\u0007[\u0016$\bn\u001c3\u000b\u0005%T\u0017\u0001\u00026nCBT!a\u001b7\u0002\u000b)\fW.Z:\u000b\u00055t\u0017AB1qC\u000eDWMC\u0001p\u0003\ry'oZ\u0002\u0001!\t\u0011\u0018!D\u0001g\u0005ei\u0015-\u001b7c_b\u001cV\r^\"sK\u0006$X\rU3sM>\u0014X.\u001a:\u0014\u0005\u0005)\bC\u0001<z\u001b\u00059(\"\u0001=\u0002\u000bM\u001c\u0017\r\\1\n\u0005i<(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002c\u00061AjT$H\u000bJ+\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u00018\u0002\u000bMdg\r\u000e6\n\t\u0005%\u00111\u0001\u0002\u0007\u0019><w-\u001a:\u0002\u000f1{uiR#SA\t)R*Y5mE>D8I]3bi&|gNU3tk2$8CA\u0003v\u0003Ei\u0017-\u001b7c_b\u001c%/Z1uS>t\u0017\nZ\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037A\u0017\u0001B7bS2LA!a\b\u0002\u001a\t\tR*Y5mE>D8I]3bi&|g.\u00133*\u0007\u0015\u0001sA\u0001\fNC&d'm\u001c=De\u0016\fG/[8o\r\u0006LG.\u001e:f'!\u0001S/a\n\u0002,\u0005E\u0002cAA\u0015\u000b5\t\u0011\u0001E\u0002w\u0003[I1!a\fx\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\r\u0002D9!\u0011QGA \u001d\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001ea\u00061AH]8pizJ\u0011\u0001_\u0005\u0004\u0003\u0003:\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\n9E\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002B]\f!#\\1jY\n|\u0007p\u0011:fCRLwN\\%eA\u0005IQ\r_2faRLwN\\\u000b\u0003\u0003\u001f\u0002B!a\r\u0002R%!\u00111KA$\u0005%)\u0005pY3qi&|g.\u0001\u0006fq\u000e,\u0007\u000f^5p]\u0002\"b!!\u0017\u0002\\\u0005u\u0003cAA\u0015A!9\u0011\u0011C\u0013A\u0002\u0005U\u0001bBA&K\u0001\u0007\u0011qJ\u0001\u0012CNl\u0015-\u001b7c_b\u001cV\r^#se>\u0014XCAA2!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5Q\u0006!1m\u001c:f\u0013\u0011\ti'a\u001a\u0003\u0011M+G/\u0012:s_J\fAaY8qsR1\u0011\u0011LA:\u0003kB\u0011\"!\u0005(!\u0003\u0005\r!!\u0006\t\u0013\u0005-s\u0005%AA\u0002\u0005=\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003wRC!!\u0006\u0002~-\u0012\u0011q\u0010\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003%)hn\u00195fG.,GMC\u0002\u0002\n^\f!\"\u00198o_R\fG/[8o\u0013\u0011\ti)a!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M%\u0006BA(\u0003{\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAM!\u0011\tY*!*\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bA\u0001\\1oO*\u0011\u00111U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0006u%AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002.B\u0019a/a,\n\u0007\u0005EvOA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00028\u0006u\u0006c\u0001<\u0002:&\u0019\u00111X<\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002@2\n\t\u00111\u0001\u0002.\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!2\u0011\r\u0005\u001d\u0017QZA\\\u001b\t\tIMC\u0002\u0002L^\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty-!3\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\fY\u000eE\u0002w\u0003/L1!!7x\u0005\u001d\u0011un\u001c7fC:D\u0011\"a0/\u0003\u0003\u0005\r!a.\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00033\u000b\t\u000fC\u0005\u0002@>\n\t\u00111\u0001\u0002.\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002.\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001a\u00061Q-];bYN$B!!6\u0002p\"I\u0011q\u0018\u001a\u0002\u0002\u0003\u0007\u0011q\u0017\u0002\u0017\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]N+8mY3tgNAq!^A\u0014\u0003W\t\t$A\fnC&d'm\u001c=De\u0016\fG/[8o%\u0016\u001c\bo\u001c8tKV\u0011\u0011\u0011 \t\u0005\u0003/\tY0\u0003\u0003\u0002~\u0006e!aF'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0003ai\u0017-\u001b7c_b\u001c%/Z1uS>t'+Z:q_:\u001cX\r\t\u000b\u0007\u0005\u0007\u0011)Aa\u0002\u0011\u0007\u0005%r\u0001C\u0004\u0002\u00121\u0001\r!!\u0006\t\u000f\u0005UH\u00021\u0001\u0002zR1!1\u0001B\u0006\u0005\u001bA\u0011\"!\u0005\u000e!\u0003\u0005\r!!\u0006\t\u0013\u0005UX\u0002%AA\u0002\u0005eXC\u0001B\tU\u0011\tI0! \u0015\t\u0005]&Q\u0003\u0005\n\u0003\u007f\u0013\u0012\u0011!a\u0001\u0003[#B!!6\u0003\u001a!I\u0011q\u0018\u000b\u0002\u0002\u0003\u0007\u0011q\u0017\u000b\u0005\u00033\u0013i\u0002C\u0005\u0002@V\t\t\u00111\u0001\u0002.R!\u0011Q\u001bB\u0011\u0011%\ty\fGA\u0001\u0002\u0004\t9,\u0001\fNC&d'm\u001c=De\u0016\fG/[8o'V\u001c7-Z:t!\r\tICG\n\u00065\t%\"Q\u0007\t\u000b\u0005W\u0011\t$!\u0006\u0002z\n\rQB\u0001B\u0017\u0015\r\u0011yc^\u0001\beVtG/[7f\u0013\u0011\u0011\u0019D!\f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\u0011\u0011Y$!)\u0002\u0005%|\u0017\u0002BA#\u0005s!\"A!\n\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t\r!Q\tB$\u0011\u001d\t\t\"\ba\u0001\u0003+Aq!!>\u001e\u0001\u0004\tI0A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5#\u0011\f\t\u0006m\n=#1K\u0005\u0004\u0005#:(AB(qi&|g\u000eE\u0004w\u0005+\n)\"!?\n\u0007\t]sO\u0001\u0004UkBdWM\r\u0005\n\u00057r\u0012\u0011!a\u0001\u0005\u0007\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0007\u0005\u0003\u0002\u001c\n\r\u0014\u0002\u0002B3\u0003;\u0013aa\u00142kK\u000e$\u0018AF'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0011\u0007\u0005%BgE\u00035\u0005[\u0012)\u0004\u0005\u0006\u0003,\tE\u0012QCA(\u00033\"\"A!\u001b\u0015\r\u0005e#1\u000fB;\u0011\u001d\t\tb\u000ea\u0001\u0003+Aq!a\u00138\u0001\u0004\ty\u0005\u0006\u0003\u0003z\tu\u0004#\u0002<\u0003P\tm\u0004c\u0002<\u0003V\u0005U\u0011q\n\u0005\n\u00057B\u0014\u0011!a\u0001\u00033\u0012a#T1jY\n|\u0007p\u0011:fCRLwN\u001c*fgVdGo]\n\u0007uU\fY#!\r\u0002\u000f\r\u0014X-\u0019;fIV\u0011!q\u0011\t\u0007\u0003g\u0011I)a\n\n\t\t-\u0015q\t\u0002\u0004'\u0016\f\u0018\u0001C2sK\u0006$X\r\u001a\u0011\u0015\t\tE%1\u0013\t\u0004\u0003SQ\u0004b\u0002BB{\u0001\u0007!qQ\u0001\u0010e\u0016$(/[3wK\u000e\u0013X-\u0019;fIV\u0011!\u0011\u0014\t\t\u00057\u0013\u0019+!\u0006\u0002z:!!Q\u0014BP!\r\t9d^\u0005\u0004\u0005C;\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0003&\n\u001d&aA'ba*\u0019!\u0011U<\u0002\u001dI,GO]5fm\u0016,%O]8sgV\u0011!Q\u0016\t\t\u00057\u0013\u0019+!\u0006\u0002dQ!!\u0011\u0013BY\u0011%\u0011\u0019\t\u0011I\u0001\u0002\u0004\u00119)\u0006\u0002\u00036*\"!qQA?)\u0011\t9L!/\t\u0013\u0005}F)!AA\u0002\u00055F\u0003BAk\u0005{C\u0011\"a0G\u0003\u0003\u0005\r!a.\u0015\t\u0005e%\u0011\u0019\u0005\n\u0003\u007f;\u0015\u0011!a\u0001\u0003[#B!!6\u0003F\"I\u0011q\u0018&\u0002\u0002\u0003\u0007\u0011qW\u0001\u0017\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]J+7/\u001e7ugB\u0019\u0011\u0011\u0006'\u0014\u000b1\u0013iM!\u000e\u0011\u0011\t-\"q\u001aBD\u0005#KAA!5\u0003.\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\t%G\u0003\u0002BI\u0005/DqAa!P\u0001\u0004\u00119\t\u0006\u0003\u0003\\\nu\u0007#\u0002<\u0003P\t\u001d\u0005\"\u0003B.!\u0006\u0005\t\u0019\u0001BI'\t\u0011V/\u0001\u0006tKJL\u0017\r\\5{KJ\u0004BA!:\u0003l6\u0011!q\u001d\u0006\u0004\u0005SD\u0017\u0001\u00026t_:LAA!<\u0003h\n\tR*Y5mE>D8+\u001a:jC2L'0\u001a:\u0002\u001d5\f\u0017\u000e\u001c2pq6\u000bg.Y4feB!!1\u001fB}\u001b\t\u0011)PC\u0002\u0003x*\fq!\\1jY\n|\u00070\u0003\u0003\u0003|\nU(AD'bS2\u0014w\u000e_'b]\u0006<WM]\u0001\u0014gV\u00147o\u0019:jaRLwN\\'b]\u0006<WM\u001d\t\u0005\u0005g\u001c\t!\u0003\u0003\u0004\u0004\tU(aE*vEN\u001c'/\u001b9uS>tW*\u00198bO\u0016\u0014\u0018\u0001E7bS2\u0014w\u000e_%e\r\u0006\u001cGo\u001c:z!\u0011\u0019Ia!\u0006\u000f\t\r-1\u0011C\u0007\u0003\u0007\u001bQAaa\u0004\u0003v\u0006)Qn\u001c3fY&!11CB\u0007\u0003%i\u0015-\u001b7c_bLE-\u0003\u0003\u0004\u0018\re!a\u0002$bGR|'/\u001f\u0006\u0005\u0007'\u0019i!\u0001\u0007rk>$\u0018MR1di>\u0014\u0018\u0010\u0005\u0003\u0004 \r%RBAB\u0011\u0015\u0011\u0019\u0019c!\n\u0002\rE,x\u000e^1t\u0015\r\u00199\u0003[\u0001\u0006kRLGn]\u0005\u0005\u0007W\u0019\tC\u0001\u0014Rk>$\u0018\rT8bI\u0016\u0014x+\u001b;i!J,Gn\\1eK\u0012$UMZ1vYR4\u0015m\u0019;pef\fQ\"\\3ue&\u001cg)Y2u_JLXCAB\u0019!\u0011\u0019\u0019d!\u0010\u000e\u0005\rU\"\u0002BB\u001c\u0007s\t1!\u00199j\u0015\r\u0019YD[\u0001\b[\u0016$(/[2t\u0013\u0011\u0019yd!\u000e\u0003\u001b5+GO]5d\r\u0006\u001cGo\u001c:z\u00039iW\r\u001e:jG\u001a\u000b7\r^8ss\u0002\nqb]3tg&|gnU;qa2LWM]\u000b\u0003\u0007\u000f\u0002Ba!\u0013\u0004P5\u001111\n\u0006\u0004\u0007\u001bB\u0017A\u0002:pkR,7/\u0003\u0003\u0004R\r-#aD*fgNLwN\\*vaBd\u0017.\u001a:\u0002!M,7o]5p]N+\b\u000f\u001d7jKJ\u0004C\u0003EB,\u00073\u001aYf!\u0018\u0004`\r\u000541MB3!\t\u0011(\u000bC\u0004\u0003br\u0003\rAa9\t\u000f\t=H\f1\u0001\u0003r\"9!Q /A\u0002\t}\bbBB\u00039\u0002\u00071q\u0001\u0005\b\u00077a\u0006\u0019AB\u000f\u0011\u001d\u0019i\u0003\u0018a\u0001\u0007cAqaa\u0011]\u0001\u0004\u00199\u0005K\u0002]\u0007S\u0002Baa\u001b\u0004v5\u00111Q\u000e\u0006\u0005\u0007_\u001a\t(\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0007g\nqA[1lCJ$\u0018-\u0003\u0003\u0004x\r5$AB%oU\u0016\u001cG/A\bde\u0016\fG/Z'bS2\u0014w\u000e_3t)!\u0019ih!-\u0004<\u000e\u0015\u0007CBB@\u0007\u001b\u001b\t*\u0004\u0002\u0004\u0002*!11QBC\u0003%\u0001XO\u00197jg\",'OC\u0002y\u0007\u000fSA!!\u001b\u0004\n*\u001111R\u0001\be\u0016\f7\r^8s\u0013\u0011\u0019yi!!\u0003\u000bMkuN\\8\u0011\u000fY\u0014)fa%\u0004,B\u00191Q\u0013\u001e\u000f\u0007\r]\u0005A\u0004\u0003\u0004\u001a\u000e%f\u0002BBN\u0007OsAa!(\u0004&:!1qTBR\u001d\u0011\t9d!)\n\u0003=L!!\u001c8\n\u0005-d\u0017BA5k\u0013\t9\u0007\u000e\u0005\u0003\u0004J\r5\u0016\u0002BBX\u0007\u0017\u0012\u0011\u0003\u0015:pG\u0016\u001c8/\u001b8h\u0007>tG/\u001a=u\u0011\u001d\u0019\u0019,\u0018a\u0001\u0007k\u000ba\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0003t\u000e]\u0016\u0002BB]\u0005k\u0014a\"T1jY\n|\u0007pU3tg&|g\u000eC\u0004\u0004>v\u0003\raa0\u0002#5\f\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0018\r\u0005\u0017\u0002BBb\u00033\u0011\u0011#T1jY\n|\u0007pU3u%\u0016\fX/Z:u\u0011\u001d\u00199-\u0018a\u0001\u0007W\u000b\u0011\u0003\u001d:pG\u0016\u001c8/\u001b8h\u0007>tG/\u001a=u\u00035\u0019'/Z1uK6\u000b\u0017\u000e\u001c2pqRQ1QZBi\u0007'\u001c)n!<\u0011\u000fY\u0014)fa4\u0004,B\u00191QS\u0003\t\u000f\rMf\f1\u0001\u00046\"9\u0011\u0011\u00030A\u0002\u0005U\u0001bBBl=\u0002\u00071\u0011\\\u0001\tUN|%M[3diB!11\\Bu\u001b\t\u0019iN\u0003\u0003\u0003j\u000e}'\u0002BBq\u0007G\fA\u0001\\5cg*!1qGBs\u0015\t\u00199/\u0001\u0003qY\u0006L\u0018\u0002BBv\u0007;\u0014\u0001BS:PE*,7\r\u001e\u0005\b\u0007\u000ft\u0006\u0019ABV\u0003-\u0001\u0018M]:f\u0007J,\u0017\r^3\u0015\t\rMHQ\u0001\t\t\u0003g\u0019)p!?\u0004\u0000&!1q_A$\u0005\u0019)\u0015\u000e\u001e5feB\u0019!oa?\n\u0007\ruhMA\u000fNC&d'm\u001c=De\u0016\fG/[8o!\u0006\u00148/Z#yG\u0016\u0004H/[8o!\u0011\t9\u0002\"\u0001\n\t\u0011\r\u0011\u0011\u0004\u0002\u0017\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]J+\u0017/^3ti\"91q[0A\u0002\re\u0017a\u0003:fg>dg/\u001a)bi\"$b\u0001b\u0003\u0005\u0014\u0011U\u0001\u0003CA\u001a\u0007k\fy\u0005\"\u0004\u0011\t\r-AqB\u0005\u0005\t#\u0019iAA\u0006NC&d'm\u001c=QCRD\u0007bBBZA\u0002\u00071Q\u0017\u0005\b\t/\u0001\u0007\u0019AB\u0000\u0003Yi\u0017-\u001b7c_b\u001c%/Z1uS>t'+Z9vKN$\u0018\u0001\u0004:fiJLWM^3QCRDGC\u0002C\u0006\t;!9\u0003C\u0004\u0005 \u0005\u0004\r\u0001\"\t\u0002\u00135\f\u0017\u000e\u001c2pq&#\u0007\u0003BB\u0006\tGIA\u0001\"\n\u0004\u000e\tIQ*Y5mE>D\u0018\n\u001a\u0005\b\u0007g\u000b\u0007\u0019AB[\u0003\r\u0012XmY8sI\u000e\u0013X-\u0019;j_:LE-\u00138Qe>\u001cWm]:j]\u001e\u001cuN\u001c;fqR$\u0002\u0002\"\f\u00056\u0011]B\u0011\b\t\t\u0003g\u0019)\u0010b\f\u0004,B!\u00111\u0007C\u0019\u0013\u0011!\u0019$a\u0012\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g\u000eC\u0004\u0002\u0012\t\u0004\r!!\u0006\t\u000f\r\u001d'\r1\u0001\u0004,\"9Aq\u00042A\u0002\u0011\u0005\u0012aD7bS2\u0014w\u000e_*fi\u0016\u0013(o\u001c:\u0015\t\u0005\rDq\b\u0005\b\t\u0003\u001a\u0007\u0019\u0001C\"\u0003\u0019)'O]8sgB1\u0011q\u0019C#\t\u000fJAAa#\u0002JB9aO!\u0016\u0005J\u0011=\u0003\u0003BBn\t\u0017JA\u0001\"\u0014\u0004^\n1!j\u001d)bi\"\u0004b!a2\u0005F\u0011E\u0003\u0003BBn\t'JA\u0001\"\u0016\u0004^\n\u0019\"j]8o-\u0006d\u0017\u000eZ1uS>tWI\u001d:peRAA\u0011\fC.\t;\"\t\u0007\u0005\u0005\u00024\rU\u0018qJA}\u0011\u001d\u0019\u0019\f\u001aa\u0001\u0007kCq\u0001b\u0018e\u0001\u0004!i!\u0001\u0003qCRD\u0007b\u0002C\fI\u0002\u00071q ")
public class MailboxSetCreatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final QuotaLoaderWithPreloadedDefaultFactory quotaFactory;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;

    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public SMono<Tuple2<MailboxCreationResults, ProcessingContext>> createMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, ProcessingContext processingContext) {
        return SFlux$.MODULE$.fromIterable((Iterable)((MapOps)mailboxSetRequest.create().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).view()).fold((Object)new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)Nil$.MODULE$), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MailboxCreationId mailboxCreationId = (MailboxCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mailboxCreationId, (Object)jsObject);
            MailboxCreationId mailboxCreationId2 = (MailboxCreationId)tuple22._1();
            JsObject jsObject2 = (JsObject)tuple22._2();
            Tuple2<MailboxCreationResult, ProcessingContext> tuple23 = this.createMailbox(mailboxSession, mailboxCreationId2, jsObject2, (ProcessingContext)acc._2());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            MailboxCreationResult creationResult = (MailboxCreationResult)tuple23._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            MailboxCreationResult creationResult2 = (MailboxCreationResult)tuple24._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple24._2();
            return new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)((scala.collection.immutable.Seq)((MailboxCreationResults)acc._1()).created().$colon$plus((Object)creationResult2))), (Object)updatedProcessingContext2);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private Tuple2<MailboxCreationResult, ProcessingContext> createMailbox(MailboxSession mailboxSession, MailboxCreationId mailboxCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return (Tuple2)this.parseCreate(jsObject).flatMap((Function1 & Serializable)mailboxCreationRequest -> this.resolvePath(mailboxSession, (MailboxCreationRequest)mailboxCreationRequest).flatMap((Function1 & Serializable)path -> this.createMailbox(mailboxSession, (MailboxPath)path, (MailboxCreationRequest)mailboxCreationRequest))).flatMap((Function1 & Serializable)creationResponse -> this.recordCreationIdInProcessingContext(mailboxCreationId, processingContext, creationResponse.id()).map((Function1 & Serializable)context -> new Tuple2(creationResponse, context))).fold((Function1 & Serializable)e -> new Tuple2((Object)new MailboxCreationFailure(mailboxCreationId, (Exception)e), (Object)processingContext), (Function1 & Serializable)creationResponseWithUpdatedContext -> new Tuple2((Object)new MailboxCreationSuccess(mailboxCreationId, (MailboxCreationResponse)creationResponseWithUpdatedContext._1()), creationResponseWithUpdatedContext._2()));
    }

    private Either<MailboxCreationParseException, MailboxCreationRequest> parseCreate(JsObject jsObject) {
        return MailboxCreationRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJsObject -> {
            JsResult jsResult = Json$.MODULE$.fromJson((JsValue)validJsObject, $this.serializer.mailboxCreationRequest());
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MailboxCreationRequest creationRequest = (MailboxCreationRequest)jsSuccess.value();
                return new Right((Object)creationRequest);
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                return new Left((Object)new MailboxCreationParseException(this.mailboxSetError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors)));
            }
            throw new MatchError((Object)jsResult);
        });
    }

    private Either<Exception, MailboxPath> resolvePath(MailboxSession mailboxSession, MailboxCreationRequest mailboxCreationRequest) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(mailboxCreationRequest.name()), mailboxSession.getPathDelimiter())) {
            return new Left((Object)new MailboxNameException("The mailbox '" + mailboxCreationRequest.name() + "' contains an illegal character: '" + mailboxSession.getPathDelimiter() + "'"));
        }
        return (Either)mailboxCreationRequest.parentId().map((Function1 & Serializable)maybeParentId -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.mailboxIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)maybeParentId.id()), RefType$.MODULE$.refinedRefType()))).toEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.getMessage(), (Throwable)e)).flatMap((Function1 & Serializable)parentId -> this.retrievePath((MailboxId)parentId, mailboxSession).map((Function1 & Serializable)parentPath -> parentPath.child((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType()), mailboxSession.getPathDelimiter())))).getOrElse((Function0 & Serializable)() -> new Right((Object)MailboxPath.forUser((Username)mailboxSession.getUser(), (String)((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType())))));
    }

    private Either<Exception, MailboxPath> retrievePath(MailboxId mailboxId, MailboxSession mailboxSession) {
        Right right;
        try {
            right = new Right((Object)this.mailboxManager.getMailbox(mailboxId, mailboxSession).getMailboxPath());
        }
        catch (Exception e) {
            right = new Left((Object)e);
        }
        return right;
    }

    private Either<IllegalArgumentException, ProcessingContext> recordCreationIdInProcessingContext(MailboxCreationId mailboxCreationId, ProcessingContext processingContext, MailboxId mailboxId) {
        return Id$.MODULE$.validate(mailboxId.serialize()).map((Function1 & Serializable)serverAssignedId -> processingContext.recordCreatedId(new ClientId(mailboxCreationId.id()), new ServerId((String)((Refined)serverAssignedId).value())));
    }

    private SetError mailboxSetError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        return package$.MODULE$.standardError(errors);
    }

    private Either<Exception, MailboxCreationResponse> createMailbox(MailboxSession mailboxSession, MailboxPath path, MailboxCreationRequest mailboxCreationRequest) {
        Left left;
        try {
            MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(path, mailboxSession).get();
            boolean defaultSubscribed = true;
            if (((IsSubscribed)mailboxCreationRequest.isSubscribed().getOrElse((Function0 & Serializable)() -> new IsSubscribed(defaultSubscribed))).value()) {
                this.subscriptionManager.subscribe(mailboxSession, path);
            }
            mailboxCreationRequest.rights().foreach((Function1 & Serializable)rights -> {
                this.mailboxManager.setRights(mailboxId, rights.toMailboxAcl().asJava(), mailboxSession);
                return BoxedUnit.UNIT;
            });
            SMono qual$1 = this.quotaFactory.loadFor(mailboxSession).flatMap((Function1 & Serializable)quotaLoader -> quotaLoader.getQuotas(path));
            Duration x$1 = qual$1.block$default$1();
            Map<QuotaId, Quota> quotas = ((Quotas)qual$1.block(x$1)).quotas();
            MailboxId x$2 = mailboxId;
            SortOrder x$3 = SortOrder$.MODULE$.defaultSortOrder();
            None$ x$4 = None$.MODULE$;
            TotalEmails x$5 = new TotalEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadEmails x$6 = new UnreadEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            TotalThreads x$7 = new TotalThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadThreads x$8 = new UnreadThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            MailboxRights x$9 = MailboxRights$.MODULE$.FULL();
            Some x$10 = new Some((Object)new Quotas(quotas));
            None$ x$11 = mailboxCreationRequest.isSubscribed().isEmpty() ? new Some((Object)new IsSubscribed(defaultSubscribed)) : None$.MODULE$;
            Right right = new Right((Object)new MailboxCreationResponse(x$2, (Option<Role>)x$4, x$3, x$5, x$6, x$7, x$8, x$9, (Option<Quotas>)x$10, (Option<IsSubscribed>)x$11));
            left = right;
        }
        catch (Exception error) {
            left = new Left((Object)error);
        }
        return left;
    }

    @Inject
    public MailboxSetCreatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory, QuotaLoaderWithPreloadedDefaultFactory quotaFactory, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.quotaFactory = quotaFactory;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
    }

    public static class MailboxCreationFailure
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final Exception exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public Exception exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            Exception exception = this.exception();
            if (exception instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)((Object)exception);
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Can't create mailbox: Mailbox not found: {}", (Object)mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxNotFoundException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (exception instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Mailbox already exists: {}", (Object)mailboxExistsException.getMailboxName());
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            }
            if (exception instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Invalid mailbox name: {}", (Object)mailboxNameException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            }
            if (exception instanceof MailboxCreationParseException) {
                MailboxCreationParseException mailboxCreationParseException = (MailboxCreationParseException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Failed to parse mailbox creation request", (Throwable)mailboxCreationParseException);
                return mailboxCreationParseException.setError();
            }
            if (exception instanceof InsufficientRightsException) {
                InsufficientRightsException insufficientRightsException = (InsufficientRightsException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Insufficient rights to create a mailbox", (Throwable)insufficientRightsException);
                return SetError$.MODULE$.forbidden("Insufficient rights", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().error("Failed to create mailbox", (Throwable)exception);
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxCreationFailure copy(MailboxCreationId mailboxCreationId, Exception exception) {
            return new MailboxCreationFailure(mailboxCreationId, exception);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public Exception copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxCreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxCreationId();
                }
                case 1: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxCreationId";
                }
                case 1: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationFailure.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            Exception exception = this.exception();
            Exception exception2 = mailboxCreationFailure.exception();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!mailboxCreationFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationFailure(MailboxCreationId mailboxCreationId, Exception exception) {
            this.mailboxCreationId = mailboxCreationId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxCreationResult {
        public MailboxCreationId mailboxCreationId();
    }

    public static class MailboxCreationResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<MailboxCreationResult> created;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> created() {
            return this.created;
        }

        public Map<MailboxCreationId, MailboxCreationResponse> retrieveCreated() {
            return (Map)((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationSuccess) {
                    MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)mailboxCreationResult;
                    return new Some((Object)new Tuple2((Object)mailboxCreationSuccess.mailboxCreationId(), (Object)mailboxCreationSuccess.mailboxCreationResponse()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)creation -> new Tuple2(creation._1(), creation._2()));
        }

        public Map<MailboxCreationId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationFailure) {
                    MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)mailboxCreationResult;
                    return new Some((Object)new Tuple2((Object)mailboxCreationFailure.mailboxCreationId(), (Object)mailboxCreationFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxCreationResults copy(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            return new MailboxCreationResults(created);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> copy$default$1() {
            return this.created();
        }

        public String productPrefix() {
            return "MailboxCreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.created();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "created";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationResults mailboxCreationResults = (MailboxCreationResults)x$1;
            scala.collection.immutable.Seq<MailboxCreationResult> seq = this.created();
            scala.collection.immutable.Seq<MailboxCreationResult> seq2 = mailboxCreationResults.created();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxCreationResults.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationResults(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            this.created = created;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxCreationSuccess
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final MailboxCreationResponse mailboxCreationResponse;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public MailboxCreationResponse mailboxCreationResponse() {
            return this.mailboxCreationResponse;
        }

        public MailboxCreationSuccess copy(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            return new MailboxCreationSuccess(mailboxCreationId, mailboxCreationResponse);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public MailboxCreationResponse copy$default$2() {
            return this.mailboxCreationResponse();
        }

        public String productPrefix() {
            return "MailboxCreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxCreationId();
                }
                case 1: {
                    return this.mailboxCreationResponse();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxCreationId";
                }
                case 1: {
                    return "mailboxCreationResponse";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationSuccess.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            MailboxCreationResponse mailboxCreationResponse = this.mailboxCreationResponse();
            MailboxCreationResponse mailboxCreationResponse2 = mailboxCreationSuccess.mailboxCreationResponse();
            if (mailboxCreationResponse == null) {
                if (mailboxCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationResponse).equals(mailboxCreationResponse2)) return false;
            if (!mailboxCreationSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationSuccess(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            this.mailboxCreationId = mailboxCreationId;
            this.mailboxCreationResponse = mailboxCreationResponse;
            Product.$init$((Product)this);
        }
    }
}

