/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.EmailCreationId;
import org.apache.james.jmap.mail.EmailCreationRequest;
import org.apache.james.jmap.mail.EmailCreationResponse;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ThreadId$;
import org.apache.james.jmap.method.EmailSetCreatePerformer$;
import org.apache.james.jmap.method.EmailSetCreatePerformer$CreationResults$;
import org.apache.james.jmap.method.SizeExceededException;
import org.apache.james.jmap.routes.BlobNotFoundException;
import org.apache.james.jmap.routes.BlobResolvers;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.html.HtmlTextExtractor;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r-x!\u0002/^\u0011\u0003Ag!\u00026^\u0011\u0003Y\u0007\"\u0002:\u0002\t\u0003\u0019\bb\u0002;\u0002\u0005\u0004%I!\u001e\u0005\u0007y\u0006\u0001\u000b\u0011\u0002<\u0007\tu\f\u0001I \u0005\u000b\u0003;)!Q3A\u0005\u0002\u0005}\u0001BCA\u0018\u000b\tE\t\u0015!\u0003\u0002\"!1!/\u0002C\u0001\u0003cAq!a\u000e\u0006\t\u0003\tI\u0004C\u0004\u0002d\u0015!\t!!\u001a\t\u0013\u0005]T!!A\u0005\u0002\u0005e\u0004\"CA?\u000bE\u0005I\u0011AA@\u0011%\t)*BA\u0001\n\u0003\n9\nC\u0005\u0002*\u0016\t\t\u0011\"\u0001\u0002,\"I\u00111W\u0003\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003\u0003,\u0011\u0011!C!\u0003\u0007D\u0011\"!5\u0006\u0003\u0003%\t!a5\t\u0013\u0005uW!!A\u0005B\u0005}\u0007\"CAr\u000b\u0005\u0005I\u0011IAs\u0011%\t9/BA\u0001\n\u0003\nI\u000fC\u0005\u0002l\u0016\t\t\u0011\"\u0011\u0002n\u001eI\u0011\u0011_\u0001\u0002\u0002#\u0005\u00111\u001f\u0004\t{\u0006\t\t\u0011#\u0001\u0002v\"1!o\u0006C\u0001\u0005\u001bA\u0011\"a:\u0018\u0003\u0003%)%!;\t\u0013\t=q#!A\u0005\u0002\nE\u0001\"\u0003B\u000b/\u0005\u0005I\u0011\u0011B\f\u0011%\u0011ybFA\u0001\n\u0013\u0011\tCB\u0005\u0002,\u0005\u0001\n1%\u0001\u0002.\u00191!\u0011F\u0001A\u0005WA!B!\f\u001f\u0005+\u0007I\u0011\u0001B\u0018\u0011)\u0011\tD\bB\tB\u0003%\u0011\u0011\u000b\u0005\u000b\u0005gq\"Q3A\u0005\u0002\tU\u0002B\u0003B\u001c=\tE\t\u0015!\u0003\u0002^!1!O\bC\u0001\u0005sA\u0011\"a\u001e\u001f\u0003\u0003%\tA!\u0011\t\u0013\u0005ud$%A\u0005\u0002\t\u001d\u0003\"\u0003B&=E\u0005I\u0011\u0001B'\u0011%\t)JHA\u0001\n\u0003\n9\nC\u0005\u0002*z\t\t\u0011\"\u0001\u0002,\"I\u00111\u0017\u0010\u0002\u0002\u0013\u0005!\u0011\u000b\u0005\n\u0003\u0003t\u0012\u0011!C!\u0003\u0007D\u0011\"!5\u001f\u0003\u0003%\tA!\u0016\t\u0013\u0005ug$!A\u0005B\te\u0003\"CAr=\u0005\u0005I\u0011IAs\u0011%\t9OHA\u0001\n\u0003\nI\u000fC\u0005\u0002lz\t\t\u0011\"\u0011\u0003^\u001dI!\u0011M\u0001\u0002\u0002#\u0005!1\r\u0004\n\u0005S\t\u0011\u0011!E\u0001\u0005KBaA]\u0019\u0005\u0002\t5\u0004\"CAtc\u0005\u0005IQIAu\u0011%\u0011y!MA\u0001\n\u0003\u0013y\u0007C\u0005\u0003\u0016E\n\t\u0011\"!\u0003v!I!qD\u0019\u0002\u0002\u0013%!\u0011\u0005\u0004\u0007\u0005\u0003\u000b\u0001Ia!\t\u0015\t5rG!f\u0001\n\u0003\u0011y\u0003\u0003\u0006\u00032]\u0012\t\u0012)A\u0005\u0003#B!B!\"8\u0005+\u0007I\u0011\u0001BD\u0011)\u0011yi\u000eB\tB\u0003%!\u0011\u0012\u0005\u0007e^\"\tA!%\t\u000f\teu\u0007\"\u0001\u0003\u001c\"I\u0011qO\u001c\u0002\u0002\u0013\u0005!Q\u0014\u0005\n\u0003{:\u0014\u0013!C\u0001\u0005\u000fB\u0011Ba\u00138#\u0003%\tAa)\t\u0013\u0005Uu'!A\u0005B\u0005]\u0005\"CAUo\u0005\u0005I\u0011AAV\u0011%\t\u0019lNA\u0001\n\u0003\u00119\u000bC\u0005\u0002B^\n\t\u0011\"\u0011\u0002D\"I\u0011\u0011[\u001c\u0002\u0002\u0013\u0005!1\u0016\u0005\n\u0003;<\u0014\u0011!C!\u0005_C\u0011\"a98\u0003\u0003%\t%!:\t\u0013\u0005\u001dx'!A\u0005B\u0005%\b\"CAvo\u0005\u0005I\u0011\tBZ\u000f%\u00119,AA\u0001\u0012\u0003\u0011ILB\u0005\u0003\u0002\u0006\t\t\u0011#\u0001\u0003<\"1!o\u0013C\u0001\u0005\u007fC\u0011\"a:L\u0003\u0003%)%!;\t\u0013\t=1*!A\u0005\u0002\n\u0005\u0007\"\u0003B\u000b\u0017\u0006\u0005I\u0011\u0011Bd\u0011%\u0011ybSA\u0001\n\u0013\u0011\tCB\u0003k;\u0002\u0011y\r\u0003\u0006\u0003RF\u0013\t\u0011)A\u0005\u0005'D!Ba8R\u0005\u0003\u0005\u000b\u0011\u0002Bq\u0011)\u0011i/\u0015B\u0001B\u0003%!q\u001e\u0005\u000b\u0005\u007f\f&\u0011!Q\u0001\n\r\u0005\u0001BCB\u0007#\n\u0005\t\u0015!\u0003\u0004\u0010!1!/\u0015C\u0001\u0007/Aqaa\u000eR\t\u0003\u0019I\u0004C\u0004\u00048E#Iaa\u001f\t\u000f\r5\u0015\u000b\"\u0003\u0004\u0010\"91QY)\u0005\n\r\u001d\u0017aF#nC&d7+\u001a;De\u0016\fG/\u001a)fe\u001a|'/\\3s\u0015\tqv,\u0001\u0004nKRDw\u000e\u001a\u0006\u0003A\u0006\fAA[7ba*\u0011!mY\u0001\u0006U\u0006lWm\u001d\u0006\u0003I\u0016\fa!\u00199bG\",'\"\u00014\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005%\fQ\"A/\u0003/\u0015k\u0017-\u001b7TKR\u001c%/Z1uKB+'OZ8s[\u0016\u00148CA\u0001m!\ti\u0007/D\u0001o\u0015\u0005y\u0017!B:dC2\f\u0017BA9o\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001[\u0001\u0007\u0019>;u)\u0012*\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!_3\u0002\u000bMdg\r\u000e6\n\u0005mD(A\u0002'pO\u001e,'/A\u0004M\u001f\u001e;UI\u0015\u0011\u0003\u001f\r\u0013X-\u0019;j_:\u0014Vm];miN\u001cR!\u00027\u0000\u0003\u000b\u00012!\\A\u0001\u0013\r\t\u0019A\u001c\u0002\b!J|G-^2u!\u0011\t9!a\u0006\u000f\t\u0005%\u00111\u0003\b\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB4\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0017bAA\u000b]\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\r\u00037\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!!\u0006o\u0003\u001d\u0011Xm];miN,\"!!\t\u0011\r\u0005\u001d\u00111EA\u0014\u0013\u0011\t)#a\u0007\u0003\u0007M+\u0017\u000fE\u0002\u0002*ui\u0011!\u0001\u0002\u000f\u0007J,\u0017\r^5p]J+7/\u001e7u'\tiB.\u0001\u0005sKN,H\u000e^:!)\u0011\t\u0019$!\u000e\u0011\u0007\u0005%R\u0001C\u0004\u0002\u001e!\u0001\r!!\t\u0002\u000f\r\u0014X-\u0019;fIV\u0011\u00111\b\t\u0006[\u0006u\u0012\u0011I\u0005\u0004\u0003\u007fq'AB(qi&|g\u000e\u0005\u0005\u0002D\u0005-\u0013\u0011KA/\u001d\u0011\t)%a\u0012\u0011\u0007\u0005-a.C\u0002\u0002J9\fa\u0001\u0015:fI\u00164\u0017\u0002BA'\u0003\u001f\u00121!T1q\u0015\r\tIE\u001c\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011qK0\u0002\t5\f\u0017\u000e\\\u0005\u0005\u00037\n)FA\bF[\u0006LGn\u0011:fCRLwN\\%e!\u0011\t\u0019&a\u0018\n\t\u0005\u0005\u0014Q\u000b\u0002\u0016\u000b6\f\u0017\u000e\\\"sK\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0003)qw\u000e^\"sK\u0006$X\rZ\u000b\u0003\u0003O\u0002R!\\A\u001f\u0003S\u0002\u0002\"a\u0011\u0002L\u0005E\u00131\u000e\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O0\u0002\t\r|'/Z\u0005\u0005\u0003k\nyG\u0001\u0005TKR,%O]8s\u0003\u0011\u0019w\u000e]=\u0015\t\u0005M\u00121\u0010\u0005\n\u0003;Y\u0001\u0013!a\u0001\u0003C\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0002*\"\u0011\u0011EABW\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u0013Ut7\r[3dW\u0016$'bAAH]\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001\u00027b]\u001eT!!a)\u0002\t)\fg/Y\u0005\u0005\u0003O\u000biJ\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003[\u00032!\\AX\u0013\r\t\tL\u001c\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003o\u000bi\fE\u0002n\u0003sK1!a/o\u0005\r\te.\u001f\u0005\n\u0003\u007f{\u0011\u0011!a\u0001\u0003[\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAc!\u0019\t9-!4\u000286\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017t\u0017AC2pY2,7\r^5p]&!\u0011qZAe\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U\u00171\u001c\t\u0004[\u0006]\u0017bAAm]\n9!i\\8mK\u0006t\u0007\"CA`#\u0005\u0005\t\u0019AA\\\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e\u0015\u0011\u001d\u0005\n\u0003\u007f\u0013\u0012\u0011!a\u0001\u0003[\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003[\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\u000ba!Z9vC2\u001cH\u0003BAk\u0003_D\u0011\"a0\u0016\u0003\u0003\u0005\r!a.\u0002\u001f\r\u0013X-\u0019;j_:\u0014Vm];miN\u00042!!\u000b\u0018'\u00159\u0012q\u001fB\u0002!!\tI0a@\u0002\"\u0005MRBAA~\u0015\r\tiP\\\u0001\beVtG/[7f\u0013\u0011\u0011\t!a?\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\u0011\u0011I!!)\u0002\u0005%|\u0017\u0002BA\r\u0005\u000f!\"!a=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u0005M\"1\u0003\u0005\b\u0003;Q\u0002\u0019AA\u0011\u0003\u001d)h.\u00199qYf$BA!\u0007\u0003\u001cA)Q.!\u0010\u0002\"!I!QD\u000e\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0012!\u0011\tYJ!\n\n\t\t\u001d\u0012Q\u0014\u0002\u0007\u001f\nTWm\u0019;\u0003\u001f\r\u0013X-\u0019;j_:\u001cVoY2fgN\u001crA\b7\u0002(}\f)!\u0001\u0005dY&,g\u000e^%e+\t\t\t&A\u0005dY&,g\u000e^%eA\u0005A!/Z:q_:\u001cX-\u0006\u0002\u0002^\u0005I!/Z:q_:\u001cX\r\t\u000b\u0007\u0005w\u0011iDa\u0010\u0011\u0007\u0005%b\u0004C\u0004\u0003.\r\u0002\r!!\u0015\t\u000f\tM2\u00051\u0001\u0002^Q1!1\bB\"\u0005\u000bB\u0011B!\f%!\u0003\u0005\r!!\u0015\t\u0013\tMB\u0005%AA\u0002\u0005uSC\u0001B%U\u0011\t\t&a!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\n\u0016\u0005\u0003;\n\u0019\t\u0006\u0003\u00028\nM\u0003\"CA`S\u0005\u0005\t\u0019AAW)\u0011\t)Na\u0016\t\u0013\u0005}6&!AA\u0002\u0005]F\u0003BAM\u00057B\u0011\"a0-\u0003\u0003\u0005\r!!,\u0015\t\u0005U'q\f\u0005\n\u0003\u007f{\u0013\u0011!a\u0001\u0003o\u000bqb\u0011:fCRLwN\\*vG\u000e,7o\u001d\t\u0004\u0003S\t4#B\u0019\u0003h\t\r\u0001CCA}\u0005S\n\t&!\u0018\u0003<%!!1NA~\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005G\"bAa\u000f\u0003r\tM\u0004b\u0002B\u0017i\u0001\u0007\u0011\u0011\u000b\u0005\b\u0005g!\u0004\u0019AA/)\u0011\u00119Ha \u0011\u000b5\fiD!\u001f\u0011\u000f5\u0014Y(!\u0015\u0002^%\u0019!Q\u00108\u0003\rQ+\b\u000f\\33\u0011%\u0011i\"NA\u0001\u0002\u0004\u0011YDA\bDe\u0016\fG/[8o\r\u0006LG.\u001e:f'\u001d9D.a\n\u0000\u0003\u000b\t\u0011!Z\u000b\u0003\u0005\u0013\u0003B!a\u0002\u0003\f&!!QRA\u000e\u0005%!\u0006N]8xC\ndW-\u0001\u0002fAQ1!1\u0013BK\u0005/\u00032!!\u000b8\u0011\u001d\u0011i\u0003\u0010a\u0001\u0003#BqA!\"=\u0001\u0004\u0011I)A\tbg6+7o]1hKN+G/\u0012:s_J,\"!a\u001b\u0015\r\tM%q\u0014BQ\u0011%\u0011iC\u0010I\u0001\u0002\u0004\t\t\u0006C\u0005\u0003\u0006z\u0002\n\u00111\u0001\u0003\nV\u0011!Q\u0015\u0016\u0005\u0005\u0013\u000b\u0019\t\u0006\u0003\u00028\n%\u0006\"CA`\u0007\u0006\u0005\t\u0019AAW)\u0011\t)N!,\t\u0013\u0005}V)!AA\u0002\u0005]F\u0003BAM\u0005cC\u0011\"a0G\u0003\u0003\u0005\r!!,\u0015\t\u0005U'Q\u0017\u0005\n\u0003\u007fK\u0015\u0011!a\u0001\u0003o\u000bqb\u0011:fCRLwN\u001c$bS2,(/\u001a\t\u0004\u0003SY5#B&\u0003>\n\r\u0001CCA}\u0005S\n\tF!#\u0003\u0014R\u0011!\u0011\u0018\u000b\u0007\u0005'\u0013\u0019M!2\t\u000f\t5b\n1\u0001\u0002R!9!Q\u0011(A\u0002\t%E\u0003\u0002Be\u0005\u001b\u0004R!\\A\u001f\u0005\u0017\u0004r!\u001cB>\u0003#\u0012I\tC\u0005\u0003\u001e=\u000b\t\u00111\u0001\u0003\u0014N\u0011\u0011\u000b\\\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002Bk\u00057l!Aa6\u000b\u0007\tew,\u0001\u0003kg>t\u0017\u0002\u0002Bo\u0005/\u0014!#R7bS2\u001cV\r^*fe&\fG.\u001b>fe\u0006i!\r\\8c%\u0016\u001cx\u000e\u001c<feN\u0004BAa9\u0003j6\u0011!Q\u001d\u0006\u0004\u0005O|\u0016A\u0002:pkR,7/\u0003\u0003\u0003l\n\u0015(!\u0004\"m_\n\u0014Vm]8mm\u0016\u00148/A\tii6dG+\u001a=u\u000bb$(/Y2u_J\u0004BA!=\u0003|6\u0011!1\u001f\u0006\u0005\u0005k\u001490\u0001\u0003ii6d'b\u0001B}C\u0006!Q\u000f^5m\u0013\u0011\u0011iPa=\u0003#!#X\u000e\u001c+fqR,\u0005\u0010\u001e:bGR|'/\u0001\bnC&d'm\u001c=NC:\fw-\u001a:\u0011\t\r\r1\u0011B\u0007\u0003\u0007\u000bQ1aa\u0002b\u0003\u001di\u0017-\u001b7c_bLAaa\u0003\u0004\u0006\tqQ*Y5mE>DX*\u00198bO\u0016\u0014\u0018!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0003\u0004\u0012\rMQ\"A0\n\u0007\rUqLA\tK\u001b\u0006\u00036i\u001c8gS\u001e,(/\u0019;j_:$Bb!\u0007\u0004\u001c\ru1qDB\u0011\u0007G\u0001\"![)\t\u000f\tEw\u000b1\u0001\u0003T\"9!q\\,A\u0002\t\u0005\bb\u0002Bw/\u0002\u0007!q\u001e\u0005\b\u0005\u007f<\u0006\u0019AB\u0001\u0011\u001d\u0019ia\u0016a\u0001\u0007\u001fA3aVB\u0014!\u0011\u0019Ica\r\u000e\u0005\r-\"\u0002BB\u0017\u0007_\ta!\u001b8kK\u000e$(BAB\u0019\u0003\u001dQ\u0017m[1si\u0006LAa!\u000e\u0004,\t1\u0011J\u001c6fGR\faa\u0019:fCR,GCBB\u001e\u0007O\u001a\t\b\u0005\u0004\u0004>\r-3qJ\u0007\u0003\u0007\u007fQAa!\u0011\u0004D\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0004_\u000e\u0015#\u0002BA9\u0007\u000fR!a!\u0013\u0002\u000fI,\u0017m\u0019;pe&!1QJB \u0005\u0015\u0019Vj\u001c8p!\r\u0019\t&\u0002\b\u0004\u0007'\u0002a\u0002BB+\u0007KrAaa\u0016\u0004d9!1\u0011LB1\u001d\u0011\u0019Yfa\u0018\u000f\t\u0005-1QL\u0005\u0002M&\u0011A-Z\u0005\u0003E\u000eL!\u0001Y1\n\u0005y{\u0006bBB51\u0002\u000711N\u0001\be\u0016\fX/Z:u!\u0011\t\u0019f!\u001c\n\t\r=\u0014Q\u000b\u0002\u0010\u000b6\f\u0017\u000e\\*fiJ+\u0017/^3ti\"911\u000f-A\u0002\rU\u0014AD7bS2\u0014w\u000e_*fgNLwN\u001c\t\u0005\u0007\u0007\u00199(\u0003\u0003\u0004z\r\u0015!AD'bS2\u0014w\u000e_*fgNLwN\u001c\u000b\t\u0007{\u001a\tia!\u0004\fB11QHB&\u0007\u007f\u00022a!\u0015\u001e\u0011\u001d\u0011i#\u0017a\u0001\u0003#Bqa!\u001bZ\u0001\u0004\u0019)\t\u0005\u0003\u0002T\r\u001d\u0015\u0002BBE\u0003+\u0012A#R7bS2\u001c%/Z1uS>t'+Z9vKN$\bbBB:3\u0002\u00071QO\u0001\u0007CB\u0004XM\u001c3\u0015\u0015\rE5QSBL\u0007[\u001by\u000b\u0005\u0004\u0004>\r-31\u0013\t\u0004\u0007#r\u0002b\u0002B\u00175\u0002\u0007\u0011\u0011\u000b\u0005\b\u00073S\u0006\u0019ABN\u00035\t\u0007\u000f]3oI\u000e{W.\\1oIB!1QTBT\u001d\u0011\u0019yja)\u000f\t\r]3\u0011U\u0005\u0004\u0007\u000f\t\u0017\u0002BBS\u0007\u000b\ta\"T3tg\u0006<W-T1oC\u001e,'/\u0003\u0003\u0004*\u000e-&!D!qa\u0016tGmQ8n[\u0006tGM\u0003\u0003\u0004&\u000e\u0015\u0001bBB:5\u0002\u00071Q\u000f\u0005\b\u0007cS\u0006\u0019ABZ\u0003)i\u0017-\u001b7c_bLEm\u001d\t\u0007\u0003\u000f\u0019)l!/\n\t\r]\u00161\u0004\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0004<\u000e\u0005WBAB_\u0015\u0011\u0019yl!\u0002\u0002\u000b5|G-\u001a7\n\t\r\r7Q\u0018\u0002\n\u001b\u0006LGNY8y\u0013\u0012\fq\"Y:BaB,g\u000eZ\"p[6\fg\u000e\u001a\u000b\u0007\u0007\u0013\u001c)na6\u0011\u0011\u0005\u001d11ZBh\u00077KAa!4\u0002\u001c\t1Q)\u001b;iKJ\u0004B!a\u0002\u0004R&!11[A\u000e\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0005\b\u0007SZ\u0006\u0019ABC\u0011\u001d\u0019In\u0017a\u0001\u00077\fq!\\3tg\u0006<W\r\u0005\u0003\u0004^\u000e\u001dXBABp\u0015\u0011\u0019\toa9\u0002\u0007\u0011|WNC\u0002\u0004f\u0006\fa!\\5nKRR\u0017\u0002BBu\u0007?\u0014q!T3tg\u0006<W\r")
public class EmailSetCreatePerformer {
    private final EmailSetSerializer serializer;
    private final BlobResolvers blobResolvers;
    private final HtmlTextExtractor htmlTextExtractor;
    private final MailboxManager mailboxManager;
    private final JMAPConfiguration configuration;

    public SMono<CreationResults> create(EmailSetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.create().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                EmailCreationId clientId = (EmailCreationId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return (SMono)$this.serializer.deserializeCreationRequest((JsValue)json).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException(e.toString()))), (Function1 & Serializable)creationRequest -> (SMono)creationRequest.validateRequest().fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)x$3 -> this.create(clientId, (EmailCreationRequest)creationRequest, mailboxSession)));
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)EmailSetCreatePerformer$CreationResults$.MODULE$);
    }

    private SMono<CreationResult> create(EmailCreationId clientId, EmailCreationRequest request, MailboxSession mailboxSession) {
        List<MailboxId> mailboxIds = request.mailboxIds().value();
        if (mailboxIds.size() != 1) {
            return SMono$.MODULE$.just((Object)new CreationFailure(clientId, new IllegalArgumentException("mailboxIds need to have size 1")));
        }
        return SMono$.MODULE$.fromCallable(() -> request.toMime4JMessage($this.blobResolvers, $this.htmlTextExtractor, mailboxSession)).flatMap((Function1 & Serializable)either -> (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)message -> (SMono)this.asAppendCommand(request, (Message)message).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)appendCommand -> this.append(clientId, (MessageManager.AppendCommand)appendCommand, mailboxSession, mailboxIds)))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private SMono<CreationSuccess> append(EmailCreationId clientId, MessageManager.AppendCommand appendCommand, MailboxSession mailboxSession, List<MailboxId> mailboxIds) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive((MailboxId)mailboxIds.head(), mailboxSession)).flatMap((Function1 & Serializable)mailbox -> SMono$.MODULE$.apply(mailbox.appendMessageReactive(appendCommand, mailboxSession)).map((Function1 & Serializable)appendResult -> {
            Option blobId = BlobId$.MODULE$.of(appendResult.getId().getMessageId()).toOption();
            String threadId = ThreadId$.MODULE$.fromJava(appendResult.getThreadId());
            return new CreationSuccess(clientId, new EmailCreationResponse(appendResult.getId().getMessageId(), blobId, threadId, Size$.MODULE$.sanitizeSize(Predef$.MODULE$.Long2long(appendResult.getSize()))));
        }));
    }

    private Either<IllegalArgumentException, MessageManager.AppendCommand> asAppendCommand(EmailCreationRequest request, Message message) {
        return new Right((Object)MessageManager.AppendCommand.builder().recent().withFlags((Flags)request.keywords().map((Function1 & Serializable)x$4 -> x$4.asFlags()).getOrElse((Function0 & Serializable)() -> new Flags())).withInternalDate(Date.from(((UTCDate)request.receivedAt().getOrElse((Function0 & Serializable)() -> new UTCDate(ZonedDateTime.now()))).asUTC().toInstant())).build(message)).flatMap((Function1 & Serializable)appendCommand -> (Either)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.configuration.getMaximumSendSize())).filter((Function1 & Serializable)limit -> BoxesRunTime.boxToBoolean((boolean)EmailSetCreatePerformer.$anonfun$asAppendCommand$5(appendCommand, limit))).map((Function1 & Serializable)limit -> new Left((Object)new SizeExceededException(appendCommand.getMsgIn().size(), Predef$.MODULE$.Long2long(limit)))).getOrElse((Function0 & Serializable)() -> new Right(appendCommand)));
    }

    public static final /* synthetic */ boolean $anonfun$asAppendCommand$5(MessageManager.AppendCommand appendCommand$2, Long limit) {
        return appendCommand$2.getMsgIn().size() > Predef$.MODULE$.Long2long(limit);
    }

    @Inject
    public EmailSetCreatePerformer(EmailSetSerializer serializer, BlobResolvers blobResolvers, HtmlTextExtractor htmlTextExtractor, MailboxManager mailboxManager, JMAPConfiguration configuration) {
        this.serializer = serializer;
        this.blobResolvers = blobResolvers;
        this.htmlTextExtractor = htmlTextExtractor;
        this.mailboxManager = mailboxManager;
        this.configuration = configuration;
    }

    public static class CreationFailure
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                EmailSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetCreatePerformer$$LOGGER().info("Mailbox " + mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.notFound("Mailbox " + mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof BlobNotFoundException) {
                BlobNotFoundException blobNotFoundException = (BlobNotFoundException)throwable;
                EmailSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetCreatePerformer$$LOGGER().info("Attachment not found: " + new Refined((Object)blobNotFoundException.blobId().value()));
                return SetError$.MODULE$.invalidArguments("Attachment not found: " + new Refined((Object)blobNotFoundException.blobId().value()), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}))));
            }
            if (throwable instanceof SizeExceededException) {
                SizeExceededException sizeExceededException = (SizeExceededException)throwable;
                EmailSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetCreatePerformer$$LOGGER().info("Attempt to create too big of a message");
                return SetError$.MODULE$.tooLarge(sizeExceededException.getMessage());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                EmailSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetCreatePerformer$$LOGGER().info("Illegal argument in Email/set create", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                EmailSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetCreatePerformer$$LOGGER().info("Email/set failed because overquota");
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            EmailSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$EmailSetCreatePerformer$$LOGGER().error("Email/set failed to create a message", this.e());
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public CreationFailure copy(EmailCreationId clientId, Throwable e) {
            return new CreationFailure(clientId, e);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "CreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationFailure creationFailure = (CreationFailure)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationFailure.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = creationFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!creationFailure.canEqual(this)) return false;
            return true;
        }

        public CreationFailure(EmailCreationId clientId, Throwable e) {
            this.clientId = clientId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface CreationResult {
    }

    public static class CreationResults
    implements Product,
    Serializable {
        private final Seq<CreationResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<CreationResult> results() {
            return this.results;
        }

        public Option<Map<EmailCreationId, EmailCreationResponse>> created() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationSuccess) {
                    CreationSuccess creationSuccess = (CreationSuccess)creationResult;
                    return new Some((Object)new Tuple2((Object)creationSuccess.clientId(), (Object)creationSuccess.response()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<EmailCreationId, SetError>> notCreated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationFailure) {
                    CreationFailure creationFailure = (CreationFailure)creationResult;
                    return new Some((Object)new Tuple2((Object)creationFailure.clientId(), (Object)creationFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public CreationResults copy(Seq<CreationResult> results) {
            return new CreationResults(results);
        }

        public Seq<CreationResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "CreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationResults creationResults = (CreationResults)x$1;
            Seq<CreationResult> seq = this.results();
            Seq<CreationResult> seq2 = creationResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!creationResults.canEqual(this)) return false;
            return true;
        }

        public CreationResults(Seq<CreationResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class CreationSuccess
    implements CreationResult,
    Product,
    Serializable {
        private final EmailCreationId clientId;
        private final EmailCreationResponse response;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public EmailCreationId clientId() {
            return this.clientId;
        }

        public EmailCreationResponse response() {
            return this.response;
        }

        public CreationSuccess copy(EmailCreationId clientId, EmailCreationResponse response) {
            return new CreationSuccess(clientId, response);
        }

        public EmailCreationId copy$default$1() {
            return this.clientId();
        }

        public EmailCreationResponse copy$default$2() {
            return this.response();
        }

        public String productPrefix() {
            return "CreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.response();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "response";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationSuccess creationSuccess = (CreationSuccess)x$1;
            EmailCreationId emailCreationId = this.clientId();
            EmailCreationId emailCreationId2 = creationSuccess.clientId();
            if (emailCreationId == null) {
                if (emailCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationId).equals(emailCreationId2)) return false;
            EmailCreationResponse emailCreationResponse = this.response();
            EmailCreationResponse emailCreationResponse2 = creationSuccess.response();
            if (emailCreationResponse == null) {
                if (emailCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)emailCreationResponse).equals(emailCreationResponse2)) return false;
            if (!creationSuccess.canEqual(this)) return false;
            return true;
        }

        public CreationSuccess(EmailCreationId clientId, EmailCreationResponse response) {
            this.clientId = clientId;
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

