/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.jmap.mail.EmailFullView;
import org.apache.james.jmap.mail.EmailFullViewFactory;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailViewReader;
import org.apache.james.jmap.mail.GenericEmailViewReader;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.html.HtmlTextExtractor;
import reactor.core.scala.publisher.SFlux;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}4A\u0001C\u0005\u0005)!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\"\u0002\u001c\u0001\t\u00039\u0004bB#\u0001\u0005\u0004%IA\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B$\t\u000b-\u0003A\u0011\t'\u0003'\u0015k\u0017-\u001b7Gk2dg+[3x%\u0016\fG-\u001a:\u000b\u0005)Y\u0011\u0001B7bS2T!\u0001D\u0007\u0002\t)l\u0017\r\u001d\u0006\u0003\u001d=\tQA[1nKNT!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u00042\u0001H\u000f \u001b\u0005I\u0011B\u0001\u0010\n\u0005=)U.Y5m-&,wOU3bI\u0016\u0014\bC\u0001\u000f!\u0013\t\t\u0013BA\u0007F[\u0006LGNR;mYZKWm^\u0001\u0011[\u0016\u001c8/Y4f\u0013\u0012l\u0015M\\1hKJ\u0004\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u0007\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011\u0001&\n\u0002\u0011\u001b\u0016\u001c8/Y4f\u0013\u0012l\u0015M\\1hKJ\f\u0011\u0003\u001b;nYR+\u0007\u0010^#yiJ\f7\r^8s!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003ii6d'BA\u0018\u000e\u0003\u0011)H/\u001b7\n\u0005Eb#!\u0005%u[2$V\r\u001f;FqR\u0014\u0018m\u0019;pe\u0006ya-\u001e7m-&,wOR1di>\u0014\u0018\u0010\u0005\u0002\u001di%\u0011Q'\u0003\u0002\u0015\u000b6\f\u0017\u000e\u001c$vY24\u0016.Z<GC\u000e$xN]=\u0002\rqJg.\u001b;?)\u0011A\u0014HO\u001e\u0011\u0005q\u0001\u0001\"\u0002\u0012\u0005\u0001\u0004\u0019\u0003\"B\u0015\u0005\u0001\u0004Q\u0003\"\u0002\u001a\u0005\u0001\u0004\u0019\u0004F\u0001\u0003>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004j]*,7\r\u001e\u0006\u0002\u0005\u00069!.Y6beR\f\u0017B\u0001#@\u0005\u0019IeN[3di\u00061!/Z1eKJ,\u0012a\u0012\t\u00049!{\u0012BA%\n\u0005Y9UM\\3sS\u000e,U.Y5m-&,wOU3bI\u0016\u0014\u0018a\u0002:fC\u0012,'\u000fI\u0001\u0005e\u0016\fG-\u0006\u0002N7R!a*Y;{!\ryu+W\u0007\u0002!*\u0011\u0011KU\u0001\naV\u0014G.[:iKJT!\u0001G*\u000b\u0005Q+\u0016\u0001B2pe\u0016T\u0011AV\u0001\be\u0016\f7\r^8s\u0013\tA\u0006KA\u0003T\r2,\b\u0010\u0005\u0002[72\u0001A!\u0002/\b\u0005\u0004i&!\u0001+\u0012\u0005}q\u0006C\u0001\f`\u0013\t\u0001wCA\u0002B]fDQAY\u0004A\u0002\r\f1!\u001b3t!\r!Gn\u001c\b\u0003K*t!AZ5\u000e\u0003\u001dT!\u0001[\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012BA6\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001c8\u0003\u0007M+\u0017O\u0003\u0002l/A\u0011\u0001o]\u0007\u0002c*\u0011!/J\u0001\u0006[>$W\r\\\u0005\u0003iF\u0014\u0011\"T3tg\u0006<W-\u00133\t\u000bY<\u0001\u0019A<\u0002\u000fI,\u0017/^3tiB\u0011A\u0004_\u0005\u0003s&\u0011q\"R7bS2<U\r\u001e*fcV,7\u000f\u001e\u0005\u0006w\u001e\u0001\r\u0001`\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\t!S0\u0003\u0002\u007fK\tqQ*Y5mE>D8+Z:tS>t\u0007")
public class EmailFullViewReader
implements EmailViewReader<EmailFullView> {
    private final GenericEmailViewReader<EmailFullView> reader;

    private GenericEmailViewReader<EmailFullView> reader() {
        return this.reader;
    }

    @Override
    public <T> SFlux<T> read(scala.collection.immutable.Seq<MessageId> ids, EmailGetRequest request, MailboxSession mailboxSession) {
        AuditTrail.entry().username(() -> mailboxSession.getUser().asString()).protocol("JMAP").action("Email full view read").parameters(() -> ImmutableMap.of((Object)"messageIds", (Object)StringUtils.join((Object[])new List[]{CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ids).asJava()}), (Object)"loggedInUser", (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser())).map((Function1 & Serializable)x$31 -> x$31.asString()).getOrElse((Function0 & Serializable)() -> ""))).log("JMAP Email full view read.");
        return this.reader().read(ids, request, mailboxSession);
    }

    @Inject
    public EmailFullViewReader(MessageIdManager messageIdManager, HtmlTextExtractor htmlTextExtractor, EmailFullViewFactory fullViewFactory) {
        this.reader = new GenericEmailViewReader<EmailFullView>(messageIdManager, FetchGroup.FULL_CONTENT, htmlTextExtractor, fullViewFactory);
    }
}

