/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.change;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.time.Clock;
import java.time.ZonedDateTime;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.MailboxAndEmailChange;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.State;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxChangeListener$;
import org.apache.james.jmap.change.MailboxChangeListenerGroup;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u001dt!\u0002\u001a4\u0011\u0003qd!\u0002!4\u0011\u0003\t\u0005\"\u0002)\u0002\t\u0003\t\u0006b\u0002*\u0002\u0005\u0004%\ta\u0015\u0005\u00075\u0006\u0001\u000b\u0011\u0002+\t\u000fm\u000b\u0011\u0011!CA9\"I1qJ\u0001\u0002\u0002\u0013\u00055\u0011\u000b\u0005\n\u0007G\n\u0011\u0011!C\u0005\u0007K2A\u0001Q\u001aA=\"Q\u0011\u0011\u0002\u0005\u0003\u0016\u0004%\t!a\u0003\t\u0015\u0005U\u0001B!E!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u0018!\u0011)\u001a!C\u0001\u00033A!\"!\u000b\t\u0005#\u0005\u000b\u0011BA\u000e\u0011)\tY\u0003\u0003BK\u0002\u0013\u0005\u0011Q\u0006\u0005\u000b\u0003{A!\u0011#Q\u0001\n\u0005=\u0002BCA \u0011\tU\r\u0011\"\u0001\u0002B!Q\u0011\u0011\n\u0005\u0003\u0012\u0003\u0006I!a\u0011\t\u0015\u0005-\u0003B!f\u0001\n\u0003\ti\u0005\u0003\u0006\u0002\\!\u0011\t\u0012)A\u0005\u0003\u001fB!\"!\u0018\t\u0005+\u0007I\u0011AA0\u0011)\ti\u0007\u0003B\tB\u0003%\u0011\u0011\r\u0005\u000b\u0003_B!Q3A\u0005\u0002\u0005E\u0004BCA@\u0011\tE\t\u0015!\u0003\u0002t!1\u0001\u000b\u0003C\u0001\u0003\u0003Cq!!-\t\t\u0003\n\u0019\fC\u0004\u0002R\"!\t%a5\t\u000f\u0005m\u0007\u0002\"\u0011\u0002^\"9\u0011q\u001d\u0005\u0005\n\u0005%\bb\u0002B\u0012\u0011\u0011%!Q\u0005\u0005\b\u0005WAA\u0011\u0002B\u0017\u0011\u001d\u0011\u0019\u0007\u0003C\u0005\u0005KBqAa\u001c\t\t\u0013\u0011\t\bC\u0004\u0003\u001a\"!IAa'\t\u0013\t\u001d\u0006\"!A\u0005\u0002\t%\u0006\"\u0003B]\u0011E\u0005I\u0011\u0001B^\u0011%\u0011\t\u000eCI\u0001\n\u0003\u0011\u0019\u000eC\u0005\u0003X\"\t\n\u0011\"\u0001\u0003Z\"I!Q\u001c\u0005\u0012\u0002\u0013\u0005!q\u001c\u0005\n\u0005GD\u0011\u0013!C\u0001\u0005KD\u0011B!;\t#\u0003%\tAa;\t\u0013\t=\b\"%A\u0005\u0002\tE\b\"\u0003B{\u0011\u0005\u0005I\u0011\tB|\u0011%\u0011y\u0010CA\u0001\n\u0003\u0019\t\u0001C\u0005\u0004\n!\t\t\u0011\"\u0001\u0004\f!I1q\u0003\u0005\u0002\u0002\u0013\u00053\u0011\u0004\u0005\n\u0007OA\u0011\u0011!C\u0001\u0007SA\u0011b!\f\t\u0003\u0003%\tea\f\t\u0013\rM\u0002\"!A\u0005B\rU\u0002\"CB\u001c\u0011\u0005\u0005I\u0011IB\u001d\u0011%\u0019Y\u0004CA\u0001\n\u0003\u001ai$A\u000bNC&d'm\u001c=DQ\u0006tw-\u001a'jgR,g.\u001a:\u000b\u0005Q*\u0014AB2iC:<WM\u0003\u00027o\u0005!!.\\1q\u0015\tA\u0014(A\u0003kC6,7O\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001\u0001\t\u0003\u007f\u0005i\u0011a\r\u0002\u0016\u001b\u0006LGNY8y\u0007\"\fgnZ3MSN$XM\\3s'\r\t!\t\u0013\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015AA5p\u0015\u0005i\u0015\u0001\u00026bm\u0006L!a\u0014&\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005q\u0014A\u0002'P\u000f\u001e+%+F\u0001U!\t)\u0006,D\u0001W\u0015\t96(A\u0003tY\u001a$$.\u0003\u0002Z-\n1Aj\\4hKJ\fq\u0001T(H\u000f\u0016\u0013\u0006%A\u0003baBd\u0017\u0010F\b^\u0007\u0003\u001a\u0019e!\u0012\u0004H\r%31JB'!\ty\u0004bE\u0003\t?\u0016LH\u0010\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0019\u0006!A.\u00198h\u0013\t!\u0017M\u0001\u0004PE*,7\r\u001e\t\u0003MZt!aZ:\u000f\u0005!\fhBA5q\u001d\tQwN\u0004\u0002l]6\tAN\u0003\u0002n{\u00051AH]8pizJ\u0011\u0001P\u0005\u0003umJ!\u0001O\u001d\n\u0005I<\u0014AB3wK:$8/\u0003\u0002uk\u0006iQI^3oi2K7\u000f^3oKJT!A]\u001c\n\u0005]D(A\u0007*fC\u000e$\u0018N^3He>,\b/\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(B\u0001;v!\t\u0019%0\u0003\u0002|\t\n9\u0001K]8ek\u000e$\bcA?\u0002\u00069\u0019a0!\u0001\u000f\u0005-|\u0018\"A#\n\u0007\u0005\rA)A\u0004qC\u000e\\\u0017mZ3\n\u0007=\u000b9AC\u0002\u0002\u0004\u0011\u000b\u0001\"\u001a<f]R\u0014Uo]\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00125\tQ/C\u0002\u0002\u0014U\u0014\u0001\"\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\nq#\\1jY\n|\u0007p\u00115b]\u001e,'+\u001a9pg&$xN]=\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Ki!!a\b\u000b\u0007Q\n\tCC\u0002\u0002$U\n1!\u00199j\u0013\u0011\t9#a\b\u0003/5\u000b\u0017\u000e\u001c2pq\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\u0018\u0001G7bS2\u0014w\u000e_\"iC:<WMU3q_NLGo\u001c:zA\u0005!R.Y5mE>D8\t[1oO\u00164\u0015m\u0019;pef,\"!a\f\u0011\t\u0005E\u0012q\u0007\b\u0005\u0003;\t\u0019$\u0003\u0003\u00026\u0005}\u0011!D'bS2\u0014w\u000e_\"iC:<W-\u0003\u0003\u0002:\u0005m\"a\u0002$bGR|'/\u001f\u0006\u0005\u0003k\ty\"A\u000bnC&d'm\u001c=DQ\u0006tw-\u001a$bGR|'/\u001f\u0011\u0002+\u0015l\u0017-\u001b7DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ssV\u0011\u00111\t\t\u0005\u0003;\t)%\u0003\u0003\u0002H\u0005}!!F#nC&d7\t[1oO\u0016\u0014V\r]8tSR|'/_\u0001\u0017K6\f\u0017\u000e\\\"iC:<WMU3q_NLGo\u001c:zA\u0005\u0011R-\\1jY\u000eC\u0017M\\4f\r\u0006\u001cGo\u001c:z+\t\ty\u0005\u0005\u0003\u0002R\u0005]c\u0002BA\u000f\u0003'JA!!\u0016\u0002 \u0005)R*Y5mE>D\u0018I\u001c3F[\u0006LGn\u00115b]\u001e,\u0017\u0002BA\u001d\u00033RA!!\u0016\u0002 \u0005\u0019R-\\1jY\u000eC\u0017M\\4f\r\u0006\u001cGo\u001c:zA\u0005qQ.Y5mE>DX*\u00198bO\u0016\u0014XCAA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4o\u00059Q.Y5mE>D\u0018\u0002BA6\u0003K\u0012a\"T1jY\n|\u00070T1oC\u001e,'/A\bnC&d'm\u001c=NC:\fw-\u001a:!\u0003\u0015\u0019Gn\\2l+\t\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tI\bT\u0001\u0005i&lW-\u0003\u0003\u0002~\u0005]$!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007\u0005F\b^\u0003\u0007\u000bi*a(\u0002\"\u0006\r\u0016QUAT\u0011\u001d\tIa\u0006a\u0001\u0003\u001bA\u0003\"a!\u0002\b\u0006]\u0015\u0011\u0014\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0019IgN[3di*\u0011\u0011\u0011S\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\t)*a#\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0005\u0005m\u0015\u0001\u0002&N\u0003BCq!a\u0006\u0018\u0001\u0004\tY\u0002C\u0004\u0002,]\u0001\r!a\f\t\u000f\u0005}r\u00031\u0001\u0002D!9\u00111J\fA\u0002\u0005=\u0003bBA//\u0001\u0007\u0011\u0011\r\u0005\b\u0003_:\u0002\u0019AA:Q\r9\u00121\u0016\t\u0005\u0003\u0013\u000bi+\u0003\u0003\u00020\u0006-%AB%oU\u0016\u001cG/A\u0007sK\u0006\u001cG/\u001b<f\u000bZ,g\u000e\u001e\u000b\u0005\u0003k\u000b9\r\u0005\u0004\u00028\u0006u\u0016\u0011Y\u0007\u0003\u0003sS1!a/<\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018\u0002BA`\u0003s\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0007\u0001\f\u0019-C\u0002\u0002F\u0006\u0014AAV8jI\"9\u0011\u0011\u001a\rA\u0002\u0005-\u0017!B3wK:$\b\u0003BA\b\u0003\u001bL1!a4v\u0005\u0015)e/\u001a8u\u0003=9W\r\u001e#fM\u0006,H\u000e^$s_V\u0004HCAAk!\u0011\ty!a6\n\u0007\u0005eWOA\u0003He>,\b/\u0001\u0006jg\"\u000bg\u000e\u001a7j]\u001e$B!a8\u0002fB\u00191)!9\n\u0007\u0005\rHIA\u0004C_>dW-\u00198\t\u000f\u0005%'\u00041\u0001\u0002L\u0006Y!.\\1q\u0007\"\fgnZ3t)\u0011\tYOa\u0002\u0011\r\u00055\u0018Q B\u0001\u001b\t\tyO\u0003\u0003\u0002r\u0006M\u0018!\u00039vE2L7\u000f[3s\u0015\r)\u0015Q\u001f\u0006\u0005\u0003o\fI0\u0001\u0003d_J,'BAA~\u0003\u001d\u0011X-Y2u_JLA!a@\u0002p\n)1K\u00127vqB!\u0011Q\u0004B\u0002\u0013\u0011\u0011)!a\b\u0003\u0015)k\u0017\r]\"iC:<W\rC\u0004\u0003\nm\u0001\rAa\u0003\u0002\u00195\f\u0017\u000e\u001c2pq\u00163XM\u001c;\u0011\t\t5!Q\u0004\b\u0005\u0005\u001f\u00119B\u0004\u0003\u0003\u0012\tUab\u00015\u0003\u0014%\u0019\u0011qM\u001c\n\u0007I\f)'\u0003\u0003\u0003\u001a\tm\u0011!D'bS2\u0014w\u000e_#wK:$8OC\u0002s\u0003KJAAa\b\u0003\"\taQ*Y5mE>DXI^3oi*!!\u0011\u0004B\u000e\u0003=\u0019\u0018M^3DQ\u0006tw-Z#wK:$H\u0003BA[\u0005OAqA!\u000b\u001d\u0001\u0004\u0011\t!\u0001\u0006k[\u0006\u00048\t[1oO\u0016\f!bZ3u'\"\f'/Z3t)\u0019\u0011yCa\u0012\u0003VA1\u0011Q\u001eB\u0019\u0005kIAAa\r\u0002p\n)1+T8o_B)QPa\u000e\u0003<%!!\u0011HA\u0004\u0005\u0011a\u0015n\u001d;\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQAA!\u0011\u0002\"\u0005)Qn\u001c3fY&!!Q\tB \u0005%\t5mY8v]RLE\rC\u0004\u0003Ju\u0001\rAa\u0013\u0002\u00135\f\u0017\u000e\u001c2pq&#\u0007\u0003\u0002B'\u0005#j!Aa\u0014\u000b\t\t\u0005\u0013QM\u0005\u0005\u0005'\u0012yEA\u0005NC&d'm\u001c=JI\"9!qK\u000fA\u0002\te\u0013\u0001C;tKJt\u0017-\\3\u0011\t\tm#qL\u0007\u0003\u0005;R1!a>8\u0013\u0011\u0011\tG!\u0018\u0003\u0011U\u001bXM\u001d8b[\u0016\f!\u0003^8Ti\u0006$Xm\u00115b]\u001e,WI^3oiR!!q\rB7!\ry$\u0011N\u0005\u0004\u0005W\u001a$\u0001E*uCR,7\t[1oO\u0016,e/\u001a8u\u0011\u001d\u0011IC\ba\u0001\u0005\u0003\tq\"\\1jY\n|\u0007p\u0015;bi\u0016l\u0015\r\u001d\u000b\u0005\u0005g\u0012y\t\u0005\u0005\u0003v\tu$1\u0011BE\u001d\u0011\u00119H!\u001f\u0011\u0005-$\u0015b\u0001B>\t\u00061\u0001K]3eK\u001aLAAa \u0003\u0002\n\u0019Q*\u00199\u000b\u0007\tmD\t\u0005\u0003\u0003>\t\u0015\u0015\u0002\u0002BD\u0005\u007f\u0011\u0001\u0002V=qK:\u000bW.\u001a\t\u0005\u0005{\u0011Y)\u0003\u0003\u0003\u000e\n}\"!B*uCR,\u0007b\u0002BI?\u0001\u0007!1S\u0001\u000e[\u0006LGNY8y\u0007\"\fgnZ3\u0011\t\u0005u!QS\u0005\u0005\u0005/\u000byBA\u0007NC&d'm\u001c=DQ\u0006tw-Z\u0001\u000eK6\f\u0017\u000e\\*uCR,W*\u00199\u0015\t\tM$Q\u0014\u0005\b\u0005?\u0003\u0003\u0019\u0001BQ\u0003-)W.Y5m\u0007\"\fgnZ3\u0011\t\u0005u!1U\u0005\u0005\u0005K\u000byBA\u0006F[\u0006LGn\u00115b]\u001e,\u0017\u0001B2paf$r\"\u0018BV\u0005[\u0013yK!-\u00034\nU&q\u0017\u0005\n\u0003\u0013\t\u0003\u0013!a\u0001\u0003\u001bA\u0011\"a\u0006\"!\u0003\u0005\r!a\u0007\t\u0013\u0005-\u0012\u0005%AA\u0002\u0005=\u0002\"CA CA\u0005\t\u0019AA\"\u0011%\tY%\tI\u0001\u0002\u0004\ty\u0005C\u0005\u0002^\u0005\u0002\n\u00111\u0001\u0002b!I\u0011qN\u0011\u0011\u0002\u0003\u0007\u00111O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iL\u000b\u0003\u0002\u000e\t}6F\u0001Ba!\u0011\u0011\u0019M!4\u000e\u0005\t\u0015'\u0002\u0002Bd\u0005\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-G)\u0001\u0006b]:|G/\u0019;j_:LAAa4\u0003F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001b\u0016\u0005\u00037\u0011y,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm'\u0006BA\u0018\u0005\u007f\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003b*\"\u00111\tB`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"Aa:+\t\u0005=#qX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iO\u000b\u0003\u0002b\t}\u0016AD2paf$C-\u001a4bk2$HeN\u000b\u0003\u0005gTC!a\u001d\u0003@\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!?\u0011\u0007\u0001\u0014Y0C\u0002\u0003~\u0006\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAB\u0002!\r\u00195QA\u0005\u0004\u0007\u000f!%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB\u0007\u0007'\u00012aQB\b\u0013\r\u0019\t\u0002\u0012\u0002\u0004\u0003:L\b\"CB\u000bW\u0005\u0005\t\u0019AB\u0002\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u0004\t\u0007\u0007;\u0019\u0019c!\u0004\u000e\u0005\r}!bAB\u0011\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r\u00152q\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002`\u000e-\u0002\"CB\u000b[\u0005\u0005\t\u0019AB\u0007\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\te8\u0011\u0007\u0005\n\u0007+q\u0013\u0011!a\u0001\u0007\u0007\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0007\u0007\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005s\fa!Z9vC2\u001cH\u0003BAp\u0007\u007fA\u0011b!\u00062\u0003\u0003\u0005\ra!\u0004\t\u000f\u0005%Q\u00011\u0001\u0002\u000e!9\u0011qC\u0003A\u0002\u0005m\u0001bBA\u0016\u000b\u0001\u0007\u0011q\u0006\u0005\b\u0003\u007f)\u0001\u0019AA\"\u0011\u001d\tY%\u0002a\u0001\u0003\u001fBq!!\u0018\u0006\u0001\u0004\t\t\u0007C\u0004\u0002p\u0015\u0001\r!a\u001d\u0002\u000fUt\u0017\r\u001d9msR!11KB0!\u0015\u00195QKB-\u0013\r\u00199\u0006\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011#\r\u001bY&!\u0004\u0002\u001c\u0005=\u00121IA(\u0003C\n\u0019(C\u0002\u0004^\u0011\u0013a\u0001V;qY\u0016<\u0004\u0002CB1\r\u0005\u0005\t\u0019A/\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u0001`\u0001")
public class MailboxChangeListener
implements EventListener.ReactiveGroupEventListener,
Product,
Serializable {
    private final EventBus eventBus;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final MailboxChange.Factory mailboxChangeFactory;
    private final EmailChangeRepository emailChangeRepository;
    private final MailboxAndEmailChange.Factory emailChangeFactory;
    private final MailboxManager mailboxManager;
    private final Clock clock;

    public static Option<Tuple7<EventBus, MailboxChangeRepository, MailboxChange.Factory, EmailChangeRepository, MailboxAndEmailChange.Factory, MailboxManager, Clock>> unapply(MailboxChangeListener x$0) {
        return MailboxChangeListener$.MODULE$.unapply(x$0);
    }

    public static MailboxChangeListener apply(EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, MailboxAndEmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        return MailboxChangeListener$.MODULE$.apply(eventBus, mailboxChangeRepository, mailboxChangeFactory, emailChangeRepository, emailChangeFactory, mailboxManager, clock);
    }

    public static Logger LOGGER() {
        return MailboxChangeListener$.MODULE$.LOGGER();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public void event(Event event) throws Exception {
        super.event(event);
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public MailboxChangeRepository mailboxChangeRepository() {
        return this.mailboxChangeRepository;
    }

    public MailboxChange.Factory mailboxChangeFactory() {
        return this.mailboxChangeFactory;
    }

    public EmailChangeRepository emailChangeRepository() {
        return this.emailChangeRepository;
    }

    public MailboxAndEmailChange.Factory emailChangeFactory() {
        return this.emailChangeFactory;
    }

    public MailboxManager mailboxManager() {
        return this.mailboxManager;
    }

    public Clock clock() {
        return this.clock;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        SFlux<JmapChange> qual$1 = this.jmapChanges((MailboxEvents.MailboxEvent)event);
        Function1 & Serializable x$1 = (Function1 & Serializable)jmapChange -> this.saveChangeEvent((JmapChange)jmapChange);
        int x$2 = 16;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return reactor.core.scala.publisher.package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)qual$1.flatMap((Function1)x$1, 16, x$3, x$4).then());
    }

    public Group getDefaultGroup() {
        return new MailboxChangeListenerGroup();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxEvent;
    }

    private SFlux<JmapChange> jmapChanges(MailboxEvents.MailboxEvent mailboxEvent) {
        ZonedDateTime now = ZonedDateTime.now(this.clock());
        MailboxId mailboxId = mailboxEvent.getMailboxId();
        Username username = mailboxEvent.getUsername();
        MailboxEvents.MailboxEvent mailboxEvent2 = mailboxEvent;
        if (mailboxEvent2 instanceof MailboxEvents.MailboxAdded) {
            MailboxEvents.MailboxAdded mailboxAdded = (MailboxEvents.MailboxAdded)mailboxEvent2;
            return SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JmapChange[]{this.mailboxChangeFactory().fromMailboxAdded(mailboxAdded, now)}));
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxRenamed) {
            MailboxEvents.MailboxRenamed mailboxRenamed = (MailboxEvents.MailboxRenamed)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxRenamed(mailboxRenamed, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxACLUpdated) {
            MailboxEvents.MailboxACLUpdated mailboxACLUpdated = (MailboxEvents.MailboxACLUpdated)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxACLUpdated(mailboxACLUpdated, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)mailboxEvent2;
            return SFlux$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(this.mailboxChangeFactory().fromMailboxDeletion(mailboxDeletion, now)).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.Added) {
            MailboxEvents.Added added = (MailboxEvents.Added)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromAdded(added, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.FlagsUpdated) {
            MailboxEvents.FlagsUpdated flagsUpdated = (MailboxEvents.FlagsUpdated)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapIterable((Function1 & Serializable)sharees -> CollectionConverters$.MODULE$.ListHasAsScala(this.emailChangeFactory().fromFlagsUpdated(flagsUpdated, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees).asJava())).asScala());
        }
        if (mailboxEvent2 instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)mailboxEvent2;
            return this.getSharees(mailboxId, username).flatMapMany((Function1 & Serializable)sharees -> SFlux$.MODULE$.apply((Publisher)this.emailChangeFactory().fromExpunged(expunged, now, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)sharees.map((Function1 & Serializable)x$1 -> x$1.getIdentifier()).map((Function1 & Serializable)username -> Username.of((String)username))).asJava())));
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxSubscribedEvent) {
            MailboxEvents.MailboxSubscribedEvent mailboxSubscribedEvent = (MailboxEvents.MailboxSubscribedEvent)mailboxEvent2;
            return SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JmapChange[]{this.mailboxChangeFactory().fromMailboxSubscribed(mailboxSubscribedEvent, now)}));
        }
        if (mailboxEvent2 instanceof MailboxEvents.MailboxUnsubscribedEvent) {
            MailboxEvents.MailboxUnsubscribedEvent mailboxUnsubscribedEvent = (MailboxEvents.MailboxUnsubscribedEvent)mailboxEvent2;
            return SFlux$.MODULE$.just((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JmapChange[]{this.mailboxChangeFactory().fromMailboxUnSubscribed(mailboxUnsubscribedEvent, now)}));
        }
        throw new MatchError((Object)mailboxEvent2);
    }

    private Publisher<Void> saveChangeEvent(JmapChange jmapChange) {
        Mono mono;
        JmapChange jmapChange2 = jmapChange;
        if (jmapChange2 instanceof MailboxChange) {
            MailboxChange mailboxChange = (MailboxChange)jmapChange2;
            mono = this.mailboxChangeRepository().save(mailboxChange);
        } else if (jmapChange2 instanceof EmailChange) {
            EmailChange emailChange = (EmailChange)jmapChange2;
            mono = this.emailChangeRepository().save(emailChange);
        } else if (jmapChange2 instanceof MailboxAndEmailChange) {
            MailboxAndEmailChange mailboxAndEmailChange = (MailboxAndEmailChange)jmapChange2;
            mono = this.mailboxChangeRepository().save(mailboxAndEmailChange.getMailboxChange()).then(this.emailChangeRepository().save(mailboxAndEmailChange.getEmailChange()));
        } else {
            throw new MatchError((Object)jmapChange2);
        }
        return SMono$.MODULE$.apply((Publisher)mono).then(SMono$.MODULE$.apply((Publisher)this.eventBus().dispatch((Event)this.toStateChangeEvent(jmapChange), (RegistrationKey)new AccountIdRegistrationKey(jmapChange.getAccountId()))));
    }

    private SMono<List<AccountId>> getSharees(MailboxId mailboxId, Username username) {
        MailboxSession session = this.mailboxManager().createSystemSession(username);
        return SMono$.MODULE$.apply(this.mailboxManager().getMailboxReactive(mailboxId, session)).map((Function1 & Serializable)mailbox -> mailbox.getResolvedAcl(session)).map((Function1 & Serializable)mailboxACL -> ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(mailboxACL.getEntries().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$getSharees$3(x$2)))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$getSharees$4(x$3)))).map((Function1 & Serializable)x$4 -> x$4.getName())).map((Function1 & Serializable)identifier -> AccountId.fromString((String)identifier))).toList()).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof MailboxNotFoundException) {
                MailboxChangeListener$.MODULE$.LOGGER().warn("Could not get sharees for mailbox {} as the mailbox was deleted", (Object)mailboxId);
                return SMono$.MODULE$.just((Object)package$.MODULE$.List().empty());
            }
            MailboxChangeListener$.MODULE$.LOGGER().warn("Could not get sharees for mailbox {} when listening to change events", (Object)mailboxId, (Object)throwable);
            return SMono$.MODULE$.just((Object)package$.MODULE$.List().empty());
        });
    }

    private StateChangeEvent toStateChangeEvent(JmapChange jmapChange) {
        JmapChange jmapChange2 = jmapChange;
        if (jmapChange2 instanceof EmailChange) {
            EmailChange emailChange = (EmailChange)jmapChange2;
            return new StateChangeEvent(Event.EventId.random(), Username.of((String)emailChange.getAccountId().getIdentifier()), this.emailStateMap(emailChange));
        }
        if (jmapChange2 instanceof MailboxChange) {
            MailboxChange mailboxChange = (MailboxChange)jmapChange2;
            return new StateChangeEvent(Event.EventId.random(), Username.of((String)mailboxChange.getAccountId().getIdentifier()), this.mailboxStateMap(mailboxChange));
        }
        if (jmapChange2 instanceof MailboxAndEmailChange) {
            MailboxAndEmailChange mailboxAndEmailChange = (MailboxAndEmailChange)jmapChange2;
            return new StateChangeEvent(Event.EventId.random(), Username.of((String)mailboxAndEmailChange.getAccountId().getIdentifier()), (Map<TypeName, State>)((Map)this.emailStateMap(mailboxAndEmailChange.getEmailChange()).$plus$plus(this.mailboxStateMap(mailboxAndEmailChange.getMailboxChange()))));
        }
        throw new MatchError((Object)jmapChange2);
    }

    private Map<TypeName, State> mailboxStateMap(MailboxChange mailboxChange) {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MailboxTypeName$.MODULE$), (Object)UuidState$.MODULE$.fromJava(mailboxChange.getState()))}));
    }

    private Map<TypeName, State> emailStateMap(EmailChange emailChange) {
        return ((IterableOnceOps)((IterableOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EmailTypeName$.MODULE$), (Object)UuidState$.MODULE$.fromJava(emailChange.getState()))}))).$plus$plus((IterableOnce)new Some((Object)UuidState$.MODULE$.fromJava(emailChange.getState())).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MailboxChangeListener.$anonfun$emailStateMap$1(emailChange, x$5))).map((Function1 & Serializable)emailDeliveryState -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EmailDeliveryTypeName$.MODULE$), emailDeliveryState)}))).getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public MailboxChangeListener copy(EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, MailboxAndEmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        return new MailboxChangeListener(eventBus, mailboxChangeRepository, mailboxChangeFactory, emailChangeRepository, emailChangeFactory, mailboxManager, clock);
    }

    public EventBus copy$default$1() {
        return this.eventBus();
    }

    public MailboxChangeRepository copy$default$2() {
        return this.mailboxChangeRepository();
    }

    public MailboxChange.Factory copy$default$3() {
        return this.mailboxChangeFactory();
    }

    public EmailChangeRepository copy$default$4() {
        return this.emailChangeRepository();
    }

    public MailboxAndEmailChange.Factory copy$default$5() {
        return this.emailChangeFactory();
    }

    public MailboxManager copy$default$6() {
        return this.mailboxManager();
    }

    public Clock copy$default$7() {
        return this.clock();
    }

    public String productPrefix() {
        return "MailboxChangeListener";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.eventBus();
            }
            case 1: {
                return this.mailboxChangeRepository();
            }
            case 2: {
                return this.mailboxChangeFactory();
            }
            case 3: {
                return this.emailChangeRepository();
            }
            case 4: {
                return this.emailChangeFactory();
            }
            case 5: {
                return this.mailboxManager();
            }
            case 6: {
                return this.clock();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MailboxChangeListener;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "eventBus";
            }
            case 1: {
                return "mailboxChangeRepository";
            }
            case 2: {
                return "mailboxChangeFactory";
            }
            case 3: {
                return "emailChangeRepository";
            }
            case 4: {
                return "emailChangeFactory";
            }
            case 5: {
                return "mailboxManager";
            }
            case 6: {
                return "clock";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MailboxChangeListener)) return false;
        boolean bl = true;
        if (!bl) return false;
        MailboxChangeListener mailboxChangeListener = (MailboxChangeListener)x$1;
        EventBus eventBus = this.eventBus();
        EventBus eventBus2 = mailboxChangeListener.eventBus();
        if (eventBus == null) {
            if (eventBus2 != null) {
                return false;
            }
        } else if (!eventBus.equals(eventBus2)) return false;
        MailboxChangeRepository mailboxChangeRepository = this.mailboxChangeRepository();
        MailboxChangeRepository mailboxChangeRepository2 = mailboxChangeListener.mailboxChangeRepository();
        if (mailboxChangeRepository == null) {
            if (mailboxChangeRepository2 != null) {
                return false;
            }
        } else if (!mailboxChangeRepository.equals(mailboxChangeRepository2)) return false;
        MailboxChange.Factory factory = this.mailboxChangeFactory();
        MailboxChange.Factory factory2 = mailboxChangeListener.mailboxChangeFactory();
        if (factory == null) {
            if (factory2 != null) {
                return false;
            }
        } else if (!factory.equals(factory2)) return false;
        EmailChangeRepository emailChangeRepository = this.emailChangeRepository();
        EmailChangeRepository emailChangeRepository2 = mailboxChangeListener.emailChangeRepository();
        if (emailChangeRepository == null) {
            if (emailChangeRepository2 != null) {
                return false;
            }
        } else if (!emailChangeRepository.equals(emailChangeRepository2)) return false;
        MailboxAndEmailChange.Factory factory3 = this.emailChangeFactory();
        MailboxAndEmailChange.Factory factory4 = mailboxChangeListener.emailChangeFactory();
        if (factory3 == null) {
            if (factory4 != null) {
                return false;
            }
        } else if (!factory3.equals(factory4)) return false;
        MailboxManager mailboxManager = this.mailboxManager();
        MailboxManager mailboxManager2 = mailboxChangeListener.mailboxManager();
        if (mailboxManager == null) {
            if (mailboxManager2 != null) {
                return false;
            }
        } else if (!mailboxManager.equals(mailboxManager2)) return false;
        Clock clock = this.clock();
        Clock clock2 = mailboxChangeListener.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!((Object)clock).equals(clock2)) return false;
        if (!mailboxChangeListener.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getSharees$3(MailboxACL.EntryKey x$2) {
        return !x$2.isNegative();
    }

    public static final /* synthetic */ boolean $anonfun$getSharees$4(MailboxACL.EntryKey x$3) {
        MailboxACL.NameType nameType = x$3.getNameType();
        MailboxACL.NameType nameType2 = MailboxACL.NameType.user;
        return !(nameType != null ? !nameType.equals(nameType2) : nameType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$emailStateMap$1(EmailChange emailChange$1, UuidState x$5) {
        return emailChange$1.isDelivery() && !emailChange$1.getCreated().isEmpty();
    }

    @Inject
    public MailboxChangeListener(@Named(value="JMAP") EventBus eventBus, MailboxChangeRepository mailboxChangeRepository, MailboxChange.Factory mailboxChangeFactory, EmailChangeRepository emailChangeRepository, MailboxAndEmailChange.Factory emailChangeFactory, MailboxManager mailboxManager, Clock clock) {
        this.eventBus = eventBus;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.mailboxChangeFactory = mailboxChangeFactory;
        this.emailChangeRepository = emailChangeRepository;
        this.emailChangeFactory = emailChangeFactory;
        this.mailboxManager = mailboxManager;
        this.clock = clock;
        Product.$init$((Product)this);
    }
}

