/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.domainlist.api.DomainListManagementMBean;
import org.apache.james.rrt.api.RecipientRewriteTableManagementMBean;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.UsersRepositoryManagementMBean;
import org.apache.james.util.MDCBuilder;

public class JmxDataProbe
implements JmxProbe {
    private static final String DOMAINLIST_OBJECT_NAME = "org.apache.james:type=component,name=domainlist";
    private static final String VIRTUALUSERTABLE_OBJECT_NAME = "org.apache.james:type=component,name=recipientrewritetable";
    private static final String USERSREPOSITORY_OBJECT_NAME = "org.apache.james:type=component,name=usersrepository";
    private static final String JMX = "JMX";
    private static final String PARAMETER = "parameter";
    private DomainListManagementMBean domainListProxy;
    private RecipientRewriteTableManagementMBean virtualUserTableProxy;
    private UsersRepositoryManagementMBean usersRepositoryProxy;

    @Override
    public JmxDataProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.domainListProxy = jmxc.retrieveBean(DomainListManagementMBean.class, DOMAINLIST_OBJECT_NAME);
            this.virtualUserTableProxy = jmxc.retrieveBean(RecipientRewriteTableManagementMBean.class, VIRTUALUSERTABLE_OBJECT_NAME);
            this.usersRepositoryProxy = jmxc.retrieveBean(UsersRepositoryManagementMBean.class, USERSREPOSITORY_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public void addUser(String userName, String password) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "addUser").addToContext(PARAMETER, userName).build();){
            this.usersRepositoryProxy.addUser(userName, password);
        }
    }

    public void removeUser(String username) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "removeUser").addToContext(PARAMETER, username).build();){
            this.usersRepositoryProxy.deleteUser(username);
        }
    }

    public String[] listUsers() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "listUsers").build();){
            String[] stringArray = this.usersRepositoryProxy.listAllUsers();
            return stringArray;
        }
    }

    public void setPassword(String userName, String password) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "setPassword").addToContext(PARAMETER, userName).build();){
            this.usersRepositoryProxy.setPassword(userName, password);
        }
    }

    public boolean containsDomain(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "containsDomain").addToContext(PARAMETER, domain).build();){
            boolean bl = this.domainListProxy.containsDomain(domain);
            return bl;
        }
    }

    public void addDomain(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "addDomain").addToContext(PARAMETER, domain).build();){
            this.domainListProxy.addDomain(domain);
        }
    }

    public void removeDomain(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "removeDomain").addToContext(PARAMETER, domain).build();){
            this.domainListProxy.removeDomain(domain);
        }
    }

    public List<String> listDomains() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "listDomains").build();){
            List list = this.domainListProxy.getDomains();
            return list;
        }
    }

    public void addDomainMapping(String domain, String targetDomain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "addDomainMapping").build();){
            this.virtualUserTableProxy.addDomainMapping(domain, targetDomain);
        }
    }

    public void removeDomainMapping(String domain, String targetDomain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "removeDomainMapping").build();){
            this.virtualUserTableProxy.removeDomainMapping(domain, targetDomain);
        }
    }

    public Mappings listDomainMappings(String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "listDomainMappings").build();){
            Mappings mappings = this.virtualUserTableProxy.getDomainMappings(domain);
            return mappings;
        }
    }

    public Map<String, Mappings> listMappings() throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "listMappings").build();){
            Map map = this.virtualUserTableProxy.getAllMappings();
            return map;
        }
    }

    public void addAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "addAddressMapping").build();){
            this.virtualUserTableProxy.addAddressMapping(fromUser, fromDomain, toAddress);
        }
    }

    public void removeAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "removeAddressMapping").build();){
            this.virtualUserTableProxy.removeAddressMapping(fromUser, fromDomain, toAddress);
        }
    }

    public Mappings listUserDomainMappings(String user, String domain) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "listUserDomainMappings").build();){
            Mappings mappings = this.virtualUserTableProxy.getUserDomainMappings(user, domain);
            return mappings;
        }
    }

    public void addRegexMapping(String user, String domain, String regex) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "addRegexMapping").build();){
            this.virtualUserTableProxy.addRegexMapping(user, domain, regex);
        }
    }

    public void removeRegexMapping(String user, String domain, String regex) throws Exception {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", JMX).addToContext("action", "removeRegexMapping").build();){
            this.virtualUserTableProxy.removeRegexMapping(user, domain, regex);
        }
    }
}

