/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.io.CountingInputStream;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.cassandra.upload.UploadDAO;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraUploadRepository
implements UploadRepository {
    public static final BucketName UPLOAD_BUCKET = BucketName.of((String)"jmap-uploads");
    public static final Duration EXPIRE_DURATION = Duration.ofDays(7L);
    private final UploadDAO uploadDAO;
    private final BlobStore blobStore;
    private final Clock clock;

    @Inject
    public CassandraUploadRepository(UploadDAO uploadDAO, BlobStore blobStore, Clock clock) {
        this.uploadDAO = uploadDAO;
        this.blobStore = blobStore;
        this.clock = clock;
    }

    public Mono<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        UploadId uploadId = this.generateId();
        return Mono.fromCallable(() -> new CountingInputStream(data)).flatMap(countingInputStream -> Mono.from((Publisher)this.blobStore.save(UPLOAD_BUCKET, (InputStream)countingInputStream, BlobStore.StoragePolicy.LOW_COST)).map(blobId -> new UploadDAO.UploadRepresentation(uploadId, (BlobId)blobId, contentType, countingInputStream.getCount(), user, this.clock.instant().truncatedTo(ChronoUnit.MILLIS))).flatMap(upload -> this.uploadDAO.save((UploadDAO.UploadRepresentation)upload).thenReturn((Object)upload.toUploadMetaData())));
    }

    public Mono<Upload> retrieve(UploadId id, Username user) {
        return this.uploadDAO.retrieve(user, id).flatMap(upload -> Mono.from((Publisher)this.blobStore.readReactive(UPLOAD_BUCKET, upload.getBlobId(), BlobStore.StoragePolicy.LOW_COST)).map(inputStream -> Upload.from((UploadMetaData)upload.toUploadMetaData(), () -> inputStream))).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    public Mono<Boolean> delete(UploadId id, Username user) {
        return this.uploadDAO.delete(user, id);
    }

    public Flux<UploadMetaData> listUploads(Username user) {
        return this.uploadDAO.list(user).map(UploadDAO.UploadRepresentation::toUploadMetaData);
    }

    public Mono<Void> purge() {
        Instant sevenDaysAgo = this.clock.instant().minus(EXPIRE_DURATION);
        return Flux.from(this.uploadDAO.all()).filter(upload -> upload.getUploadDate().isBefore(sevenDaysAgo)).flatMap(upload -> Mono.from((Publisher)this.blobStore.delete(UPLOAD_BUCKET, upload.getBlobId())).then(this.uploadDAO.delete(upload.getUser(), upload.getId())), 16).then();
    }

    private UploadId generateId() {
        return UploadId.from((UUID)Uuids.timeBased());
    }
}

