/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.change;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.CassandraZonedDateTimeModule;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.cassandra.change.CassandraChangesConfiguration;
import org.apache.james.jmap.cassandra.change.tables.CassandraEmailChangeTable;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EmailChangeRepositoryDAO {
    private static final TypeCodec<Set<UUID>> SET_OF_UUIDS_CODEC = CodecRegistry.DEFAULT.codecFor((DataType)DataTypes.frozenSetOf((DataType)DataTypes.UUID), GenericType.setOf(UUID.class));
    private static final CqlIdentifier TTL_FOR_ROW = CqlIdentifier.fromCql((String)"ttl");
    private final CassandraAsyncExecutor executor;
    private final UserDefinedType zonedDateTimeUserType;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;
    private final PreparedStatement selectFromStatement;
    private final PreparedStatement selectLatestStatement;
    private final PreparedStatement selectLatestNotDelegatedStatement;
    private final int timeToLive;

    @Inject
    public EmailChangeRepositoryDAO(CqlSession session, CassandraTypesProvider cassandraTypesProvider, CassandraChangesConfiguration cassandraChangesConfiguration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.zonedDateTimeUserType = cassandraTypesProvider.getDefinedUserType("zonedDateTime");
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"email_change").value(CassandraEmailChangeTable.ACCOUNT_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.ACCOUNT_ID)).value(CassandraEmailChangeTable.STATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.STATE)).value(CassandraEmailChangeTable.DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.DATE)).value(CassandraEmailChangeTable.IS_DELEGATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.IS_DELEGATED)).value(CassandraEmailChangeTable.CREATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.CREATED)).value(CassandraEmailChangeTable.UPDATED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.UPDATED)).value(CassandraEmailChangeTable.DESTROYED, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.DESTROYED)).usingTtl(QueryBuilder.bindMarker((CqlIdentifier)TTL_FOR_ROW)).build());
        this.selectAllStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"email_change").all().whereColumn(CassandraEmailChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.ACCOUNT_ID))).orderBy(CassandraEmailChangeTable.STATE, ClusteringOrder.ASC).build());
        this.selectFromStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"email_change").all().whereColumn(CassandraEmailChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.ACCOUNT_ID))).whereColumn(CassandraEmailChangeTable.STATE).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.STATE))).orderBy(CassandraEmailChangeTable.STATE, ClusteringOrder.ASC).build());
        this.selectLatestStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"email_change").column(CassandraEmailChangeTable.STATE).whereColumn(CassandraEmailChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.ACCOUNT_ID))).orderBy(CassandraEmailChangeTable.STATE, ClusteringOrder.DESC).limit(1).build());
        this.selectLatestNotDelegatedStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"email_change").column(CassandraEmailChangeTable.STATE).whereColumn(CassandraEmailChangeTable.ACCOUNT_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEmailChangeTable.ACCOUNT_ID))).whereColumn(CassandraEmailChangeTable.IS_DELEGATED).isEqualTo((Term)QueryBuilder.literal((Object)false))).orderBy(CassandraEmailChangeTable.STATE, ClusteringOrder.DESC).limit(1).allowFiltering().build());
        this.timeToLive = Math.toIntExact(cassandraChangesConfiguration.getEmailChangeTtl().getSeconds());
    }

    Mono<Void> insert(EmailChange change) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(CassandraEmailChangeTable.ACCOUNT_ID, change.getAccountId().getIdentifier())).setUuid(CassandraEmailChangeTable.STATE, change.getState().getValue())).setBoolean(CassandraEmailChangeTable.IS_DELEGATED, change.isShared())).set(CassandraEmailChangeTable.CREATED, this.toUuidSet(change.getCreated()), SET_OF_UUIDS_CODEC)).set(CassandraEmailChangeTable.UPDATED, this.toUuidSet(change.getUpdated()), SET_OF_UUIDS_CODEC)).set(CassandraEmailChangeTable.DESTROYED, this.toUuidSet(change.getDestroyed()), SET_OF_UUIDS_CODEC)).setUdtValue(CassandraEmailChangeTable.DATE, CassandraZonedDateTimeModule.toUDT((UserDefinedType)this.zonedDateTimeUserType, (ZonedDateTime)change.getDate()))).setInt(TTL_FOR_ROW, this.timeToLive));
    }

    private ImmutableSet<UUID> toUuidSet(List<MessageId> idSet) {
        return (ImmutableSet)idSet.stream().filter(CassandraMessageId.class::isInstance).map(CassandraMessageId.class::cast).map(CassandraMessageId::get).collect(ImmutableSet.toImmutableSet());
    }

    Flux<EmailChange> getAllChanges(AccountId accountId) {
        return this.executor.executeRows((Statement)this.selectAllStatement.bind(new Object[0]).set(CassandraEmailChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).map(row -> this.readRow((Row)row, accountId));
    }

    Flux<EmailChange> getChangesSince(AccountId accountId, State state) {
        return this.executor.executeRows((Statement)((BoundStatement)this.selectFromStatement.bind(new Object[0]).set(CassandraEmailChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).setUuid(CassandraEmailChangeTable.STATE, state.getValue())).map(row -> this.readRow((Row)row, accountId));
    }

    Mono<State> latestState(AccountId accountId) {
        return this.executor.executeSingleRow((Statement)this.selectLatestStatement.bind(new Object[0]).set(CassandraEmailChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).map(row -> State.of((UUID)row.getUuid(0)));
    }

    Mono<State> latestStateNotDelegated(AccountId accountId) {
        return this.executor.executeSingleRow((Statement)this.selectLatestNotDelegatedStatement.bind(new Object[0]).set(CassandraEmailChangeTable.ACCOUNT_ID, (Object)accountId.getIdentifier(), TypeCodecs.TEXT)).map(row -> State.of((UUID)row.getUuid(0)));
    }

    private EmailChange readRow(Row row, AccountId accountId) {
        return EmailChange.builder().accountId(accountId).state(State.of((UUID)row.getUuid(CassandraEmailChangeTable.STATE))).date(CassandraZonedDateTimeModule.fromUDT((UdtValue)row.getUdtValue(CassandraEmailChangeTable.DATE))).isShared(row.getBoolean(CassandraEmailChangeTable.IS_DELEGATED)).created(this.toIdSet((Set)row.get(CassandraEmailChangeTable.CREATED, SET_OF_UUIDS_CODEC))).updated(this.toIdSet((Set)row.get(CassandraEmailChangeTable.UPDATED, SET_OF_UUIDS_CODEC))).destroyed(this.toIdSet((Set)row.get(CassandraEmailChangeTable.DESTROYED, SET_OF_UUIDS_CODEC))).build();
    }

    private ImmutableList<MessageId> toIdSet(Set<UUID> uuidSet) {
        return (ImmutableList)uuidSet.stream().map(CassandraMessageId.Factory::of).collect(ImmutableList.toImmutableList());
    }
}

