/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.metrics.api.GaugeRegistry;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ReactiveThrottler {
    private final int maxConcurrentRequests;
    private final int maxQueueSize;
    private final AtomicInteger concurrentRequests = new AtomicInteger(0);
    private final Queue<TaskHolder> queue = new ConcurrentLinkedQueue<TaskHolder>();

    public ReactiveThrottler(GaugeRegistry gaugeRegistry, int maxConcurrentRequests, int maxQueueSize) {
        gaugeRegistry.register("imap.request.queue.size", () -> Math.max(this.concurrentRequests.get() - maxConcurrentRequests, 0));
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.maxQueueSize = maxQueueSize;
    }

    public Mono<Void> throttle(Publisher<Void> task, ImapMessage imapMessage) {
        if (this.maxConcurrentRequests < 0) {
            return Mono.from(task);
        }
        int requestNumber = this.concurrentRequests.incrementAndGet();
        if (requestNumber <= this.maxConcurrentRequests) {
            return Mono.from(task).doFinally(any -> this.onRequestDone());
        }
        if (requestNumber <= this.maxQueueSize + this.maxConcurrentRequests) {
            AtomicBoolean cancelled = new AtomicBoolean(false);
            Sinks.One one = Sinks.one();
            TaskHolder taskHolder = new TaskHolder((Publisher<Void>)Mono.fromCallable(cancelled::get).flatMap(cancel -> {
                if (cancel.booleanValue()) {
                    return Mono.empty();
                }
                return Mono.from((Publisher)task);
            }).then(Mono.fromRunnable(() -> one.emitEmpty(Sinks.EmitFailureHandler.FAIL_FAST))));
            this.queue.add(taskHolder);
            return one.asMono().doOnCancel(() -> {
                cancelled.set(true);
                Optional.ofNullable(taskHolder.disposable.get()).ifPresent(Disposable::dispose);
                boolean removed = this.queue.remove(taskHolder);
                if (removed) {
                    this.concurrentRequests.decrementAndGet();
                }
            });
        }
        this.concurrentRequests.decrementAndGet();
        return Mono.error((Throwable)new RejectedException(String.format("The IMAP server has reached its maximum capacity (concurrent requests: %d, queue size: %d)", this.maxConcurrentRequests, this.maxQueueSize), imapMessage));
    }

    private void onRequestDone() {
        this.concurrentRequests.getAndDecrement();
        TaskHolder throttled = this.queue.poll();
        if (throttled != null) {
            Disposable disposable = Mono.from(throttled.task).doFinally(any -> this.onRequestDone()).subscribe();
            throttled.disposable.set(disposable);
        }
    }

    private static class TaskHolder {
        private final Publisher<Void> task;
        private final AtomicReference<Disposable> disposable = new AtomicReference();

        private TaskHolder(Publisher<Void> task) {
            this.task = task;
        }
    }

    public static class RejectedException
    extends RuntimeException {
        private final ImapMessage imapMessage;

        public RejectedException(String message, ImapMessage imapMessage) {
            super(message);
            this.imapMessage = imapMessage;
        }

        public ImapMessage getImapMessage() {
            return this.imapMessage;
        }
    }
}

