/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.SystemPropertyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.protocols.lib.LegacyJavaEncryptionFactory;
import org.apache.james.protocols.lib.SslConfig;
import org.apache.james.protocols.lib.jmx.ServerMBean;
import org.apache.james.protocols.lib.netty.CertificateReloadable;
import org.apache.james.protocols.netty.AbstractAsyncServer;
import org.apache.james.protocols.netty.AbstractChannelPipelineFactory;
import org.apache.james.protocols.netty.AbstractSSLAwareChannelPipelineFactory;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.util.Size;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurableAsyncServer
extends AbstractAsyncServer
implements CertificateReloadable,
Configurable,
ServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurableAsyncServer.class);
    public static final int DEFAULT_BACKLOG = 200;
    public static final int DEFAULT_TIMEOUT = 300;
    private static final String TIMEOUT_NAME = "connectiontimeout";
    private static final String BACKLOG_NAME = "connectionBacklog";
    public static final String HELLO_NAME = "helloName";
    public static final String PROXY_REQUIRED = "proxyRequired";
    public static final int DEFAULT_MAX_EXECUTOR_COUNT = 16;
    private FileSystem fileSystem;
    private boolean enabled;
    protected boolean proxyRequired;
    protected int connPerIP;
    protected int connectionLimit;
    private String helloName;
    private SslConfig sslConfig;
    protected Encryption encryption;
    private ChannelHandlerFactory frameHandlerFactory;
    private EventExecutorGroup executorGroup;
    private MBeanServer mbeanServer;
    private int port;

    @Inject
    public final void setFileSystem(FileSystem filesystem) {
        this.fileSystem = filesystem;
    }

    protected void registerMBean() {
        try {
            this.mbeanServer.registerMBean(this, new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register mbean", e);
        }
    }

    protected void unregisterMBean() {
        try {
            this.mbeanServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unregister mbean", e);
        }
    }

    private String getMBeanName() {
        return "org.apache.james:type=server,name=" + this.jmxName;
    }

    public final void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        String connectionLimitPerIP;
        this.enabled = config.getBoolean("[@enabled]", true);
        if (!this.enabled) {
            LOGGER.info("{} disabled by configuration", (Object)this.getServiceType());
            return;
        }
        String[] listen = StringUtils.split((String)config.getString("bind", "0.0.0.0:" + this.getDefaultPort()), (char)',');
        ArrayList<InetSocketAddress> bindAddresses = new ArrayList<InetSocketAddress>();
        for (String aListen : listen) {
            String[] bind = StringUtils.split((String)aListen, (char)':');
            String ip = bind[0].trim();
            int port = Integer.parseInt(bind[1].trim());
            if (!ip.equals("0.0.0.0")) {
                try {
                    ip = InetAddress.getByName(ip).getHostName();
                }
                catch (UnknownHostException unhe) {
                    throw new ConfigurationException("Malformed bind parameter in configuration of service " + this.getServiceType(), (Throwable)unhe);
                }
            }
            InetSocketAddress address = new InetSocketAddress(ip, port);
            LOGGER.info("{} bound to: {}:{}", new Object[]{this.getServiceType(), ip, port});
            bindAddresses.add(address);
        }
        this.setListenAddresses((InetSocketAddress[])bindAddresses.toArray(InetSocketAddress[]::new));
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
        int ioWorker = config.getInt("ioWorkerCount", DEFAULT_IO_WORKER_COUNT);
        this.setIoWorkerCount(ioWorker);
        Integer bossWorker = config.getInteger("bossWorkerCount", null);
        this.setBossWorkerCount(Optional.ofNullable(bossWorker));
        RejectedExecutionHandler rejectedExecutionHandler = (task, executor) -> {
            if (!executor.isShuttingDown()) {
                throw new RejectedExecutionException();
            }
        };
        this.executorGroup = new DefaultEventExecutorGroup(config.getInt("maxExecutorCount", 16), (ThreadFactory)NamedThreadFactory.withName((String)this.jmxName), Math.max(16, SystemPropertyUtil.getInt((String)"io.netty.eventexecutor.maxPendingTasks", (int)Integer.MAX_VALUE)), rejectedExecutionHandler);
        this.configureHelloName((Configuration)config);
        this.setTimeout(config.getInt(TIMEOUT_NAME, 300));
        LOGGER.info("{} handler connection timeout is: {}", (Object)this.getServiceType(), (Object)this.getTimeout());
        this.setBacklog(config.getInt(BACKLOG_NAME, 200));
        LOGGER.info("{} connection backlog is: {}", (Object)this.getServiceType(), (Object)this.getBacklog());
        String connectionLimitString = config.getString("connectionLimit", null);
        if (connectionLimitString != null) {
            try {
                this.connectionLimit = Integer.parseInt(connectionLimitString);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Connection limit value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connectionLimit < 0) {
                LOGGER.error("Connection limit value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connectionLimit > 0) {
                LOGGER.info("{} will allow a maximum of {} connections.", (Object)this.getServiceType(), (Object)connectionLimitString);
            }
        }
        if ((connectionLimitPerIP = config.getString("connectionLimitPerIP", null)) != null) {
            try {
                this.connPerIP = Integer.parseInt(connectionLimitPerIP);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Connection limit per IP value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connPerIP < 0) {
                LOGGER.error("Connection limit per IP value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connPerIP > 0) {
                LOGGER.info("{} will allow a maximum of {} per IP connections for {}", new Object[]{this.getServiceType(), this.connPerIP, this.getServiceType()});
            }
        }
        this.sslConfig = SslConfig.parse(config);
        Optional.ofNullable(config.getBoolean("gracefulShutdown", null)).ifPresent(arg_0 -> ((AbstractConfigurableAsyncServer)this).setGracefulShutdown(arg_0));
        Optional.ofNullable(config.getBoolean("useEpoll", null)).ifPresent(arg_0 -> ((AbstractConfigurableAsyncServer)this).setUseEpoll(arg_0));
        Optional<Size> highWaterMark = Optional.ofNullable(config.getString("highWriteBufferWaterMark", null)).map(Size::parse);
        Optional<Size> lowWaterMark = Optional.ofNullable(config.getString("lowWriteBufferWaterMark", null)).map(Size::parse);
        if (highWaterMark.isPresent() || lowWaterMark.isPresent()) {
            this.setWriteBufferWaterMark(new WriteBufferWaterMark((int)lowWaterMark.or(() -> highWaterMark).get().asBytes(), (int)highWaterMark.or(() -> lowWaterMark).get().asBytes()));
        }
        Optional.ofNullable(config.getBoolean("useEpoll", null)).ifPresent(arg_0 -> ((AbstractConfigurableAsyncServer)this).setUseEpoll(arg_0));
        this.proxyRequired = config.getBoolean(PROXY_REQUIRED, false);
        this.doConfigure(config);
    }

    protected EventExecutorGroup getExecutorGroup() {
        return this.executorGroup;
    }

    @PostConstruct
    public final void init() throws Exception {
        if (this.isEnabled()) {
            this.buildSSLContext();
            this.preInit();
            this.frameHandlerFactory = this.createFrameHandlerFactory();
            this.bind();
            this.port = this.retrieveFirstBindedPort();
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerMBean();
            LOGGER.info("Init {} done", (Object)this.getServiceType());
        }
    }

    private int retrieveFirstBindedPort() {
        List listenAddresses = this.getListenAddresses();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)listenAddresses.get(0);
        return inetSocketAddress.getPort();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @PreDestroy
    public final void destroy() {
        LOGGER.info("Dispose {}", (Object)this.getServiceType());
        if (this.isEnabled()) {
            this.executorGroup.shutdownGracefully();
            this.unbind();
            this.postDestroy();
            this.unregisterMBean();
        }
        LOGGER.info("Dispose {} done", (Object)this.getServiceType());
    }

    protected void postDestroy() {
    }

    protected void preInit() throws Exception {
    }

    protected void doConfigure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
    }

    protected void configureHelloName(Configuration handlerConfiguration) throws ConfigurationException {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ue) {
            hostName = "localhost";
        }
        LOGGER.info("{} is running on: {}", (Object)this.getServiceType(), (Object)hostName);
        boolean autodetect = handlerConfiguration.getBoolean("helloName.[@autodetect]", true);
        if (autodetect) {
            this.helloName = hostName;
        } else {
            this.helloName = handlerConfiguration.getString(HELLO_NAME);
            if (this.helloName == null || this.helloName.trim().length() < 1) {
                throw new ConfigurationException("Please configure the helloName or use autodetect");
            }
        }
        LOGGER.info("{} handler hello name is: {}", (Object)this.getServiceType(), (Object)this.helloName);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHelloName() {
        return this.helloName;
    }

    protected Encryption getEncryption() {
        return this.encryption;
    }

    protected void buildSSLContext() throws Exception {
        if (this.sslConfig.useSSL() || this.sslConfig.useStartTLS()) {
            this.encryption = new LegacyJavaEncryptionFactory(this.fileSystem, this.sslConfig).create();
        }
    }

    @Override
    public void reloadSSLCertificate() throws Exception {
        this.buildSSLContext();
    }

    protected abstract int getDefaultPort();

    @Override
    public String getSocketType() {
        if (this.getEncryption() != null && !this.getEncryption().isStartTLS()) {
            return "secure";
        }
        return "plain";
    }

    @Override
    public boolean getStartTLSSupported() {
        return this.getEncryption() != null && this.getEncryption().isStartTLS();
    }

    @Override
    public int getMaximumConcurrentConnections() {
        return this.connectionLimit;
    }

    protected abstract String getDefaultJMXName();

    @Override
    public boolean isStarted() {
        return this.isBound();
    }

    @Override
    public boolean start() {
        try {
            this.bind();
        }
        catch (Exception e) {
            LOGGER.error("Unable to start server", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        this.unbind();
        return true;
    }

    @Override
    public String[] getBoundAddresses() {
        List addresses = this.getListenAddresses();
        String[] addrs = new String[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            InetSocketAddress address = (InetSocketAddress)addresses.get(i);
            addrs[i] = address.getHostName() + ":" + address.getPort();
        }
        return addrs;
    }

    protected void configureBootstrap(ServerBootstrap bootstrap) {
        super.configureBootstrap(bootstrap);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
    }

    protected abstract ChannelHandlerFactory createFrameHandlerFactory();

    protected ChannelHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    protected abstract ChannelInboundHandlerAdapter createCoreHandler();

    protected AbstractChannelPipelineFactory createPipelineFactory() {
        return new AbstractSSLAwareChannelPipelineFactory<SocketChannel>(this.getTimeout(), this.connectionLimit, this.connPerIP, this.proxyRequired, this::getEncryption, this.getFrameHandlerFactory(), this.getExecutorGroup()){

            protected ChannelInboundHandlerAdapter createHandler() {
                return AbstractConfigurableAsyncServer.this.createCoreHandler();
            }
        };
    }
}

