/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.configuration2.Configuration;

public class LinshareConfiguration {
    public static final String URL_PROPERTY = "blob.export.linshare.url";
    public static final String UUID_PROPERTY = "blob.export.linshare.technical.account.uuid";
    public static final String PASSWORD_PROPERTY = "blob.export.linshare.technical.account.password";
    private final URL url;
    private final UUID uuid;
    private final String password;

    public static Builder.RequireUrl builder() {
        return url -> (uuid, password) -> new Builder.ReadyToBuild(url, UUID.fromString(uuid), password);
    }

    public static LinshareConfiguration from(Configuration configuration) throws MalformedURLException {
        return LinshareConfiguration.builder().urlAsString(configuration.getString(URL_PROPERTY, null)).basicAuthorization(configuration.getString(UUID_PROPERTY), configuration.getString(PASSWORD_PROPERTY)).build();
    }

    @VisibleForTesting
    LinshareConfiguration(URL url, UUID uuid, String password) {
        Preconditions.checkNotNull((Object)url, (String)"'%s' can not be null", (Object)URL_PROPERTY);
        Preconditions.checkNotNull((Object)uuid, (String)"'%s' can not be null", (Object)UUID_PROPERTY);
        Preconditions.checkNotNull((Object)password, (String)"'%s' can not be null", (Object)PASSWORD_PROPERTY);
        Preconditions.checkArgument((!password.isEmpty() ? 1 : 0) != 0, (String)"'%s' can not be empty", (Object)PASSWORD_PROPERTY);
        this.url = url;
        this.uuid = uuid;
        this.password = password;
    }

    public URL getUrl() {
        return this.url;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getPassword() {
        return this.password;
    }

    public final boolean equals(Object o) {
        if (o instanceof LinshareConfiguration) {
            LinshareConfiguration that = (LinshareConfiguration)o;
            return Objects.equals(this.url, that.url) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.password, that.password);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.url, this.uuid, this.password);
    }

    public static class Builder {

        public static class ReadyToBuild {
            private final URL url;
            private final UUID uuid;
            private final String password;

            ReadyToBuild(URL url, UUID uuid, String password) {
                this.url = url;
                this.uuid = uuid;
                this.password = password;
            }

            public LinshareConfiguration build() {
                return new LinshareConfiguration(this.url, this.uuid, this.password);
            }
        }

        public static interface RequireBasicAuthorization {
            public ReadyToBuild basicAuthorization(String var1, String var2);
        }

        @FunctionalInterface
        public static interface RequireUrl {
            public RequireBasicAuthorization url(URL var1);

            default public RequireBasicAuthorization urlAsString(String url) throws MalformedURLException {
                if (url == null) {
                    throw new MalformedURLException("url can not be null");
                }
                return this.url((URL)Throwing.supplier(() -> new URI(url).toURL()).get());
            }
        }
    }
}

