/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare;

import com.google.common.io.Files;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.export.api.BlobExportMechanism;
import org.apache.james.blob.export.api.ExportedFileNamesGenerator;
import org.apache.james.blob.export.api.FileExtension;
import org.apache.james.core.MailAddress;
import org.apache.james.linshare.client.LinshareAPI;
import org.apache.james.linshare.client.User;

public class LinshareBlobExportMechanism
implements BlobExportMechanism {
    private final LinshareAPI linshareAPI;
    private final BlobStore blobStore;
    private final File tempDir;

    @Inject
    LinshareBlobExportMechanism(LinshareAPI linshareAPI, BlobStore blobStore) {
        this.linshareAPI = linshareAPI;
        this.blobStore = blobStore;
        this.tempDir = Files.createTempDir();
    }

    public BlobExportMechanism.ShareeStage blobId(BlobId blobId) {
        return mailAddress -> explanation -> fileCustomPrefix -> fileExtension -> () -> {
            try {
                this.exportBlob(blobId, mailAddress, fileCustomPrefix, fileExtension);
            }
            catch (Exception e) {
                throw new BlobExportMechanism.BlobExportException(String.format("Error while exporting blob %s to %s", blobId.asString(), mailAddress.asString()), (Throwable)e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportBlob(BlobId blobId, MailAddress mailAddress, Optional<String> fileCustomPrefix, Optional<FileExtension> fileExtension) throws IOException {
        String fileName = ExportedFileNamesGenerator.generateFileName(fileCustomPrefix, (BlobId)blobId, fileExtension);
        File tempFile = new File(this.tempDir, fileName);
        try (InputStream in = this.blobStore.read(this.blobStore.getDefaultBucketName(), blobId, BlobStore.StoragePolicy.LOW_COST);){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            this.uploadDocumentToTargetMail(mailAddress, tempFile);
        }
        finally {
            FileUtils.forceDelete((File)tempFile);
        }
    }

    private void uploadDocumentToTargetMail(MailAddress mailAddress, File tempFile) {
        User targetUser = this.linshareAPI.getUserByMail(mailAddress.asString());
        this.linshareAPI.uploadDocumentByDelegation(targetUser, tempFile);
    }
}

