/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.UnsupportedRightException;

public class MailboxACL {
    public static final char ADD_RIGHTS_MARKER = '+';
    public static final char DEFAULT_GROUP_MARKER = '$';
    public static final char DEFAULT_NEGATIVE_MARKER = '-';
    public static final char REMOVE_RIGHTS_MARKER = '-';
    public static final EntryKey ANYBODY_KEY;
    public static final EntryKey ANYBODY_NEGATIVE_KEY;
    public static final EntryKey AUTHENTICATED_KEY;
    public static final EntryKey AUTHENTICATED_NEGATIVE_KEY;
    public static final MailboxACL EMPTY;
    public static final Rfc4314Rights FULL_RIGHTS;
    public static final Rfc4314Rights NO_RIGHTS;
    public static final MailboxACL OWNER_FULL_ACL;
    public static final MailboxACL OWNER_FULL_EXCEPT_ADMINISTRATION_ACL;
    public static final EntryKey OWNER_KEY;
    public static final EntryKey OWNER_NEGATIVE_KEY;
    private final Map<EntryKey, Rfc4314Rights> entries;

    public static ACLCommand.Builder command() {
        return new ACLCommand.Builder();
    }

    private static EnumSet<Right> copyOf(Collection<Right> collection) {
        if (collection.isEmpty()) {
            return EnumSet.noneOf(Right.class);
        }
        return EnumSet.copyOf(collection);
    }

    private static Map<EntryKey, Rfc4314Rights> toMap(Properties props) throws UnsupportedRightException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (props != null) {
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                builder.put((Object)EntryKey.deserialize((String)prop.getKey()), (Object)Rfc4314Rights.fromSerializedRfc4314Rights((String)prop.getValue()));
            }
        }
        return builder.build();
    }

    public MailboxACL() {
        this((Map<EntryKey, Rfc4314Rights>)ImmutableMap.of());
    }

    @SafeVarargs
    public MailboxACL(Map.Entry<EntryKey, Rfc4314Rights> ... entries) {
        this((Map)Optional.ofNullable(entries).map(array -> (ImmutableMap)Arrays.stream(array).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(ImmutableMap::of));
    }

    public MailboxACL(Map<EntryKey, Rfc4314Rights> entries) {
        Preconditions.checkNotNull(entries);
        this.entries = ImmutableMap.copyOf(entries);
    }

    public MailboxACL(Properties props) throws UnsupportedRightException {
        this(MailboxACL.toMap(props));
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxACL) {
            MailboxACL acl = (MailboxACL)o;
            return Objects.equals(this.getEntries(), acl.getEntries());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.entries);
    }

    public MailboxACL apply(ACLCommand aclUpdate) throws UnsupportedRightException {
        switch (aclUpdate.getEditMode().ordinal()) {
            case 0: {
                return this.union(aclUpdate.getEntryKey(), aclUpdate.getRights());
            }
            case 1: {
                return this.except(aclUpdate.getEntryKey(), aclUpdate.getRights());
            }
            case 2: {
                return this.replace(aclUpdate.getEntryKey(), aclUpdate.getRights());
            }
        }
        throw new RuntimeException("Unknown edit mode");
    }

    public MailboxACL except(MailboxACL other) throws UnsupportedRightException {
        return new MailboxACL((Map)this.entries.entrySet().stream().map(entry -> Pair.of((Object)((EntryKey)entry.getKey()), (Object)this.except((Rfc4314Rights)entry.getValue(), other.getEntries().get(entry.getKey())))).filter(pair -> !((Rfc4314Rights)pair.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private Rfc4314Rights except(Rfc4314Rights thisRight, Rfc4314Rights exceptRights) {
        return Optional.ofNullable(exceptRights).map(Throwing.function(thisRight::except)).orElse(thisRight);
    }

    public MailboxACL except(EntryKey key, Rfc4314Rights mailboxACLRights) throws UnsupportedRightException {
        return this.except(new MailboxACL(new Entry(key, mailboxACLRights)));
    }

    public Map<EntryKey, Rfc4314Rights> getEntries() {
        return this.entries;
    }

    public MailboxACL replace(EntryKey key, Rfc4314Rights replacement) throws UnsupportedRightException {
        if (this.entries.containsKey(key)) {
            return new MailboxACL((Map)this.entries.entrySet().stream().map(entry -> Pair.of((Object)((EntryKey)entry.getKey()), (Object)(((EntryKey)entry.getKey()).equals(key) ? replacement : (Rfc4314Rights)entry.getValue()))).filter(pair -> pair.getValue() != null && !((Rfc4314Rights)pair.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue)));
        }
        return Optional.ofNullable(replacement).filter(Predicate.not(Rfc4314Rights::isEmpty)).map(replacementValue -> new MailboxACL((Map<EntryKey, Rfc4314Rights>)ImmutableMap.builder().putAll(this.entries).put((Object)key, replacementValue).build())).orElse(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entries", this.entries).toString();
    }

    public MailboxACL union(MailboxACL other) throws UnsupportedRightException {
        if (this.entries.isEmpty()) {
            return other;
        }
        return new MailboxACL((Map)((ImmutableListMultimap)Stream.concat(this.entries.entrySet().stream(), other.getEntries().entrySet().stream()).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue))).asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> this.union((Collection)e.getValue()))));
    }

    private Rfc4314Rights union(Collection<Rfc4314Rights> rights) {
        return rights.stream().reduce(new Rfc4314Rights(new Right[0]), (BinaryOperator<Rfc4314Rights>)Throwing.binaryOperator(Rfc4314Rights::union));
    }

    public MailboxACL union(EntryKey key, Rfc4314Rights mailboxACLRights) throws UnsupportedRightException {
        return this.union(new MailboxACL(new Entry(key, mailboxACLRights)));
    }

    public Map<EntryKey, Rfc4314Rights> ofPositiveNameType(NameType nameType) {
        return (Map)this.entries.entrySet().stream().filter(entry -> !((EntryKey)entry.getKey()).isNegative()).filter(entry -> ((EntryKey)entry.getKey()).getNameType().equals((Object)nameType)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static {
        try {
            ANYBODY_KEY = new EntryKey(SpecialName.anybody.name(), NameType.special, false);
            ANYBODY_NEGATIVE_KEY = new EntryKey(SpecialName.anybody.name(), NameType.special, true);
            AUTHENTICATED_KEY = new EntryKey(SpecialName.authenticated.name(), NameType.special, false);
            AUTHENTICATED_NEGATIVE_KEY = new EntryKey(SpecialName.authenticated.name(), NameType.special, true);
            EMPTY = new MailboxACL();
            FULL_RIGHTS = new Rfc4314Rights(Right.allRights);
            NO_RIGHTS = new Rfc4314Rights(new Right[0]);
            OWNER_KEY = new EntryKey(SpecialName.owner.name(), NameType.special, false);
            OWNER_NEGATIVE_KEY = new EntryKey(SpecialName.owner.name(), NameType.special, true);
            OWNER_FULL_ACL = new MailboxACL(new Entry(OWNER_KEY, FULL_RIGHTS));
            OWNER_FULL_EXCEPT_ADMINISTRATION_ACL = new MailboxACL(new Entry(OWNER_KEY, FULL_RIGHTS.except(new Rfc4314Rights(Right.Administer))));
        }
        catch (UnsupportedRightException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ACLCommand {
        private final EntryKey key;
        private final EditMode editMode;
        private final Rfc4314Rights rights;

        private ACLCommand(EntryKey key, EditMode editMode, Rfc4314Rights rights) {
            this.key = key;
            this.editMode = editMode;
            this.rights = rights;
        }

        public EntryKey getEntryKey() {
            return this.key;
        }

        public EditMode getEditMode() {
            return this.editMode;
        }

        public Rfc4314Rights getRights() {
            return this.rights;
        }

        public final boolean equals(Object o) {
            if (o instanceof ACLCommand) {
                ACLCommand that = (ACLCommand)o;
                return Objects.equals(this.key, that.key) && Objects.equals((Object)this.editMode, (Object)that.editMode) && Objects.equals(this.rights, that.rights);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.key, this.editMode, this.rights});
        }

        public static class Builder {
            private EntryKey key;
            private EditMode editMode;
            private Rfc4314Rights rights;

            private Builder() {
            }

            public Builder forUser(Username user) {
                this.key = EntryKey.createUserEntryKey(user);
                return this;
            }

            public Builder forGroup(String group) {
                this.key = EntryKey.createGroupEntryKey(group);
                return this;
            }

            public Builder forOwner() {
                this.key = OWNER_KEY;
                return this;
            }

            public Builder key(EntryKey key) {
                this.key = key;
                return this;
            }

            public Builder rights(Rfc4314Rights rights) {
                this.rights = rights;
                return this;
            }

            public Builder rights(Right ... rights) throws UnsupportedRightException {
                this.rights = Optional.ofNullable(this.rights).orElseGet(() -> new Rfc4314Rights(new Right[0])).union(new Rfc4314Rights(rights));
                return this;
            }

            public Builder noRights() {
                this.rights = new Rfc4314Rights(new Right[0]);
                return this;
            }

            public Builder mode(EditMode mode) {
                this.editMode = mode;
                return this;
            }

            public ACLCommand asReplacement() {
                this.editMode = EditMode.REPLACE;
                return this.build();
            }

            public ACLCommand asAddition() {
                this.editMode = EditMode.ADD;
                return this.build();
            }

            public ACLCommand asRemoval() {
                this.editMode = EditMode.REMOVE;
                return this.build();
            }

            public ACLCommand build() {
                Preconditions.checkState((this.key != null ? 1 : 0) != 0);
                Preconditions.checkState((this.editMode != null ? 1 : 0) != 0);
                Preconditions.checkState((this.rights != null ? 1 : 0) != 0);
                return new ACLCommand(this.key, this.editMode, this.rights);
            }
        }
    }

    public static enum Right {
        Administer('a'),
        PerformExpunge('e'),
        Insert('i'),
        CreateMailbox('k'),
        Lookup('l'),
        Post('p'),
        Read('r'),
        WriteSeenFlag('s'),
        DeleteMessages('t'),
        Write('w'),
        DeleteMailbox('x');

        private final char rightCharacter;
        public static final EnumSet<Right> allRights;

        private Right(char rightCharacter) {
            this.rightCharacter = rightCharacter;
        }

        public char asCharacter() {
            return this.rightCharacter;
        }

        public static Right forChar(char c) throws UnsupportedRightException {
            return allRights.stream().filter(r -> r.asCharacter() == c).findFirst().orElseThrow(() -> new UnsupportedRightException(c));
        }

        static {
            allRights = EnumSet.allOf(Right.class);
        }
    }

    public static class EntryKey {
        private final String name;
        private final NameType nameType;
        private final boolean negative;

        public static EntryKey createGroupEntryKey(String name) {
            return new EntryKey(name, NameType.group, false);
        }

        public static EntryKey createGroupEntryKey(String name, boolean negative) {
            return new EntryKey(name, NameType.group, negative);
        }

        public static EntryKey createUserEntryKey(Username name) {
            return new EntryKey(name.asString(), NameType.user, false);
        }

        public static EntryKey createUserEntryKey(Username name, boolean negative) {
            return new EntryKey(name.asString(), NameType.user, negative);
        }

        public static EntryKey deserialize(String serialized) {
            String name;
            Preconditions.checkNotNull((Object)serialized, (Object)"Cannot parse null");
            Preconditions.checkArgument((!serialized.isEmpty() ? 1 : 0) != 0, (Object)"Cannot parse an empty string");
            boolean negative = serialized.charAt(0) == '-';
            int nameStart = negative ? 1 : 0;
            boolean isGroup = serialized.charAt(nameStart) == '$';
            Optional<Object> explicitNameType = isGroup ? Optional.of(NameType.group) : Optional.empty();
            String string = name = isGroup ? serialized.substring(nameStart + 1) : serialized.substring(nameStart);
            if (name.isEmpty()) {
                throw new IllegalStateException("Cannot parse a string with empty name");
            }
            NameType nameType = explicitNameType.orElseGet(() -> EntryKey.computeImplicitNameType(name));
            return new EntryKey(name, nameType, negative);
        }

        private static NameType computeImplicitNameType(String name) {
            boolean isSpecialName = Arrays.stream(SpecialName.values()).anyMatch(specialName -> specialName.name().equals(name));
            if (isSpecialName) {
                return NameType.special;
            }
            return NameType.user;
        }

        public EntryKey(String name, NameType nameType, boolean negative) {
            Preconditions.checkNotNull((Object)name, (String)"Provide a name for this %s", (Object)this.getClass().getName());
            Preconditions.checkNotNull((Object)((Object)nameType), (String)"Provide a nameType for this %s", (Object)this.getClass().getName());
            this.name = name;
            this.nameType = nameType;
            this.negative = negative;
        }

        public boolean equals(Object o) {
            if (o instanceof EntryKey) {
                EntryKey other = (EntryKey)o;
                return Objects.equals(this.name, other.getName()) && Objects.equals((Object)this.nameType, (Object)other.getNameType()) && Objects.equals(this.negative, other.isNegative());
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public NameType getNameType() {
            return this.nameType;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.negative, this.nameType, this.name});
        }

        public boolean isNegative() {
            return this.negative;
        }

        public String serialize() {
            String negativePart = this.negative ? String.valueOf('-') : "";
            String nameTypePart = this.nameType == NameType.group ? String.valueOf('$') : "";
            return negativePart + nameTypePart + this.name;
        }

        public String toString() {
            return this.serialize();
        }
    }

    public static class Rfc4314Rights {
        private static final char c_ObsoleteCreate = 'c';
        private static final char d_ObsoleteDelete = 'd';
        private final EnumSet<Right> value;

        public static Rfc4314Rights allExcept(Right ... rights) throws UnsupportedRightException {
            return FULL_RIGHTS.except(new Rfc4314Rights(rights));
        }

        public static Rfc4314Rights deserialize(String serialized) throws UnsupportedRightException {
            return new Rfc4314Rights(serialized);
        }

        public static Rfc4314Rights of(Collection<Right> rights) {
            return new Rfc4314Rights(rights);
        }

        public Rfc4314Rights(Collection<Right> rights) {
            this.value = MailboxACL.copyOf(rights);
        }

        public Rfc4314Rights(Right ... rights) {
            this(MailboxACL.copyOf(Arrays.asList(rights)));
        }

        private Rfc4314Rights(String serializedRfc4314Rights) throws UnsupportedRightException {
            this(Rfc4314Rights.rightListFromSerializedRfc4314Rights(serializedRfc4314Rights));
        }

        public static Rfc4314Rights fromSerializedRfc4314Rights(String serializedRfc4314Rights) throws UnsupportedRightException {
            return new Rfc4314Rights(Rfc4314Rights.rightListFromSerializedRfc4314Rights(serializedRfc4314Rights));
        }

        public static List<Right> rightListFromSerializedRfc4314Rights(String serializedRfc4314Rights) throws UnsupportedRightException {
            return serializedRfc4314Rights.chars().mapToObj(i -> Character.valueOf((char)i)).flatMap(Throwing.function(Rfc4314Rights::convert).sneakyThrow()).collect(Collectors.toList());
        }

        private static Stream<Right> convert(char flag) throws UnsupportedRightException {
            switch (flag) {
                case 'c': {
                    return Stream.of(Right.CreateMailbox, Right.DeleteMailbox);
                }
                case 'd': {
                    return Stream.of(Right.PerformExpunge, Right.DeleteMessages, Right.DeleteMailbox);
                }
            }
            return Stream.of(Right.forChar(flag));
        }

        public boolean contains(char flag) throws UnsupportedRightException {
            return this.contains(Right.forChar(flag));
        }

        public boolean contains(Right right) {
            return this.value.contains((Object)right);
        }

        public boolean contains(Right ... rights) {
            return this.value.containsAll(Arrays.asList(rights));
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public final boolean equals(Object o) {
            if (o instanceof Rfc4314Rights) {
                Rfc4314Rights that = (Rfc4314Rights)o;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public Rfc4314Rights except(Rfc4314Rights toRemove) throws UnsupportedRightException {
            EnumSet<Right> copy = MailboxACL.copyOf(this.value);
            Optional.ofNullable(toRemove).ifPresent(rights -> copy.removeAll(rights.value));
            return new Rfc4314Rights(copy);
        }

        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        public Iterator<Right> iterator() {
            ImmutableList rights = ImmutableList.copyOf(this.value);
            return rights.iterator();
        }

        public List<Right> list() {
            return ImmutableList.copyOf(this.value);
        }

        public String serialize() {
            return this.value.stream().map(Right::asCharacter).map(String::valueOf).collect(Collectors.joining());
        }

        public String toString() {
            return this.serialize();
        }

        public Rfc4314Rights union(Rfc4314Rights toAdd) throws UnsupportedRightException {
            Preconditions.checkNotNull((Object)toAdd);
            EnumSet<Right> rightUnion = EnumSet.noneOf(Right.class);
            rightUnion.addAll(this.value);
            rightUnion.addAll(toAdd.value);
            return new Rfc4314Rights(rightUnion);
        }
    }

    public static enum EditMode {
        ADD,
        REMOVE,
        REPLACE;


        public static Optional<EditMode> parse(String string) {
            return Arrays.stream(EditMode.values()).filter(value -> value.toString().equalsIgnoreCase(string)).findAny();
        }
    }

    public static class Entry
    extends AbstractMap.SimpleEntry<EntryKey, Rfc4314Rights> {
        public Entry(EntryKey key, Rfc4314Rights value) {
            super(key, value);
        }

        public Entry(String key, String value) throws UnsupportedRightException {
            this(EntryKey.deserialize(key), Rfc4314Rights.fromSerializedRfc4314Rights(value));
        }

        public Entry(String key, Right ... rights) throws UnsupportedRightException {
            this(EntryKey.deserialize(key), new Rfc4314Rights(rights));
        }
    }

    public static enum NameType {
        group,
        special,
        user;

    }

    public static enum SpecialName {
        anybody,
        authenticated,
        owner;

    }
}

