/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.inject.Inject;
import jakarta.mail.MessagingException;
import org.apache.james.mailetcontainer.api.MatcherLoader;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceGenericLoader;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PackageName;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;

public class GuiceMatcherLoader
implements MatcherLoader {
    private static final PackageName STANDARD_PACKAGE = PackageName.of((String)"org.apache.james.transport.matchers.");
    private static final NamingScheme MATCHER_NAMING_SCHEME = new NamingScheme.OptionalPackagePrefix(STANDARD_PACKAGE);
    private final GuiceGenericLoader genericLoader;

    @Inject
    public GuiceMatcherLoader(GuiceGenericLoader genericLoader) {
        this.genericLoader = genericLoader;
    }

    public Matcher getMatcher(MatcherConfig config) throws MessagingException {
        try {
            ClassName className = new ClassName(config.getMatcherName());
            Matcher result = (Matcher)this.genericLoader.withNamingSheme(MATCHER_NAMING_SCHEME).instantiate(className);
            result.init(config);
            return result;
        }
        catch (Exception e) {
            throw new MessagingException("Can not load matcher " + config.getMatcherName(), e);
        }
    }
}

