/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver.netty;

import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lmtpserver.CoreCmdHandlerLoader;
import org.apache.james.lmtpserver.jmx.JMXHandlersLoader;
import org.apache.james.lmtpserver.netty.LMTPMetricsImpl;
import org.apache.james.lmtpserver.netty.LMTPServerMBean;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.apache.james.protocols.lmtp.LMTPConfiguration;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.LineDelimiterBasedChannelHandlerFactory;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.netty.SMTPChannelInboundHandler;
import org.apache.james.smtpserver.netty.SmtpMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMTPServer
extends AbstractProtocolAsyncServer
implements LMTPServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LMTPServer.class);
    private long maxMessageSize = 0L;
    private final LMTPConfigurationImpl lmtpConfig = new LMTPConfigurationImpl();
    private final LMTPMetricsImpl lmtpMetrics;
    private String lmtpGreeting;

    public LMTPServer(LMTPMetricsImpl lmtpMetrics) {
        this.lmtpMetrics = lmtpMetrics;
    }

    public int getDefaultPort() {
        return 24;
    }

    public String getServiceType() {
        return "LMTP Service";
    }

    public void doConfigure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        if (this.isEnabled()) {
            this.maxMessageSize = configuration.getLong("maxmessagesize", this.maxMessageSize) * 1024L;
            if (this.maxMessageSize > 0L) {
                LOGGER.info("The maximum allowed message size is {} bytes.", (Object)this.maxMessageSize);
            } else {
                LOGGER.info("No maximum message size is enforced for this server.");
            }
            this.lmtpGreeting = configuration.getString("lmtpGreeting", null);
        }
    }

    @Override
    public long getMaximalMessageSize() {
        return this.lmtpConfig.getMaxMessageSize();
    }

    protected String getDefaultJMXName() {
        return "lmtpserver";
    }

    @Override
    public void setMaximalMessageSize(long maxSize) {
        this.maxMessageSize = maxSize;
    }

    @Override
    public String getHeloName() {
        return this.lmtpConfig.getHelloName();
    }

    protected ChannelInboundHandlerAdapter createCoreHandler() {
        SMTPProtocol transport = new SMTPProtocol(this.getProtocolHandlerChain(), (SMTPConfiguration)this.lmtpConfig){

            public ProtocolSession newSession(ProtocolTransport transport) {
                return new ExtendedSMTPSession((SMTPConfiguration)LMTPServer.this.lmtpConfig, transport);
            }
        };
        return new SMTPChannelInboundHandler((Protocol)transport, (SmtpMetrics)this.lmtpMetrics);
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new LineDelimiterBasedChannelHandlerFactory(8192);
    }

    public class LMTPConfigurationImpl
    extends LMTPConfiguration {
        protected LMTPConfigurationImpl() {
            super("JAMES Protocols Server");
        }

        public SMTPConfiguration.SenderVerificationMode verifyIdentity() {
            return SMTPConfiguration.SenderVerificationMode.DISABLED;
        }

        public String getHelloName() {
            return LMTPServer.this.getHelloName();
        }

        public long getMaxMessageSize() {
            return LMTPServer.this.maxMessageSize;
        }

        public String getSMTPGreeting() {
            return LMTPServer.this.lmtpGreeting;
        }

        public boolean isPlainAuthEnabled() {
            return false;
        }

        public Optional<OidcSASLConfiguration> saslConfiguration() {
            return Optional.empty();
        }
    }
}

