/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.upload;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingInputStream;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;

public class InMemoryUploadRepository
implements UploadRepository {
    private final Map<UploadId, ImmutablePair<Username, UploadMetaData>> uploadStore;
    private final BlobStore blobStore;
    private final BucketName bucketName;
    private final Clock clock;

    @Inject
    public InMemoryUploadRepository(BlobStore blobStore, Clock clock) {
        this.blobStore = blobStore;
        this.bucketName = blobStore.getDefaultBucketName();
        this.clock = clock;
        this.uploadStore = new HashMap<UploadId, ImmutablePair<Username, UploadMetaData>>();
    }

    @Override
    public Publisher<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)contentType);
        Preconditions.checkNotNull((Object)user);
        return Mono.fromCallable(() -> new CountingInputStream(data)).flatMap(dataAsByte -> Mono.from((Publisher)this.blobStore.save(this.bucketName, (InputStream)dataAsByte, BlobStore.StoragePolicy.LOW_COST)).map(blobId -> {
            UploadId uploadId = UploadId.random();
            Instant uploadDate = this.clock.instant();
            this.uploadStore.put(uploadId, (ImmutablePair<Username, UploadMetaData>)new ImmutablePair((Object)user, (Object)UploadMetaData.from(uploadId, contentType, dataAsByte.getCount(), blobId, uploadDate)));
            return UploadMetaData.from(uploadId, contentType, dataAsByte.getCount(), blobId, uploadDate);
        }));
    }

    @Override
    public Publisher<Upload> retrieve(UploadId id, Username user) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)user);
        return Mono.justOrEmpty(this.uploadStore.get(id)).filter(pair -> user.equals(pair.left)).flatMap(userAndMetaData -> this.retrieveUpload((UploadMetaData)userAndMetaData.right)).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    @Override
    public Publisher<Boolean> delete(UploadId id, Username user) {
        return Mono.justOrEmpty(this.uploadStore.get(id)).filter(pair -> user.equals(pair.left)).map(pair -> {
            this.uploadStore.remove(id);
            return true;
        }).defaultIfEmpty((Object)false);
    }

    @Override
    public Publisher<UploadMetaData> listUploads(Username user) {
        return Flux.fromIterable(this.uploadStore.values()).filter(pair -> user.equals(pair.left)).map(pair -> (UploadMetaData)pair.right);
    }

    private Mono<Upload> retrieveUpload(UploadMetaData uploadMetaData) {
        return Mono.from((Publisher)this.blobStore.readBytes(this.bucketName, uploadMetaData.blobId())).map(content -> Upload.from(uploadMetaData, (Function0<InputStream>)((Function0)() -> new ByteArrayInputStream((byte[])content))));
    }
}

