/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.lib;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.impl.MailetProcessorImpl;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.jmx.JMXStateCompositeProcessorListener;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.ProcessingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStateCompositeProcessor
implements MailProcessor,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStateCompositeProcessor.class);
    private final Collection<CompositeProcessorListener> listeners = new ConcurrentLinkedDeque<CompositeProcessorListener>();
    private final Map<String, MailProcessor> processors = new HashMap<String, MailProcessor>();
    protected HierarchicalConfiguration<ImmutableNode> config;
    private JMXStateCompositeProcessorListener jmxListener;
    private boolean enableJmx = true;

    public void addListener(CompositeProcessorListener listener) {
        this.listeners.add(listener);
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) {
        this.config = config;
        this.enableJmx = config.getBoolean("[@enableJmx]", true);
    }

    public void service(Mail mail) throws MessagingException {
        this.handleWithProcessor(mail, this.getProcessorOrFallBackToError(mail));
    }

    private MailProcessor getProcessorOrFallBackToError(Mail mail) {
        return Optional.ofNullable(this.getProcessor(mail.getState())).orElseGet(() -> {
            mail.setErrorMessage("MailProcessor '" + mail.getState() + "' could not be found. Processing to 'error' instead");
            LOGGER.error("MailProcessor '{}' could not be found. Processing {} to 'error' instead", (Object)mail.getState(), (Object)mail.getName());
            mail.setState("error");
            return this.getProcessor("error");
        });
    }

    private void handleWithProcessor(Mail mail, MailProcessor processor) throws MessagingException {
        MessagingException ex = null;
        long start = System.currentTimeMillis();
        LOGGER.debug("Call MailProcessor {}", (Object)mail.getState());
        try {
            processor.service(mail);
            if ("ghost".equals(mail.getState())) {
                LifecycleUtil.dispose((Object)mail);
            }
        }
        catch (MessagingException e) {
            ex = e;
            throw e;
        }
        finally {
            long end = System.currentTimeMillis() - start;
            for (CompositeProcessorListener listener : this.listeners) {
                listener.afterProcessor(processor, mail.getName(), end, ex);
            }
        }
    }

    public MailProcessor getProcessor(String state) {
        return this.processors.get(state);
    }

    public String[] getProcessorStates() {
        return (String[])this.processors.keySet().toArray(String[]::new);
    }

    private void checkProcessors() throws ConfigurationException {
        if (!this.processors.containsKey("error")) {
            throw new ConfigurationException("You need to configure a Processor with name error");
        }
        if (!this.processors.containsKey("root")) {
            throw new ConfigurationException("You need to configure a Processor with name root");
        }
        ImmutableList missingProcessors = (ImmutableList)this.processors.values().stream().filter(MailetProcessorImpl.class::isInstance).map(MailetProcessorImpl.class::cast).flatMap(processor -> processor.getPairs().stream().map(MatcherMailetPair::getMailet)).flatMap(this::requiredProcessorStates).filter(state -> !state.equals((Object)new ProcessingState("propagate")) && !state.equals((Object)new ProcessingState("ignore"))).filter(state -> !this.processors.containsKey(state.getValue())).collect(ImmutableList.toImmutableList());
        if (!missingProcessors.isEmpty()) {
            throw new ConfigurationException("Your configurations specifies the following undefined processors: " + String.valueOf(missingProcessors));
        }
    }

    private Stream<ProcessingState> requiredProcessorStates(Mailet mailet) {
        return Stream.concat(mailet.requiredProcessingState().stream(), Stream.of(Optional.ofNullable(mailet.getMailetConfig().getInitParameter("onMailetException")), Optional.ofNullable(mailet.getMailetConfig().getInitParameter("onMatcherException"))).flatMap(Optional::stream).map(ProcessingState::new));
    }

    @PostConstruct
    public void init() throws Exception {
        List processorConfs = this.config.configurationsAt("processor");
        for (HierarchicalConfiguration processorConf : processorConfs) {
            String processorName = processorConf.getString("[@state]");
            if (!processorConf.containsKey("[@enableJmx]")) {
                processorConf.addProperty("[@enableJmx]", (Object)this.enableJmx);
            }
            this.processors.put(processorName, this.createMailProcessor(processorName, (HierarchicalConfiguration<ImmutableNode>)processorConf));
        }
        if (this.enableJmx) {
            this.jmxListener = new JMXStateCompositeProcessorListener(this);
            this.addListener(this.jmxListener);
        }
        this.checkProcessors();
    }

    @PreDestroy
    public void dispose() {
        String[] names;
        for (String name : names = this.getProcessorStates()) {
            MailProcessor processor = this.getProcessor(name);
            if (!(processor instanceof AbstractStateMailetProcessor)) continue;
            ((AbstractStateMailetProcessor)processor).destroy();
        }
        if (this.jmxListener != null) {
            this.jmxListener.dispose();
        }
    }

    protected abstract MailProcessor createMailProcessor(String var1, HierarchicalConfiguration<ImmutableNode> var2) throws Exception;

    public static interface CompositeProcessorListener {
        public void afterProcessor(MailProcessor var1, String var2, long var3, MessagingException var5);
    }
}

