/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StoreAttachmentManager
implements AttachmentManager {
    private final AttachmentMapperFactory attachmentMapperFactory;
    private final MessageIdManager messageIdManager;

    @Inject
    public StoreAttachmentManager(AttachmentMapperFactory attachmentMapperFactory, MessageIdManager messageIdManager) {
        this.attachmentMapperFactory = attachmentMapperFactory;
        this.messageIdManager = messageIdManager;
    }

    public boolean exists(AttachmentId attachmentId, MailboxSession session) throws MailboxException {
        AttachmentMetadata attachment = this.attachmentMapperFactory.getAttachmentMapper(session).getAttachment(attachmentId);
        return this.exists(attachment, session);
    }

    public Mono<Boolean> existsReactive(AttachmentId attachmentId, MailboxSession session) {
        return this.attachmentMapperFactory.getAttachmentMapper(session).getAttachmentReactive(attachmentId).flatMap(attachment -> this.existsReactive((AttachmentMetadata)attachment, session));
    }

    public boolean exists(AttachmentMetadata attachment, MailboxSession session) throws MailboxException {
        return !this.messageIdManager.accessibleMessages((Collection)ImmutableList.of((Object)attachment.getMessageId()), session).isEmpty();
    }

    public Mono<Boolean> existsReactive(AttachmentMetadata attachment, MailboxSession session) {
        return Mono.from((Publisher)this.messageIdManager.accessibleMessagesReactive((Collection)ImmutableList.of((Object)attachment.getMessageId()), session)).map(accessibleMessages -> !accessibleMessages.isEmpty());
    }

    public AttachmentMetadata getAttachment(AttachmentId attachmentId, MailboxSession mailboxSession) throws MailboxException, AttachmentNotFoundException {
        AttachmentMetadata attachment = this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getAttachment(attachmentId);
        if (!this.exists(attachment, mailboxSession)) {
            throw new AttachmentNotFoundException(attachmentId.getId());
        }
        return attachment;
    }

    public List<AttachmentMetadata> getAttachments(List<AttachmentId> attachmentIds, MailboxSession mailboxSession) throws MailboxException {
        List<AttachmentMetadata> attachments = this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).getAttachments(attachmentIds);
        Set accessibleMessageIds = this.messageIdManager.accessibleMessages((Collection)attachments.stream().map(AttachmentMetadata::getMessageId).collect(ImmutableList.toImmutableList()), mailboxSession);
        return (List)attachments.stream().filter(entry -> accessibleMessageIds.contains(entry.getMessageId())).collect(ImmutableList.toImmutableList());
    }

    public InputStream loadAttachmentContent(AttachmentId attachmentId, MailboxSession mailboxSession) throws AttachmentNotFoundException, IOException {
        try {
            if (!this.exists(attachmentId, mailboxSession)) {
                throw new AttachmentNotFoundException(attachmentId.getId());
            }
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
        return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).loadAttachmentContent(attachmentId);
    }

    public Mono<InputStream> loadAttachmentContentReactive(AttachmentId attachmentId, MailboxSession mailboxSession) {
        return this.existsReactive(attachmentId, mailboxSession).flatMap(exist -> {
            if (!exist.booleanValue()) {
                return Mono.error((Throwable)new AttachmentNotFoundException(attachmentId.getId()));
            }
            return this.attachmentMapperFactory.getAttachmentMapper(mailboxSession).loadAttachmentContentReactive(attachmentId);
        });
    }
}

