/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionIdGenerator;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.ForbiddenDelegationException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UserDoesNotExistException;
import org.apache.james.mailbox.store.RandomMailboxSessionIdGenerator;

public class SessionProviderImpl
implements SessionProvider {
    private final MailboxSessionIdGenerator idGenerator = new RandomMailboxSessionIdGenerator();
    private final Authenticator authenticator;
    private final Authorizator authorizator;

    @Inject
    public SessionProviderImpl(Authenticator authenticator, Authorizator authorizator) {
        this.authenticator = authenticator;
        this.authorizator = authorizator;
    }

    public MailboxSession createSystemSession(Username userName) {
        return this.createSession(userName, Optional.empty(), MailboxSession.SessionType.System);
    }

    public SessionProvider.AuthorizationStep authenticate(final Username loginUsername, final String passwd) {
        return new SessionProvider.AuthorizationStep(){
            final /* synthetic */ SessionProviderImpl this$0;
            {
                this.this$0 = this$0;
            }

            public MailboxSession as(Username otherUserId) throws MailboxException {
                Optional<Username> loggedInUser = this.this$0.isValidLogin(loginUsername, passwd);
                if (loggedInUser.isEmpty()) {
                    throw new BadCredentialsException();
                }
                return this.this$0.authenticate(loggedInUser.get()).as(otherUserId);
            }

            public MailboxSession withoutDelegation() throws MailboxException {
                Optional<Username> loggedInUser = this.this$0.isValidLogin(loginUsername, passwd);
                if (loggedInUser.isPresent()) {
                    return this.this$0.createSession(loggedInUser.get(), loggedInUser, MailboxSession.SessionType.User);
                }
                throw new BadCredentialsException();
            }

            public MailboxSession forMatchingUser(Predicate<Username> otherPredicate) throws MailboxException {
                Username loggedInUser = this.this$0.isValidLogin(loginUsername, passwd).orElseThrow(BadCredentialsException::new);
                return this.this$0.authorizator.delegatedUsers(loggedInUser).stream().filter(otherPredicate).findFirst().map(otherUserId -> this.this$0.createSession((Username)otherUserId, Optional.of(loggedInUser), MailboxSession.SessionType.System)).orElseThrow(() -> new ForbiddenDelegationException(loggedInUser));
            }
        };
    }

    public SessionProvider.AuthorizationStep authenticate(final Username givenUserid) {
        return new SessionProvider.AuthorizationStep(){
            final /* synthetic */ SessionProviderImpl this$0;
            {
                this.this$0 = this$0;
            }

            public MailboxSession as(Username otherUserId) throws MailboxException {
                Authorizator.AuthorizationState authorizationState = this.this$0.authorizator.user(givenUserid).canLoginAs(otherUserId);
                switch (authorizationState) {
                    case ALLOWED: {
                        return this.this$0.createSession(otherUserId, Optional.of(givenUserid), MailboxSession.SessionType.System);
                    }
                    case FORBIDDEN: {
                        throw new ForbiddenDelegationException(givenUserid, otherUserId);
                    }
                    case UNKNOWN_USER: {
                        throw new UserDoesNotExistException(otherUserId);
                    }
                }
                throw new RuntimeException("Unknown AuthorizationState " + String.valueOf(authorizationState));
            }

            public MailboxSession withoutDelegation() {
                return this.this$0.createSession(givenUserid, Optional.of(givenUserid), MailboxSession.SessionType.System);
            }

            public MailboxSession forMatchingUser(Predicate<Username> otherPredicate) throws MailboxException {
                return this.this$0.authorizator.delegatedUsers(givenUserid).stream().filter(otherPredicate).findFirst().map(otherUserId -> this.this$0.createSession((Username)otherUserId, Optional.of(givenUserid), MailboxSession.SessionType.System)).orElseThrow(() -> new ForbiddenDelegationException(givenUserid));
            }
        };
    }

    private MailboxSession createSession(Username userName, Optional<Username> loggedInUser, MailboxSession.SessionType type) {
        return new MailboxSession(this.newSessionId(), userName, loggedInUser, new ArrayList(), '.', type);
    }

    private MailboxSession.SessionId newSessionId() {
        return MailboxSession.SessionId.of((long)this.randomId());
    }

    private long randomId() {
        return this.idGenerator.nextId();
    }

    private Optional<Username> isValidLogin(Username userid, String passwd) throws MailboxException {
        return this.authenticator.isAuthentic(userid, (CharSequence)passwd);
    }
}

