/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.mail.Flags;
import java.io.InputStream;
import java.time.Clock;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.MimeMessageId;
import org.apache.james.mailbox.store.mail.model.Subject;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.utils.MimeMessageHeadersUtil;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.HeaderImpl;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface MessageStorer {
    public Mono<Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>>> appendMessageToStore(Mailbox var1, Date var2, int var3, int var4, Content var5, Flags var6, PropertyBuilder var7, Optional<Message> var8, MailboxSession var9, HeaderImpl var10) throws MailboxException;

    public static class WithoutAttachment
    implements MessageStorer {
        private final MailboxSessionMapperFactory mapperFactory;
        private final MessageId.Factory messageIdFactory;
        private final MessageFactory messageFactory;
        private final ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm;
        private final Clock clock;

        public WithoutAttachment(MailboxSessionMapperFactory mapperFactory, MessageId.Factory messageIdFactory, MessageFactory messageFactory, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock) {
            this.mapperFactory = mapperFactory;
            this.messageIdFactory = messageIdFactory;
            this.messageFactory = messageFactory;
            this.threadIdGuessingAlgorithm = threadIdGuessingAlgorithm;
            this.clock = clock;
        }

        @Override
        public Mono<Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>>> appendMessageToStore(Mailbox mailbox, Date internalDate, int size, int bodyStartOctet, Content content, Flags flags, PropertyBuilder propertyBuilder, Optional<Message> maybeMessage, MailboxSession session, HeaderImpl headers) throws MailboxException {
            MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
            MessageId messageId = this.messageIdFactory.generate();
            Optional<MimeMessageId> mimeMessageId = MimeMessageHeadersUtil.parseMimeMessageId(headers);
            Optional<MimeMessageId> inReplyTo = MimeMessageHeadersUtil.parseInReplyTo(headers);
            Optional<List<MimeMessageId>> references = MimeMessageHeadersUtil.parseReferences(headers);
            Optional<Subject> subject = MimeMessageHeadersUtil.parseSubject(headers);
            return this.mapperFactory.getMessageMapper(session).executeReactive(this.threadIdGuessingAlgorithm.guessThreadIdReactive(messageId, mimeMessageId, inReplyTo, references, subject, session).flatMap((Function)Throwing.function(threadId -> {
                Date saveDate = Date.from(this.clock.instant());
                Object message = this.messageFactory.createMessage(messageId, (ThreadId)threadId, mailbox, internalDate, saveDate, size, bodyStartOctet, content, flags, propertyBuilder, (List<MessageAttachmentMetadata>)ImmutableList.of());
                return Mono.from(messageMapper.addReactive(mailbox, (MailboxMessage)message)).map(metadata -> Pair.of((Object)metadata, Optional.empty()));
            })));
        }
    }

    public static class WithAttachment
    implements MessageStorer {
        private static final Logger LOGGER = LoggerFactory.getLogger(WithAttachment.class);
        private final MailboxSessionMapperFactory mapperFactory;
        private final MessageId.Factory messageIdFactory;
        private final MessageFactory messageFactory;
        private final AttachmentMapperFactory attachmentMapperFactory;
        private final MessageParser messageParser;
        private final ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm;
        private final Clock clock;

        public WithAttachment(MailboxSessionMapperFactory mapperFactory, MessageId.Factory messageIdFactory, MessageFactory messageFactory, AttachmentMapperFactory attachmentMapperFactory, MessageParser messageParser, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock) {
            this.mapperFactory = mapperFactory;
            this.messageIdFactory = messageIdFactory;
            this.messageFactory = messageFactory;
            this.attachmentMapperFactory = attachmentMapperFactory;
            this.messageParser = messageParser;
            this.threadIdGuessingAlgorithm = threadIdGuessingAlgorithm;
            this.clock = clock;
        }

        @Override
        public Mono<Pair<MessageMetaData, Optional<List<MessageAttachmentMetadata>>>> appendMessageToStore(Mailbox mailbox, Date internalDate, int size, int bodyStartOctet, Content content, Flags flags, PropertyBuilder propertyBuilder, Optional<Message> maybeMessage, MailboxSession session, HeaderImpl headers) {
            MessageMapper messageMapper = this.mapperFactory.getMessageMapper(session);
            MessageId messageId = this.messageIdFactory.generate();
            Optional<MimeMessageId> mimeMessageId = MimeMessageHeadersUtil.parseMimeMessageId(headers);
            Optional<MimeMessageId> inReplyTo = MimeMessageHeadersUtil.parseInReplyTo(headers);
            Optional<List<MimeMessageId>> references = MimeMessageHeadersUtil.parseReferences(headers);
            Optional<Subject> subject = MimeMessageHeadersUtil.parseSubject(headers);
            return this.mapperFactory.getMessageMapper(session).executeReactive(this.storeAttachments(messageId, content, maybeMessage, session).subscribeOn(Schedulers.boundedElastic()).zipWith(this.threadIdGuessingAlgorithm.guessThreadIdReactive(messageId, mimeMessageId, inReplyTo, references, subject, session)).flatMap(Throwing.function(pair -> {
                List attachments = (List)pair.getT1();
                ThreadId threadId = (ThreadId)pair.getT2();
                Date saveDate = Date.from(this.clock.instant());
                Object message = this.messageFactory.createMessage(messageId, threadId, mailbox, internalDate, saveDate, size, bodyStartOctet, content, flags, propertyBuilder, attachments);
                return Mono.from(messageMapper.addReactive(mailbox, (MailboxMessage)message)).map(metadata -> Pair.of((Object)metadata, Optional.of(attachments)));
            }).sneakyThrow()));
        }

        private Mono<List<MessageAttachmentMetadata>> storeAttachments(MessageId messageId, Content messageContent, Optional<Message> maybeMessage, MailboxSession session) {
            return Mono.usingWhen((Publisher)Mono.fromCallable(() -> this.extractAttachments(messageContent, maybeMessage)), attachments -> this.attachmentMapperFactory.getAttachmentMapper(session).storeAttachmentsReactive(attachments.getAttachments(), messageId), parsingResults -> Mono.fromRunnable(parsingResults::dispose).subscribeOn(Schedulers.boundedElastic()));
        }

        private MessageParser.ParsingResult extractAttachments(Content contentIn, Optional<Message> maybeMessage) {
            return maybeMessage.map(message -> {
                try {
                    return new MessageParser.ParsingResult(this.messageParser.retrieveAttachments((Message)message), () -> {});
                }
                catch (Exception e) {
                    LOGGER.warn("Error while parsing mail's attachments: {}", (Object)e.getMessage(), (Object)e);
                    return MessageParser.ParsingResult.EMPTY;
                }
            }).orElseGet(() -> {
                MessageParser.ParsingResult parsingResult;
                block8: {
                    InputStream inputStream = contentIn.getInputStream();
                    try {
                        parsingResult = this.messageParser.retrieveAttachments(inputStream);
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Error while parsing mail's attachments: {}", (Object)e.getMessage(), (Object)e);
                            return MessageParser.ParsingResult.EMPTY;
                        }
                    }
                    inputStream.close();
                }
                return parsingResult;
            });
        }
    }
}

