/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class InMemoryCurrentQuotaManager
implements CurrentQuotaManager {
    private final LoadingCache<QuotaRoot, AtomicReference<CurrentQuotas>> quotaCache;

    @Inject
    public InMemoryCurrentQuotaManager(final CurrentQuotaCalculator quotaCalculator, final SessionProvider sessionProvider) {
        this.quotaCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QuotaRoot, AtomicReference<CurrentQuotas>>(this){
            final /* synthetic */ InMemoryCurrentQuotaManager this$0;
            {
                this.this$0 = this$0;
            }

            public AtomicReference<CurrentQuotas> load(QuotaRoot quotaRoot) {
                return new AtomicReference<CurrentQuotas>(this.this$0.loadQuotas(quotaRoot, quotaCalculator, sessionProvider));
            }
        });
    }

    public CurrentQuotas loadQuotas(QuotaRoot quotaRoot, CurrentQuotaCalculator quotaCalculator, SessionProvider sessionProvider) {
        return (CurrentQuotas)quotaCalculator.recalculateCurrentQuotas(quotaRoot, sessionProvider.createSystemSession(Username.of((String)quotaRoot.getValue()))).block();
    }

    public Mono<Void> increase(QuotaOperation quotaOperation) {
        return this.updateQuota(quotaOperation.quotaRoot(), quota -> quota.increase(new CurrentQuotas(quotaOperation.count(), quotaOperation.size())));
    }

    public Mono<Void> decrease(QuotaOperation quotaOperation) {
        return this.updateQuota(quotaOperation.quotaRoot(), quota -> quota.decrease(new CurrentQuotas(quotaOperation.count(), quotaOperation.size())));
    }

    public Mono<QuotaCountUsage> getCurrentMessageCount(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> ((CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).get()).count()).onErrorMap(this::wrapAsMailboxException);
    }

    public Mono<QuotaSizeUsage> getCurrentStorage(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> ((CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).get()).size()).onErrorMap(this::wrapAsMailboxException);
    }

    public Mono<CurrentQuotas> getCurrentQuotas(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> (CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).get()).subscribeOn(Schedulers.boundedElastic()).onErrorMap(this::wrapAsMailboxException);
    }

    public Mono<Void> setCurrentQuotas(QuotaOperation quotaOperation) {
        return Mono.fromRunnable(() -> this.quotaCache.put((Object)quotaOperation.quotaRoot(), new AtomicReference<CurrentQuotas>(new CurrentQuotas(quotaOperation.count(), quotaOperation.size())))).onErrorMap(this::wrapAsMailboxException).then();
    }

    private Mono<Void> updateQuota(QuotaRoot quotaRoot, UnaryOperator<CurrentQuotas> quotaFunction) {
        return Mono.fromCallable(() -> (CurrentQuotas)((AtomicReference)this.quotaCache.get((Object)quotaRoot)).updateAndGet(quotaFunction)).onErrorMap(this::wrapAsMailboxException).then();
    }

    private Throwable wrapAsMailboxException(Throwable throwable) {
        return new MailboxException("Exception caught", throwable);
    }
}

