/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.IDRequest;
import org.apache.james.imap.message.response.IdResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class IdProcessor
extends AbstractMailboxProcessor<IDRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdProcessor.class);
    private static final ImmutableList<Capability> CAPABILITIES = ImmutableList.of((Object)Capability.of("ID"));

    @Inject
    public IdProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(IDRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(IDRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MDCStructuredLogger.forLogger((Logger)LOGGER).field("parameters", request.getParameters().map(Object::toString).orElse("NIL")).log(logger -> logger.info("Received id information"));
        responder.respond(new IdResponse());
        return this.unsolicitedResponses(session, responder, false).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
    }

    @Override
    protected MDCBuilder mdc(IDRequest message) {
        return MDCBuilder.create().addToContext("action", "ID");
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }
}

