/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.DeleteACLRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DeleteACLProcessor
extends AbstractMailboxProcessor<DeleteACLRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteACLProcessor.class);
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_ACL);

    @Inject
    public DeleteACLProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(DeleteACLRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(DeleteACLRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        String mailboxName = request.getMailboxName();
        String identifier = request.getIdentifier();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        return this.checkLookupRight(request, responder, mailboxManager, mailboxSession, mailboxPath).filter(FunctionalUtils.identityPredicate()).flatMap(hasLookupRight -> this.checkAdminRight(request, responder, mailboxManager, mailboxSession, mailboxName, mailboxPath)).filter(FunctionalUtils.identityPredicate()).flatMap(hasAdminRight -> DeleteACLProcessor.applyRight(mailboxManager, mailboxSession, identifier, mailboxPath).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).then()).onErrorResume(UnsupportedRightException.class, error -> Mono.fromRunnable(() -> this.taggedBad(request, responder, new HumanReadableText("org.apache.james.imap.UNSUPPORTED_RIGHT", "The {0} right is not supported.", Character.valueOf(error.getUnsupportedRight()))))).onErrorResume(MailboxNotFoundException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND))).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("{} failed for mailbox {}", new Object[]{request.getCommand().getName(), mailboxName, e}))).onErrorResume(MailboxException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING)));
    }

    private static Mono<Void> applyRight(MailboxManager mailboxManager, MailboxSession mailboxSession, String identifier, MailboxPath mailboxPath) {
        return Mono.from((Publisher)mailboxManager.applyRightsCommandReactive(mailboxPath, MailboxACL.command().key(MailboxACL.EntryKey.deserialize((String)identifier)).noRights().asReplacement(), mailboxSession));
    }

    private Mono<Boolean> checkAdminRight(DeleteACLRequest request, ImapProcessor.Responder responder, MailboxManager mailboxManager, MailboxSession mailboxSession, String mailboxName, MailboxPath mailboxPath) {
        return Mono.from((Publisher)mailboxManager.hasRightReactive(mailboxPath, MailboxACL.Right.Administer, mailboxSession)).doOnNext(hasRight -> {
            if (!hasRight.booleanValue()) {
                this.no(request, responder, new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", MailboxACL.Right.Administer.toString(), request.getCommand().getName(), mailboxName));
            }
        });
    }

    private Mono<Boolean> checkLookupRight(DeleteACLRequest request, ImapProcessor.Responder responder, MailboxManager mailboxManager, MailboxSession mailboxSession, MailboxPath mailboxPath) {
        return Mono.from((Publisher)mailboxManager.hasRightReactive(mailboxPath, MailboxACL.Right.Lookup, mailboxSession)).doOnNext(hasRight -> {
            if (!hasRight.booleanValue()) {
                this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            }
        });
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected MDCBuilder mdc(DeleteACLRequest request) {
        return MDCBuilder.create().addToContext("action", "DELETE_ACL").addToContext("mailbox", request.getMailboxName()).addToContext("identifier", request.getIdentifier());
    }
}

