/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.modules.server.HealthCheckRoutesModule;
import org.apache.james.modules.server.ServerRouteModule;
import org.apache.james.modules.server.TaskRoutesModule;
import org.apache.james.server.task.json.TaskExtensionModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.ExtensionConfiguration;
import org.apache.james.utils.GuiceGenericLoader;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PropertiesProvider;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.FixedPortSupplier;
import org.apache.james.webadmin.PortSupplier;
import org.apache.james.webadmin.RandomPortSupplier;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.TlsConfiguration;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import org.apache.james.webadmin.authentication.JwtFilter;
import org.apache.james.webadmin.authentication.NoAuthenticationFilter;
import org.apache.james.webadmin.mdc.RequestLogger;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAdminServerModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAdminServerModule.class);
    private static final boolean DEFAULT_JWT_DISABLED = false;
    private static final boolean DEFAULT_DISABLED = false;
    private static final String DEFAULT_NO_CORS_ORIGIN = null;
    private static final boolean DEFAULT_CORS_DISABLED = false;
    private static final String DEFAULT_NO_KEYSTORE = null;
    private static final boolean DEFAULT_HTTPS_DISABLED = false;
    private static final String DEFAULT_NO_PASSWORD = null;
    private static final String DEFAULT_NO_TRUST_KEYSTORE = null;
    private static final String DEFAULT_NO_TRUST_PASSWORD = null;

    protected void configure() {
        this.install((Module)new TaskRoutesModule());
        this.install((Module)new HealthCheckRoutesModule());
        this.install((Module)new ServerRouteModule());
        this.bind(JsonTransformer.class).in(Scopes.SINGLETON);
        this.bind(WebAdminServer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(WebAdminGuiceProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), JsonTransformerModule.class);
        Multibinder.newSetBinder((Binder)this.binder(), RequestLogger.class);
    }

    @Provides
    @Singleton
    @Named(value="webAdminRoutes")
    public List<Routes> provideRoutes(GuiceGenericLoader loader, WebAdminConfiguration configuration, Set<Routes> routesList) {
        List customRoutes = (List)configuration.getAdditionalRoutes().stream().map(ClassName::new).map(Throwing.function(arg_0 -> ((GuiceGenericLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).peek(routes -> LOGGER.info("Loading WebAdmin route extension {}", (Object)routes.getClass().getCanonicalName())).collect(ImmutableList.toImmutableList());
        return ImmutableList.builder().addAll(routesList).addAll((Iterable)customRoutes).build();
    }

    @Provides
    @Singleton
    @Named(value="custom-webadmin-dto")
    public Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>> provideAdditionalDTOs(GuiceGenericLoader loader, ExtensionConfiguration extensionConfiguration) {
        return extensionConfiguration.getTaskExtensions().stream().map(Throwing.function(arg_0 -> ((GuiceGenericLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).map(TaskExtensionModule::taskAdditionalInformationDTOModules).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Provides
    @Singleton
    public WebAdminConfiguration provideWebAdminConfiguration(FileSystem fileSystem, PropertiesProvider propertiesProvider) throws Exception {
        try {
            Configuration configurationFile = propertiesProvider.getConfiguration("webadmin");
            ImmutableList<String> additionalRoutes = this.additionalRoutes(configurationFile);
            return WebAdminConfiguration.builder().enable(configurationFile.getBoolean("enabled", false)).port(this.port(configurationFile)).tls(this.readHttpsConfiguration(configurationFile)).enableCORS(configurationFile.getBoolean("cors.enable", false)).urlCORSOrigin(configurationFile.getString("cors.origin", DEFAULT_NO_CORS_ORIGIN)).host(configurationFile.getString("host", "localhost")).additionalRoutes(additionalRoutes).jwtPublicKeyPEM(this.loadPublicKey(fileSystem, Optional.ofNullable(configurationFile.getString("jwt.publickeypem.url", null)))).maxThreadCount(Optional.ofNullable(configurationFile.getInteger("maxThreadCount", null))).minThreadCount(Optional.ofNullable(configurationFile.getInteger("minThreadCount", null))).build();
        }
        catch (FileNotFoundException e) {
            LOGGER.info("No webadmin.properties file. Disabling WebAdmin interface.");
            return WebAdminConfiguration.DISABLED_CONFIGURATION;
        }
    }

    private PortSupplier port(Configuration configurationFile) {
        int portNumber = configurationFile.getInt("port", 8080);
        if (portNumber == 0) {
            return new RandomPortSupplier();
        }
        return new FixedPortSupplier(portNumber);
    }

    @VisibleForTesting
    ImmutableList<String> additionalRoutes(Configuration configurationFile) {
        return ImmutableList.copyOf((Object[])configurationFile.getStringArray("extensions.routes"));
    }

    private Optional<String> loadPublicKey(FileSystem fileSystem, Optional<String> jwtPublickeyPemUrl) {
        return jwtPublickeyPemUrl.map(Throwing.function(url -> FileUtils.readFileToString((File)fileSystem.getFile(url), (Charset)StandardCharsets.US_ASCII)));
    }

    @Provides
    @Singleton
    public AuthenticationFilter providesAuthenticationFilter(PropertiesProvider propertiesProvider, @Named(value="webadmin") JwtTokenVerifier.Factory jwtTokenVerifier) throws Exception {
        try {
            Configuration configurationFile = propertiesProvider.getConfiguration("webadmin");
            if (configurationFile.getBoolean("jwt.enabled", false)) {
                return new JwtFilter(jwtTokenVerifier);
            }
            return new NoAuthenticationFilter();
        }
        catch (FileNotFoundException e) {
            return new NoAuthenticationFilter();
        }
    }

    @Provides
    @Singleton
    @Named(value="webadmin")
    JwtTokenVerifier.Factory providesJwtTokenVerifier(WebAdminConfiguration webAdminConfiguration, @Named(value="jmap") Provider<JwtTokenVerifier> jmapTokenVerifier) {
        return () -> webAdminConfiguration.getJwtPublicKey().map(keyPath -> new JwtConfiguration((List)ImmutableList.of((Object)keyPath))).map(JwtTokenVerifier::create).orElseGet(() -> ((Provider)jmapTokenVerifier).get());
    }

    private Optional<TlsConfiguration> readHttpsConfiguration(Configuration configurationFile) {
        boolean enabled = configurationFile.getBoolean("https.enabled", false);
        if (enabled) {
            return Optional.of(TlsConfiguration.builder().raw(configurationFile.getString("https.keystore", DEFAULT_NO_KEYSTORE), configurationFile.getString("https.password", DEFAULT_NO_PASSWORD), configurationFile.getString("https.trust.keystore", DEFAULT_NO_TRUST_KEYSTORE), configurationFile.getString("https.trust.password", DEFAULT_NO_TRUST_PASSWORD)).build());
        }
        return Optional.empty();
    }

    @ProvidesIntoSet
    InitializationOperation workQueue(WebAdminServer instance) {
        return InitilizationOperationBuilder.forClass(WebAdminServer.class).init(() -> ((WebAdminServer)instance).start());
    }
}

