/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.memory;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.History$;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e4AAC\u0006\u00011!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB$\u0001A\u0003%\u0011\u0006C\u0003I\u0001\u0011\u0005\u0013\nC\u0003e\u0001\u0011\u0005S\rC\u0003j\u0001\u0011%!\u000eC\u0003p\u0001\u0011%\u0001\u000fC\u0003s\u0001\u0011%1\u000fC\u0003w\u0001\u0011\u0005sO\u0001\nJ]6+Wn\u001c:z\u000bZ,g\u000e^*u_J,'B\u0001\u0007\u000e\u0003\u0019iW-\\8ss*\u0011abD\u0001\u000bKZ,g\u000e^:u_J,'B\u0001\t\u0012\u00035)g/\u001a8ug>,(oY5oO*\u0011!cE\u0001\u0006U\u0006lWm\u001d\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!D\u0005\u0003E5\u0011!\"\u0012<f]R\u001cFo\u001c:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t1\"\u0001\u0005ti>\u0014XMU3g+\u0005I\u0003c\u0001\u00164k5\t1F\u0003\u0002-[\u00051\u0011\r^8nS\u000eT!AL\u0018\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00021c\u0005!Q\u000f^5m\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0016\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004BAN\u001fA\t:\u0011qg\u000f\t\u0003qmi\u0011!\u000f\u0006\u0003u]\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0004\u001b\u0006\u0004(B\u0001\u001f\u001c!\t\t%)D\u0001\u0010\u0013\t\u0019uBA\u0006BO\u001e\u0014XmZ1uK&#\u0007C\u0001\u0011F\u0013\t1UBA\u0004ISN$xN]=\u0002\u0013M$xN]3SK\u001a\u0004\u0013!C1qa\u0016tG-\u00117m)\tQe\u000bE\u0002L\u001dBk\u0011\u0001\u0014\u0006\u0003\u001bV\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0003\u001f2\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005E#V\"\u0001*\u000b\u0005M\u000b\u0014\u0001\u00027b]\u001eL!!\u0016*\u0003\tY{\u0017\u000e\u001a\u0005\u0006/\u0012\u0001\r\u0001W\u0001\u0007KZ,g\u000e^:\u0011\u0007es\u0016M\u0004\u0002[9:\u0011\u0001hW\u0005\u00029%\u0011QlG\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\ti6\u0004\u0005\u0002BE&\u00111m\u0004\u0002\u0006\u000bZ,g\u000e^\u0001\u0015O\u0016$XI^3oiN|e-Q4he\u0016<\u0017\r^3\u0015\u0005\u0019<\u0007cA&O\t\")\u0001.\u0002a\u0001\u0001\u0006Y\u0011mZ4sK\u001e\fG/Z%e\u0003-!w.\u00119qK:$\u0017\t\u001c7\u0015\u0005-t\u0007C\u0001\u000em\u0013\ti7DA\u0004C_>dW-\u00198\t\u000b]3\u0001\u0019\u0001-\u0002\u001d\u001d,G/Q4he\u0016<\u0017\r^3JIR\u0011\u0001)\u001d\u0005\u0006/\u001e\u0001\r\u0001W\u0001\u0017E\u0016dwN\\4t)>\u001c\u0016-\\3BO\u001e\u0014XmZ1uKR\u00191\u000e^;\t\u000b!D\u0001\u0019\u0001!\t\u000b]C\u0001\u0019\u0001-\u0002\rI,Wn\u001c<f)\tQ\u0005\u0010C\u0003i\u0013\u0001\u0007\u0001\t")
public class InMemoryEventStore
implements EventStore {
    private final AtomicReference<Map<AggregateId, History>> storeRef;

    public Publisher<Void> append(Event event) {
        return EventStore.append$((EventStore)this, (Event)event);
    }

    public Publisher<Void> appendAll(Seq<Event> events) {
        return EventStore.appendAll$((EventStore)this, events);
    }

    public Publisher<Void> appendAll(Event ... events) {
        return EventStore.appendAll$((EventStore)this, (Event[])events);
    }

    private AtomicReference<Map<AggregateId, History>> storeRef() {
        return this.storeRef;
    }

    public Publisher<Void> appendAll(Iterable<Event> events) {
        if (events.nonEmpty()) {
            return package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)SMono$.MODULE$.fromCallable(() -> BoxesRunTime.boxToBoolean((boolean)this.doAppendAll((Iterable<Event>)events))).then());
        }
        return SMono$.MODULE$.empty();
    }

    public Publisher<History> getEventsOfAggregate(AggregateId aggregateId) {
        Preconditions.checkNotNull((Object)aggregateId);
        return SMono$.MODULE$.fromCallable(() -> (History)((MapOps)this.storeRef().get()).apply((Object)aggregateId));
    }

    private boolean doAppendAll(Iterable<Event> events) {
        AggregateId aggregateId = this.getAggregateId(events);
        this.storeRef().updateAndGet(store -> {
            History updatedHistory = History$.MODULE$.of((List)((History)store.apply((Object)aggregateId)).getEvents().$plus$plus((IterableOnce)events));
            return (Map)store.updated((Object)aggregateId, (Object)updatedHistory);
        });
        return true;
    }

    private AggregateId getAggregateId(Iterable<Event> events) {
        Preconditions.checkArgument((boolean)events.nonEmpty());
        AggregateId aggregateId = ((Event)events.head()).getAggregateId();
        Preconditions.checkArgument((boolean)this.belongsToSameAggregate(aggregateId, events));
        return aggregateId;
    }

    private boolean belongsToSameAggregate(AggregateId aggregateId, Iterable<Event> events) {
        return events.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InMemoryEventStore.$anonfun$belongsToSameAggregate$1(aggregateId, x$2)));
    }

    public Publisher<Void> remove(AggregateId aggregateId) {
        return package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)SMono$.MODULE$.fromCallable(() -> {
            InMemoryEventStore.$anonfun$remove$1(this, aggregateId);
            return BoxedUnit.UNIT;
        }).then());
    }

    public static final /* synthetic */ boolean $anonfun$belongsToSameAggregate$1(AggregateId aggregateId$3, Event x$2) {
        return x$2.getAggregateId().equals(aggregateId$3);
    }

    public static final /* synthetic */ void $anonfun$remove$1(InMemoryEventStore $this, AggregateId aggregateId$4) {
        $this.storeRef().set((Map<AggregateId, History>)((scala.collection.immutable.MapOps)$this.storeRef().get()).removed((Object)aggregateId$4));
    }

    public InMemoryEventStore() {
        EventStore.$init$((EventStore)this);
        this.storeRef = new AtomicReference<Map>(((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).withDefault((Function1 & Serializable)x$1 -> History$.MODULE$.empty()));
    }
}

