/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.MoreObjects;
import jakarta.inject.Inject;
import java.util.Objects;
import org.apache.james.backends.cassandra.components.CassandraQuotaLimitTable;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaLimit;
import org.apache.james.core.quota.QuotaScope;
import org.apache.james.core.quota.QuotaType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraQuotaLimitDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement getQuotaLimitStatement;
    private final PreparedStatement getQuotaLimitsStatement;
    private final PreparedStatement setQuotaLimitStatement;
    private final PreparedStatement deleteQuotaLimitStatement;

    @Inject
    public CassandraQuotaLimitDao(CqlSession session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.getQuotaLimitStatement = session.prepare(this.getQuotaLimitStatement().build());
        this.getQuotaLimitsStatement = session.prepare(this.getQuotaLimitsStatement().build());
        this.setQuotaLimitStatement = session.prepare(this.setQuotaLimitStatement().build());
        this.deleteQuotaLimitStatement = session.prepare(this.deleteQuotaLimitStatement().build());
    }

    public Mono<QuotaLimit> getQuotaLimit(QuotaLimitKey quotaKey) {
        return this.queryExecutor.executeSingleRow((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.getQuotaLimitStatement.bind(new Object[0]).setString(CassandraQuotaLimitTable.QUOTA_COMPONENT, quotaKey.getQuotaComponent().getValue())).setString(CassandraQuotaLimitTable.QUOTA_SCOPE, quotaKey.getQuotaScope().getValue())).setString(CassandraQuotaLimitTable.IDENTIFIER, quotaKey.getIdentifier())).setString(CassandraQuotaLimitTable.QUOTA_TYPE, quotaKey.getQuotaType().getValue())).map(this::convertRowToModel);
    }

    public Flux<QuotaLimit> getQuotaLimits(QuotaComponent quotaComponent, QuotaScope quotaScope, String identifier) {
        return this.queryExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.getQuotaLimitsStatement.bind(new Object[0]).setString(CassandraQuotaLimitTable.QUOTA_COMPONENT, quotaComponent.getValue())).setString(CassandraQuotaLimitTable.QUOTA_SCOPE, quotaScope.getValue())).setString(CassandraQuotaLimitTable.IDENTIFIER, identifier)).map(this::convertRowToModel);
    }

    public Mono<Void> setQuotaLimit(QuotaLimit quotaLimit) {
        return this.queryExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.setQuotaLimitStatement.bind(new Object[0]).setString(CassandraQuotaLimitTable.QUOTA_COMPONENT, quotaLimit.getQuotaComponent().getValue())).setString(CassandraQuotaLimitTable.QUOTA_SCOPE, quotaLimit.getQuotaScope().getValue())).setString(CassandraQuotaLimitTable.IDENTIFIER, quotaLimit.getIdentifier())).setString(CassandraQuotaLimitTable.QUOTA_TYPE, quotaLimit.getQuotaType().getValue())).set(CassandraQuotaLimitTable.QUOTA_LIMIT, (Object)quotaLimit.getQuotaLimit().orElse(null), Long.class));
    }

    public Mono<Void> deleteQuotaLimit(QuotaLimitKey quotaKey) {
        return this.queryExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.deleteQuotaLimitStatement.bind(new Object[0]).setString(CassandraQuotaLimitTable.QUOTA_COMPONENT, quotaKey.getQuotaComponent().getValue())).setString(CassandraQuotaLimitTable.QUOTA_SCOPE, quotaKey.getQuotaScope().getValue())).setString(CassandraQuotaLimitTable.IDENTIFIER, quotaKey.getIdentifier())).setString(CassandraQuotaLimitTable.QUOTA_TYPE, quotaKey.getQuotaType().getValue()));
    }

    private Select getQuotaLimitStatement() {
        return (Select)QueryBuilder.selectFrom((String)"quotaLimit").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_TYPE)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE))});
    }

    private Select getQuotaLimitsStatement() {
        return (Select)QueryBuilder.selectFrom((String)"quotaLimit").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE))});
    }

    private Insert setQuotaLimitStatement() {
        return QueryBuilder.insertInto((String)"quotaLimit").value(CassandraQuotaLimitTable.IDENTIFIER, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER)).value(CassandraQuotaLimitTable.QUOTA_COMPONENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT)).value(CassandraQuotaLimitTable.QUOTA_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_TYPE)).value(CassandraQuotaLimitTable.QUOTA_SCOPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE)).value(CassandraQuotaLimitTable.QUOTA_LIMIT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_LIMIT));
    }

    private Delete deleteQuotaLimitStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"quotaLimit").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.IDENTIFIER)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_COMPONENT)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_TYPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_TYPE)), (Relation)Relation.column((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraQuotaLimitTable.QUOTA_SCOPE))});
    }

    private QuotaLimit convertRowToModel(Row row) {
        return QuotaLimit.builder().quotaComponent(QuotaComponent.of((String)((String)row.get(CassandraQuotaLimitTable.QUOTA_COMPONENT, String.class)))).quotaScope(QuotaScope.of((String)((String)row.get(CassandraQuotaLimitTable.QUOTA_SCOPE, String.class)))).identifier((String)row.get(CassandraQuotaLimitTable.IDENTIFIER, String.class)).quotaType(QuotaType.of((String)((String)row.get(CassandraQuotaLimitTable.QUOTA_TYPE, String.class)))).quotaLimit((Long)row.get(CassandraQuotaLimitTable.QUOTA_LIMIT, Long.class)).build();
    }

    public static class QuotaLimitKey {
        private final QuotaComponent quotaComponent;
        private final QuotaScope quotaScope;
        private final String identifier;
        private final QuotaType quotaType;

        public static QuotaLimitKey of(QuotaComponent component, QuotaScope scope, String identifier, QuotaType quotaType) {
            return new QuotaLimitKey(component, scope, identifier, quotaType);
        }

        public QuotaComponent getQuotaComponent() {
            return this.quotaComponent;
        }

        public QuotaScope getQuotaScope() {
            return this.quotaScope;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public QuotaType getQuotaType() {
            return this.quotaType;
        }

        private QuotaLimitKey(QuotaComponent quotaComponent, QuotaScope quotaScope, String identifier, QuotaType quotaType) {
            this.quotaComponent = quotaComponent;
            this.quotaScope = quotaScope;
            this.identifier = identifier;
            this.quotaType = quotaType;
        }

        public final int hashCode() {
            return Objects.hash(this.quotaComponent, this.quotaScope, this.identifier, this.quotaType);
        }

        public final boolean equals(Object o) {
            if (o instanceof QuotaLimitKey) {
                QuotaLimitKey other = (QuotaLimitKey)o;
                return Objects.equals(this.quotaComponent, other.quotaComponent) && Objects.equals(this.quotaScope, other.quotaScope) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.quotaType, other.quotaType);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("quotaComponent", (Object)this.quotaComponent).add("quotaScope", (Object)this.quotaScope).add("identifier", (Object)this.identifier).add("quotaType", (Object)this.quotaType).toString();
        }
    }
}

