/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.components;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.components.CassandraQuotaCurrentValueTable;
import org.apache.james.backends.cassandra.components.CassandraQuotaLimitTable;

public interface CassandraMutualizedQuotaModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("quotaLimit").comment("Holds quota limits.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraQuotaLimitTable.QUOTA_SCOPE, DataTypes.TEXT).withPartitionKey(CassandraQuotaLimitTable.IDENTIFIER, DataTypes.TEXT).withClusteringColumn(CassandraQuotaLimitTable.QUOTA_COMPONENT, DataTypes.TEXT).withClusteringColumn(CassandraQuotaLimitTable.QUOTA_TYPE, DataTypes.TEXT).withColumn(CassandraQuotaLimitTable.QUOTA_LIMIT, DataTypes.BIGINT)).table("quotaCurrentValue").comment("Holds quota current values.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraQuotaCurrentValueTable.IDENTIFIER, DataTypes.TEXT).withClusteringColumn(CassandraQuotaCurrentValueTable.QUOTA_COMPONENT, DataTypes.TEXT).withClusteringColumn(CassandraQuotaCurrentValueTable.QUOTA_TYPE, DataTypes.TEXT).withColumn(CassandraQuotaCurrentValueTable.CURRENT_VALUE, DataTypes.COUNTER)).build();
}

