/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.api.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;

public class MockMatcher
implements Matcher {
    private int matchCount = 0;
    private MatcherConfig config;

    public void destroy() {
    }

    public MatcherConfig getMatcherConfig() {
        return this.config;
    }

    public String getMatcherInfo() {
        return this.getClass().getName();
    }

    public void init(MatcherConfig config) {
        this.config = config;
        this.matchCount = Integer.parseInt(config.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) {
        ArrayList<MailAddress> match = new ArrayList<MailAddress>();
        Iterator rcpts = mail.getRecipients().iterator();
        while (rcpts.hasNext() && match.size() < this.matchCount) {
            MailAddress addr = (MailAddress)rcpts.next();
            match.add(addr);
        }
        if (match.isEmpty()) {
            return null;
        }
        return match;
    }
}

