/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt.introspection;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.jwt.DefaultCheckTokenClient;
import org.apache.james.jwt.introspection.IntrospectionEndpoint;
import org.apache.james.jwt.introspection.TokenIntrospectionException;
import org.apache.james.jwt.introspection.TokenIntrospectionResponse;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.verify.VerificationTimes;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DefaultCheckTokenClientTest {
    private static final String INTROSPECTION_TOKEN_URI_PATH = "/token/introspect";
    private ClientAndServer mockServer;

    @BeforeEach
    public void setUp() {
        this.mockServer = ClientAndServer.startClientAndServer((Integer[])new Integer[]{0});
    }

    @AfterEach
    void tearDown() {
        this.mockServer.stop();
    }

    private IntrospectionEndpoint getIntrospectionTokenEndpoint() {
        try {
            return new IntrospectionEndpoint(new URI(String.format("http://127.0.0.1:%s%s", this.mockServer.getLocalPort(), INTROSPECTION_TOKEN_URI_PATH)).toURL(), Optional.empty());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private DefaultCheckTokenClient testee() {
        return new DefaultCheckTokenClient();
    }

    private void updateMockerServerSpecifications(String response, int statusResponse) {
        this.mockServer.when((RequestDefinition)HttpRequest.request().withPath(INTROSPECTION_TOKEN_URI_PATH)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(statusResponse)).withHeader("Content-Type", new String[]{"application/json"}).withBody(response, StandardCharsets.UTF_8));
    }

    @Test
    void introspectShouldSuccessWhenValidRequest() {
        String activeResponse = "{    \"exp\": 1652868271,    \"nbf\": 0,    \"iat\": 1652867971,    \"jti\": \"41ee3cc3-b908-4870-bff2-34b895b9fadf\",    \"aud\": \"account\",    \"typ\": \"Bearer\",    \"acr\": \"1\",    \"scope\": \"email\",    \"active\": true}";
        this.updateMockerServerSpecifications(activeResponse, 200);
        TokenIntrospectionResponse introspectionResponse = (TokenIntrospectionResponse)Mono.from((Publisher)this.testee().introspect(this.getIntrospectionTokenEndpoint(), "abc")).block();
        Assertions.assertThat((Object)introspectionResponse).isNotNull();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(introspectionResponse.active()).isTrue();
            softly.assertThat(introspectionResponse.scope()).isEqualTo(Optional.of("email"));
            JsonAssertions.assertThatJson((Object)introspectionResponse.json().toString()).isEqualTo((Object)activeResponse);
            softly.assertThat(introspectionResponse.exp()).isEqualTo(Optional.of(1652868271));
            softly.assertThat(introspectionResponse.nbf()).isEqualTo(Optional.of(0));
            softly.assertThat(introspectionResponse.iat()).isEqualTo(Optional.of(1652867971));
            softly.assertThat(introspectionResponse.jti()).isEqualTo(Optional.of("41ee3cc3-b908-4870-bff2-34b895b9fadf"));
            softly.assertThat(introspectionResponse.aud()).isEqualTo(Optional.of("account"));
            softly.assertThat(introspectionResponse.iss()).isEmpty();
            softly.assertThat(introspectionResponse.sub()).isEmpty();
        });
    }

    @Test
    void introspectShouldPostValidRequest() {
        String activeResponse = "{    \"exp\": 1652868271,    \"nbf\": 0,    \"iat\": 1652867971,    \"jti\": \"41ee3cc3-b908-4870-bff2-34b895b9fadf\",    \"aud\": \"account\",    \"typ\": \"Bearer\",    \"acr\": \"1\",    \"scope\": \"email\",    \"active\": true}";
        this.updateMockerServerSpecifications(activeResponse, 200);
        Mono.from((Publisher)this.testee().introspect(this.getIntrospectionTokenEndpoint(), "abc")).block();
        this.mockServer.verify((RequestDefinition)HttpRequest.request().withPath(INTROSPECTION_TOKEN_URI_PATH).withMethod("POST").withHeader("Accept", new String[]{"application/json"}).withHeader("Content-Type", new String[]{"application/x-www-form-urlencoded"}).withBody("token=abc"), VerificationTimes.atLeast((int)1));
    }

    @Test
    void introspectShouldFailWhenNotAuthorized() {
        String serverResponse = "{    \"error\": \"invalid_request\",    \"error_description\": \"Authentication failed.\"}";
        this.updateMockerServerSpecifications(serverResponse, 401);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Mono.from((Publisher)this.testee().introspect(this.getIntrospectionTokenEndpoint(), "abc")).block()).isInstanceOf(TokenIntrospectionException.class)).hasMessageContaining("Authentication failed").hasMessageContaining("401");
    }

    @Test
    void introspectShouldFailWhenCanNotDeserializeResponse() {
        String serverResponse = "invalid";
        this.updateMockerServerSpecifications(serverResponse, 200);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Mono.from((Publisher)this.testee().introspect(this.getIntrospectionTokenEndpoint(), "abc")).block()).isInstanceOf(TokenIntrospectionException.class)).hasMessageContaining("Error when introspecting token");
    }

    @Test
    void introspectShouldFailWhenResponseMissingActiveProperty() {
        String serverResponse = "{    \"exp\": 1652868271,    \"nbf\": 0,    \"iat\": 1652867971,    \"jti\": \"41ee3cc3-b908-4870-bff2-34b895b9fadf\",    \"aud\": \"account\",    \"typ\": \"Bearer\",    \"acr\": \"1\",    \"scope\": \"email\"}";
        this.updateMockerServerSpecifications(serverResponse, 200);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Mono.from((Publisher)this.testee().introspect(this.getIntrospectionTokenEndpoint(), "abc")).block()).isInstanceOf(TokenIntrospectionException.class)).hasMessageContaining("Error when introspecting token");
    }

    @Test
    void introspectShouldReturnUpdatedResponse() {
        String activeResponse = "{    \"active\": true}";
        this.updateMockerServerSpecifications(activeResponse, 200);
        DefaultCheckTokenClient testee = this.testee();
        String token = "token1bc";
        ((ObjectAssert)Assertions.assertThat((Object)((TokenIntrospectionResponse)Mono.from((Publisher)testee.introspect(this.getIntrospectionTokenEndpoint(), token)).block())).isNotNull()).satisfies(new ThrowingConsumer[]{x -> Assertions.assertThat((boolean)x.active()).isTrue()});
        String updatedResponse = "{    \"active\": false}";
        this.mockServer.reset();
        this.updateMockerServerSpecifications(updatedResponse, 200);
        ((ObjectAssert)Assertions.assertThat((Object)((TokenIntrospectionResponse)Mono.from((Publisher)testee.introspect(this.getIntrospectionTokenEndpoint(), token)).block())).isNotNull()).satisfies(new ThrowingConsumer[]{x -> Assertions.assertThat((boolean)x.active()).isFalse()});
    }
}

