/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import org.apache.james.jwt.PublicKeyReader;
import org.assertj.core.api.Assertions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class PublicKeyReaderTest {
    private static final String PUBLIC_PEM_KEY = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtlChO/nlVP27MpdkG0Bh\n16XrMRf6M4NeyGa7j5+1UKm42IKUf3lM28oe82MqIIRyvskPc11NuzSor8HmvH8H\nlhDs5DyJtx2qp35AT0zCqfwlaDnlDc/QDlZv1CoRZGpQk1Inyh6SbZwYpxxwh0fi\n+d/4RpE3LBVo8wgOaXPylOlHxsDizfkL8QwXItyakBfMO6jWQRrj7/9WDhGf4Hi+\nGQur1tPGZDl9mvCoRHjFrD5M/yypIPlfMGWFVEvV5jClNMLAQ9bYFuOc7H1fEWw6\nU1LZUUbJW9/CH45YXz82CYqkrfbnQxqRb2iVbVjs/sHopHd1NTiCfUtwvcYJiBVj\nkwIDAQAB\n-----END PUBLIC KEY-----";

    PublicKeyReaderTest() {
    }

    @BeforeAll
    static void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Test
    void fromPEMShouldReturnEmptyWhenInvalidPEMKey() {
        Assertions.assertThat((Optional)new PublicKeyReader().fromPEM("blabla")).isEmpty();
    }

    @Test
    void fromPEMShouldReturnRSAPublicKeyWhenValidPEMKey() {
        Assertions.assertThat((Optional)new PublicKeyReader().fromPEM(PUBLIC_PEM_KEY)).isPresent();
    }
}

