/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.collect.ImmutableList;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.Optional;
import org.apache.james.jwt.DefaultPublicKeyProvider;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.PublicKeyReader;
import org.assertj.core.api.Assertions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JwtTokenVerifierTest {
    private static final String PUBLIC_PEM_KEY = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtlChO/nlVP27MpdkG0Bh\n16XrMRf6M4NeyGa7j5+1UKm42IKUf3lM28oe82MqIIRyvskPc11NuzSor8HmvH8H\nlhDs5DyJtx2qp35AT0zCqfwlaDnlDc/QDlZv1CoRZGpQk1Inyh6SbZwYpxxwh0fi\n+d/4RpE3LBVo8wgOaXPylOlHxsDizfkL8QwXItyakBfMO6jWQRrj7/9WDhGf4Hi+\nGQur1tPGZDl9mvCoRHjFrD5M/yypIPlfMGWFVEvV5jClNMLAQ9bYFuOc7H1fEWw6\nU1LZUUbJW9/CH45YXz82CYqkrfbnQxqRb2iVbVjs/sHopHd1NTiCfUtwvcYJiBVj\nkwIDAQAB\n-----END PUBLIC KEY-----";
    public static final String PUBLIC_PEM_KEY_2 = "-----BEGIN PUBLIC KEY-----\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVnxAOpup/rtGzn+xUaBRFSe34\nH7YyiM6YBD1bh5rkoi9pB6fvs1vDlXzBmR0Zl6kn3g+2ChW0lqMkmv73Y2Lv3WZK\nNZ3DUR3lfBFbvYGQyFyib+e4MY1yWkj3sumMl1wdUB4lKLHLIRv9X1xCqvbSHEtq\nzoZF4vgBYx0VmuJslwIDAQAB\n-----END PUBLIC KEY-----";
    private static final String VALID_TOKEN_WITHOUT_ADMIN = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIn0.T04BTkLXkJj24coSZkK13RfG25lpvmSl2MJ7N10KpBk9_-95EGYZdog-BDAn3PJzqVw52z-Bwjh4VOj1-j7cURu0cT4jXehhUrlCxS4n7QHZDN_bsEYGu7KzjWTpTsUiHe-rN7izXVFxDGG1TGwlmBCBnPW-EFCf9ylUsJi0r2BKNdaaPRfMIrHptH1zJBkkUziWpBN1RNLjmvlAUf49t1Tbv21ZqYM5Ht2vrhJWczFbuC-TD-8zJkXhjTmA1GVgomIX5dx1cH-dZX1wANNmshUJGHgepWlPU-5VIYxPEhb219RMLJIELMY2qNOR8Q31ydinyqzXvCSzVJOf6T60-w";
    private static final String VALID_TOKEN_ADMIN_TRUE = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJhZG1pbkBvcGVuLXBhYXMub3JnIiwiYWRtaW4iOnRydWUsImlhdCI6MTQ4OTAzODQzOH0.rgxCkdWEa-92a4R-72a9Z49k4LRvQDShgci5Y7qWRUP9IGJCK-lMkrHF4H0a6L87BYppxVW701zaZ6dNxRMvHnjLBBWnPsC2B0rkkr2hEL2zfz7sb-iNGV-J4ICx97t8-TfQ5rz3VOX0FwdusPL_rJtmlGEGRivPkR6_aBe1kQnvMlwpqF_3ox58EUqYJk6lK_6rjKEV3Xfre31IMpuQUy6c7TKc95sL2-13cknelTierBEmZ00RzTtv9SHIEfzZTfaUK2Wm0PvnQjmU2nIdEvUEqE-jrM3yYXcQzoO-YTQnEhdl-iqbCfmEpYkl2Bx3eIq7gRxxnr7BPsX6HrCB0w";
    private static final String VALID_TOKEN_ADMIN_FALSE = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJhZG1pbkBvcGVuLXBhYXMub3JnIiwiYWRtaW4iOmZhbHNlLCJpYXQiOjE0ODkwNDA4Njd9.reQc3DiVvbQHF08oW1qOUyDJyv3tfzDNk8jhVZequiCdOI9vXnRlOe-yDYktd4WT8MYhqY7MgS-wR0vO9jZFv8ZCgd_MkKCvCO0HmMjP5iQPZ0kqGkgWUH7X123tfR38MfbCVAdPDba-K3MfkogV1xvDhlkPScFr_6MxExtedOK2JnQZn7t9sUzSrcyjWverm7gZkPptkIVoS8TsEeMMME5vFXe_nqkEG69q3kuBUm_33tbR5oNS0ZGZKlG9r41lHBjyf9J1xN4UYV8n866da7RPPCzshIWUtO0q9T2umWTnp-6OnOdBCkndrZmRR6pPxsD5YL0_77Wq8KT_5__fGA";
    private static final String TOKEN_NONE_ALGORITHM = "eyJhbGciOiJub25lIiwidHlwIjoiSldUIn0.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWV9.2XijNOVI9LXP9nWf-oj2SEWWNlcwmxzlQNGK1WdaWcQ";
    private static final String TOKEN_NONE_ALGORITHM_NO_SIGNATURE = "eyJhbGciOiJub25lIiwidHlwIjoiSldUIn0.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWV9.";
    private JwtTokenVerifier sut;

    JwtTokenVerifierTest() {
    }

    @BeforeAll
    static void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @BeforeEach
    void setup() {
        DefaultPublicKeyProvider pubKeyProvider = new DefaultPublicKeyProvider(new JwtConfiguration((List)ImmutableList.of((Object)PUBLIC_PEM_KEY)), new PublicKeyReader());
        this.sut = new JwtTokenVerifier((PublicKeyProvider)pubKeyProvider);
    }

    @Test
    void shouldReturnTrueOnValidSignature() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(VALID_TOKEN_WITHOUT_ADMIN)).isPresent();
    }

    @Test
    void verifyAndExtractClaimShouldAllowExtractingClaim() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractClaim(VALID_TOKEN_WITHOUT_ADMIN, "name", String.class)).contains((Object)"John Doe");
    }

    @Test
    void verifyAndExtractClaimShouldReturnEmptyWhenBadDatatype() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractClaim(VALID_TOKEN_WITHOUT_ADMIN, "name", Integer.class)).isEmpty();
    }

    @Test
    void verifyAndExtractClaimShouldReturnEmptyWhenNotFound() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractClaim(VALID_TOKEN_WITHOUT_ADMIN, "notFound", String.class)).isEmpty();
    }

    @Test
    void verifyAndExtractClaimShouldReturnEmptyWhenNoneAlgorithm() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractClaim(TOKEN_NONE_ALGORITHM, "name", String.class)).isEmpty();
    }

    @Test
    void verifyAndExtractLoginShouldReturnEmptyOnMismatchingSigningKey() {
        String invalidToken = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIn0.Pd6t82tPL3EZdkeYxw_DV2KimE1U2FvuLHmfR_mimJ5US3JFU4J2Gd94O7rwpSTGN1B9h-_lsTebo4ua4xHsTtmczZ9xa8a_kWKaSkqFjNFaFp6zcoD6ivCu03SlRqsQzSRHXo6TKbnqOt9D6Y2rNa3C4igSwoS0jUE4BgpXbc0";
        Assertions.assertThat((Optional)this.sut.verifyAndExtractClaim(invalidToken, "name", String.class)).isEmpty();
    }

    @Test
    void shouldReturnTrueOnValidSignatureWithMultipleKeys() {
        DefaultPublicKeyProvider pubKeyProvider = new DefaultPublicKeyProvider(new JwtConfiguration((List)ImmutableList.of((Object)PUBLIC_PEM_KEY_2, (Object)PUBLIC_PEM_KEY)), new PublicKeyReader());
        JwtTokenVerifier sut = new JwtTokenVerifier((PublicKeyProvider)pubKeyProvider);
        Assertions.assertThat((Optional)sut.verifyAndExtractLogin(VALID_TOKEN_WITHOUT_ADMIN)).isPresent();
    }

    @Test
    void shouldReturnFalseOnMismatchingSigningKey() {
        String invalidToken = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIn0.Pd6t82tPL3EZdkeYxw_DV2KimE1U2FvuLHmfR_mimJ5US3JFU4J2Gd94O7rwpSTGN1B9h-_lsTebo4ua4xHsTtmczZ9xa8a_kWKaSkqFjNFaFp6zcoD6ivCu03SlRqsQzSRHXo6TKbnqOt9D6Y2rNa3C4igSwoS0jUE4BgpXbc0";
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(invalidToken)).isEmpty();
    }

    @Test
    void shouldReturnFalseOnMismatchingSigningKeyWithMultipleKeys() {
        String invalidToken = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIn0.Pd6t82tPL3EZdkeYxw_DV2KimE1U2FvuLHmfR_mimJ5US3JFU4J2Gd94O7rwpSTGN1B9h-_lsTebo4ua4xHsTtmczZ9xa8a_kWKaSkqFjNFaFp6zcoD6ivCu03SlRqsQzSRHXo6TKbnqOt9D6Y2rNa3C4igSwoS0jUE4BgpXbc0";
        DefaultPublicKeyProvider pubKeyProvider = new DefaultPublicKeyProvider(new JwtConfiguration((List)ImmutableList.of((Object)PUBLIC_PEM_KEY_2, (Object)PUBLIC_PEM_KEY)), new PublicKeyReader());
        JwtTokenVerifier sut = new JwtTokenVerifier((PublicKeyProvider)pubKeyProvider);
        Assertions.assertThat((Optional)sut.verifyAndExtractLogin(invalidToken)).isEmpty();
    }

    @Test
    void verifyShouldReturnFalseWhenSubjectIsNull() {
        String tokenWithNullSubject = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOm51bGwsIm5hbWUiOiJKb2huIERvZSJ9.EB_1grWDy_kFelXs3AQeiP13ay4eG_134dWB9XPRSeWsuPs8Mz2UY-VHDxLGD-fAqv-xKXr4QFEnS7iZkdpe0tPLNSwIjqeqkC6KqQlnoC1okqWVWBDOcf7Acp1Jzp_cFTUhL5LkHvZDsyCdq5T9OOVVkzO4A9RrzIUsTrYPtRCBuYJ3ggR33cKpw191PulPGNH70rZqpUfDXeVPY3q15vWzZH9O9IJzB2KdHRMPxl2luRjzDbh4DLp56NhZuLX_2a9UAlmbV8MQX4Z_04ybhAYrcBfxR3MgJyr0jlxSibqSbXrkXuo-PyybfZCIhK_qXUlO5OS6sO7AQhKZO9p0MQ";
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(tokenWithNullSubject)).isEmpty();
    }

    @Test
    void verifyShouldReturnFalseWhenEmptySubject() {
        String tokenWithEmptySubject = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIiLCJuYW1lIjoiSm9obiBEb2UifQ.UdYs2PPzFCegUYspoDCnlJR_bJm8_z1InOv4v3tq8SJETQUarOXlhb_n6y6ujVvmJiSx9dI24Hc3Czi3RGUOXbnBDj1WPfd0aVSiUSqZrMCHBt5vjCYqAseDaP3w4aiiFb6EV3tteJFeBLZx8XlKPYxlzRLLUADDyDSQvrFBBPxfsvCETZovKdo9ofIN64o-yx23ss63yE6oIOdzJZ1Id40KSR2d7l3kIQJPLKUWJDnro5RAh4DOGOWNSq0JSbMhk7Zn3cXIBUpv3R8p79tui1UQpzwHMC0e6OSuWEDNQHtq-Cz85u8GGsUSbogmgObA_BimNtUq_Q1p0SGtIYBXmQ";
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(tokenWithEmptySubject)).isEmpty();
    }

    @Test
    void verifyShouldNotAcceptNoneAlgorithm() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(TOKEN_NONE_ALGORITHM)).isEmpty();
    }

    @Test
    void verifyShouldNotAcceptNoneAlgorithmWithoutSignature() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(TOKEN_NONE_ALGORITHM_NO_SIGNATURE)).isEmpty();
    }

    @Test
    void shouldReturnUserLoginFromValidToken() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(VALID_TOKEN_WITHOUT_ADMIN)).contains((Object)"1234567890");
    }

    @Test
    void hasAttributeShouldReturnFalseOnNoneAlgorithm() throws Exception {
        boolean authorized = this.sut.hasAttribute("admin", (Object)true, TOKEN_NONE_ALGORITHM);
        Assertions.assertThat((boolean)authorized).isFalse();
    }

    @Test
    void hasAttributeShouldReturnFalseOnNoneAlgorithmWithoutSignature() throws Exception {
        boolean authorized = this.sut.hasAttribute("admin", (Object)true, TOKEN_NONE_ALGORITHM_NO_SIGNATURE);
        Assertions.assertThat((boolean)authorized).isFalse();
    }

    @Test
    void hasAttributeShouldReturnTrueIfClaimValid() throws Exception {
        boolean authorized = this.sut.hasAttribute("admin", (Object)true, VALID_TOKEN_ADMIN_TRUE);
        Assertions.assertThat((boolean)authorized).isTrue();
    }

    @Test
    void extractLoginShouldWorkWithAdminClaim() {
        Assertions.assertThat((Optional)this.sut.verifyAndExtractLogin(VALID_TOKEN_ADMIN_TRUE)).contains((Object)"admin@open-paas.org");
    }

    @Test
    void hasAttributeShouldThrowIfClaimInvalid() throws Exception {
        boolean authorized = this.sut.hasAttribute("admin", (Object)true, VALID_TOKEN_ADMIN_FALSE);
        Assertions.assertThat((boolean)authorized).isFalse();
    }
}

