/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.jwt.JwtConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JwtConfigurationTest {
    private static final String INVALID_PUBLIC_KEY = "invalidPublicKey";
    private static final String VALID_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtlChO/nlVP27MpdkG0Bh\n16XrMRf6M4NeyGa7j5+1UKm42IKUf3lM28oe82MqIIRyvskPc11NuzSor8HmvH8H\nlhDs5DyJtx2qp35AT0zCqfwlaDnlDc/QDlZv1CoRZGpQk1Inyh6SbZwYpxxwh0fi\n+d/4RpE3LBVo8wgOaXPylOlHxsDizfkL8QwXItyakBfMO6jWQRrj7/9WDhGf4Hi+\nGQur1tPGZDl9mvCoRHjFrD5M/yypIPlfMGWFVEvV5jClNMLAQ9bYFuOc7H1fEWw6\nU1LZUUbJW9/CH45YXz82CYqkrfbnQxqRb2iVbVjs/sHopHd1NTiCfUtwvcYJiBVj\nkwIDAQAB\n-----END PUBLIC KEY-----";

    JwtConfigurationTest() {
    }

    @Test
    void getJwtPublicKeyPemShouldReturnEmptyWhenEmptyPublicKey() {
        JwtConfiguration jwtConfiguration = new JwtConfiguration((List)ImmutableList.of());
        Assertions.assertThat((List)jwtConfiguration.getJwtPublicKeyPem()).isEmpty();
    }

    @Test
    void constructorShouldThrowWhenNullPublicKey() {
        Assertions.assertThatThrownBy(() -> new JwtConfiguration(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void constructorShouldThrowWhenNonePublicKey() {
        Assertions.assertThatThrownBy(() -> new JwtConfiguration((List)ImmutableList.of((Object)""))).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void constructorShouldThrowWhenInvalidPublicKey() {
        Assertions.assertThatThrownBy(() -> new JwtConfiguration((List)ImmutableList.of((Object)INVALID_PUBLIC_KEY))).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void getJwtPublicKeyPemShouldReturnWhenValidPublicKey() {
        JwtConfiguration jwtConfiguration = new JwtConfiguration((List)ImmutableList.of((Object)VALID_PUBLIC_KEY));
        Assertions.assertThat((List)jwtConfiguration.getJwtPublicKeyPem()).isNotEmpty();
    }
}

