/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import java.util.Optional;
import org.apache.james.modules.data.JPAConfiguration;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class JPAConfigurationTest {
    private static final String DRIVER_NAME = "driverName";
    private static final String DRIVER_URL = "driverUrl";
    private static final boolean TEST_ON_BORROW = true;
    private static final String VALIDATION_QUERY = "validationQuery";
    private static final int VALIDATION_TIMEOUT_SEC = 1;
    private static final int MAX_CONNECTIONS = 5;
    private static final String USER_NAME = "username";
    private static final String PASSWORD = "password";
    private static final String EMPTY_STRING = "";

    JPAConfigurationTest() {
    }

    @Test
    void buildShouldReturnCorrespondingProperties() {
        JPAConfiguration configuration = JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).testOnBorrow(Boolean.valueOf(true)).validationQuery(VALIDATION_QUERY).validationQueryTimeoutSec(Integer.valueOf(1)).username(USER_NAME).password(PASSWORD).maxConnections(Integer.valueOf(5)).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.getDriverName()).isEqualTo(DRIVER_NAME);
            softly.assertThat(configuration.getDriverURL()).isEqualTo(DRIVER_URL);
            softly.assertThat(configuration.isTestOnBorrow()).contains((Object)true);
            softly.assertThat(configuration.getValidationQuery()).contains((Object)VALIDATION_QUERY);
            softly.assertThat(configuration.getValidationQueryTimeoutSec()).contains((Object)1);
            softly.assertThat(configuration.getCredential()).hasValueSatisfying(credential -> {
                softly.assertThat(credential.getPassword()).isEqualTo(PASSWORD);
                softly.assertThat(credential.getUsername()).isEqualTo(USER_NAME);
            });
            softly.assertThat(configuration.getMaxConnections()).contains((Object)5);
        });
    }

    @Test
    void buildShouldReturnEmptyOptionalPropertiesWhenNotSpecified() {
        JPAConfiguration configuration = JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.getDriverName()).isEqualTo(DRIVER_NAME);
            softly.assertThat(configuration.getDriverURL()).isEqualTo(DRIVER_URL);
            softly.assertThat(configuration.isTestOnBorrow()).isEmpty();
            softly.assertThat(configuration.getValidationQuery()).isEmpty();
            softly.assertThat(configuration.getValidationQueryTimeoutSec()).isEmpty();
            softly.assertThat(configuration.getCredential()).isEmpty();
            softly.assertThat(configuration.getMaxConnections()).isEmpty();
        });
    }

    @Test
    void buildShouldThrowWhenValidationQueryTimeoutSecIsZero() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).validationQueryTimeoutSec(Integer.valueOf(0)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("validationQueryTimeoutSec is required to be greater than 0");
    }

    @Test
    void buildShouldThrowWhenMaxConnectionIsZero() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).maxConnections(Integer.valueOf(0)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxConnections is required to be -1 (no limit) or  greater than 0");
    }

    @Test
    void buildShouldThrowWhenMaxConnectionIsLesThanMinusOne() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).maxConnections(Integer.valueOf(-10)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxConnections is required to be -1 (no limit) or  greater than 0");
    }

    @Test
    void buildShouldBuildWhenMaxConnectionIsMinusOne() {
        JPAConfiguration configuration = JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).maxConnections(Integer.valueOf(-1)).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(configuration.getDriverName()).isEqualTo(DRIVER_NAME);
            softly.assertThat(configuration.getDriverURL()).isEqualTo(DRIVER_URL);
            softly.assertThat(configuration.isTestOnBorrow()).isEmpty();
            softly.assertThat(configuration.getValidationQuery()).isEmpty();
            softly.assertThat(configuration.getValidationQueryTimeoutSec()).isEmpty();
            softly.assertThat(configuration.getCredential()).isEmpty();
            softly.assertThat(configuration.getMaxConnections()).contains((Object)-1);
        });
    }

    @Test
    void buildShouldThrowWhenValidationQueryTimeoutSecIsNegative() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).validationQueryTimeoutSec(Integer.valueOf(-1)).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("validationQueryTimeoutSec is required to be greater than 0");
    }

    @Test
    void buildShouldThrowWhenPasswordIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).username(USER_NAME).password(null).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("username and password for connecting to database can't be blank");
    }

    @Test
    void buildShouldThrowWhenPasswordIsEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).username(USER_NAME).password(EMPTY_STRING).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("username and password for connecting to database can't be blank");
    }

    @Test
    void buildShouldThrowWhenUsernameIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).username(null).password(PASSWORD).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("username and password for connecting to database can't be blank");
    }

    @Test
    void buildShouldThrowWhenUsernameIsEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).username(EMPTY_STRING).password(PASSWORD).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("username and password for connecting to database can't be blank");
    }

    @Test
    void buildShouldReturnEmptyOptionalCredentialWhenPassingNullValues() {
        JPAConfiguration configuration = JPAConfiguration.builder().driverName(DRIVER_NAME).driverURL(DRIVER_URL).username(null).password(null).build();
        Assertions.assertThat((Optional)configuration.getCredential()).isEmpty();
    }
}

