/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.inject.Singleton;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.modules.data.JPAConfiguration;

public interface TestJPAConfigurationModuleWithSqlValidation {
    public static final String DATABASE_USERNAME = "james";
    public static final String DATABASE_PASSWORD = "james-secret";
    public static final String JDBC_EMBEDDED_URL = "jdbc:derby:memory:mailboxintegration;create=true";
    public static final String JDBC_EMBEDDED_DRIVER = EmbeddedDriver.class.getName();
    public static final String VALIDATION_SQL_QUERY = "VALUES 1";

    public static JPAConfiguration.ReadyToBuild jpaConfigurationBuilder() {
        return JPAConfiguration.builder().driverName(JDBC_EMBEDDED_DRIVER).driverURL(JDBC_EMBEDDED_URL).testOnBorrow(Boolean.valueOf(true)).validationQueryTimeoutSec(Integer.valueOf(2)).validationQuery(VALIDATION_SQL_QUERY);
    }

    public static class WithDatabaseAuthentication
    extends AbstractModule {
        protected void configure() {
            this.setupAuthenticationOnDerby();
        }

        @Provides
        @Singleton
        JPAConfiguration provideConfiguration() {
            return TestJPAConfigurationModuleWithSqlValidation.jpaConfigurationBuilder().username(TestJPAConfigurationModuleWithSqlValidation.DATABASE_USERNAME).password(TestJPAConfigurationModuleWithSqlValidation.DATABASE_PASSWORD).build();
        }

        private void setupAuthenticationOnDerby() {
            try (Connection conn = DriverManager.getConnection(TestJPAConfigurationModuleWithSqlValidation.JDBC_EMBEDDED_URL, TestJPAConfigurationModuleWithSqlValidation.DATABASE_USERNAME, TestJPAConfigurationModuleWithSqlValidation.DATABASE_PASSWORD);){
                this.setDerbyProperty(conn, "derby.connection.requireAuthentication", "true");
                this.setDerbyProperty(conn, "derby.authentication.provider", "BUILTIN");
                this.setDerbyProperty(conn, "derby.user.james", TestJPAConfigurationModuleWithSqlValidation.DATABASE_PASSWORD);
                this.setDerbyProperty(conn, "derby.database.propertiesOnly", "true");
                this.setDerbyProperty(conn, "derby.database.defaultConnectionMode", "noAccess");
                this.setDerbyProperty(conn, "derby.database.fullAccessUsers", TestJPAConfigurationModuleWithSqlValidation.DATABASE_USERNAME);
                this.setDerbyProperty(conn, "derby.database.propertiesOnly", "false");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private void setDerbyProperty(Connection conn, String key, String value) {
            try (CallableStatement call = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");){
                call.setString(1, key);
                call.setString(2, value);
                call.execute();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class NoDatabaseAuthentication
    extends AbstractModule {
        protected void configure() {
        }

        @Provides
        @Singleton
        JPAConfiguration provideConfiguration() {
            return TestJPAConfigurationModuleWithSqlValidation.jpaConfigurationBuilder().build();
        }
    }
}

