/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.util.EnumSet;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JPAJamesConfiguration;
import org.apache.james.JPAJamesServerMain;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.TestJPAConfigurationModule;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.mailbox.MailboxManager;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

class JamesCapabilitiesServerTest {
    @RegisterExtension
    static JamesServerExtension jamesServerExtension = new JamesServerBuilder(tmpDir -> JPAJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().usersRepository(UsersRepositoryModuleChooser.Implementation.DEFAULT).build()).server(configuration -> JPAJamesServerMain.createServer((JPAJamesConfiguration)configuration).overrideWith(new Module[]{new TestJPAConfigurationModule()}).overrideWith(new Module[]{binder -> binder.bind(MailboxManager.class).toInstance((Object)JamesCapabilitiesServerTest.mailboxManager())})).build();

    JamesCapabilitiesServerTest() {
    }

    private static MailboxManager mailboxManager() {
        MailboxManager mailboxManager = (MailboxManager)Mockito.mock(MailboxManager.class);
        Mockito.when((Object)mailboxManager.getSupportedMailboxCapabilities()).thenReturn(EnumSet.noneOf(MailboxManager.MailboxCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedMessageCapabilities()).thenReturn(EnumSet.noneOf(MailboxManager.MessageCapabilities.class));
        Mockito.when((Object)mailboxManager.getSupportedSearchCapabilities()).thenReturn(EnumSet.noneOf(MailboxManager.SearchCapabilities.class));
        return mailboxManager;
    }

    @Test
    void startShouldSucceedWhenRequiredCapabilities(GuiceJamesServer server) {
    }
}

