/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import java.io.IOException;
import org.apache.commons.net.imap.IMAPClient;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JPAJamesConfiguration;
import org.apache.james.JPAJamesServerMain;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.TestJPAConfigurationModule;
import org.apache.james.data.LdapTestExtension;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class JPAWithLDAPJamesServerTest {
    @RegisterExtension
    static JamesServerExtension jamesServerExtension = new JamesServerBuilder(tmpDir -> JPAJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().usersRepository(UsersRepositoryModuleChooser.Implementation.LDAP).build()).server(configuration -> JPAJamesServerMain.createServer((JPAJamesConfiguration)configuration).overrideWith(new Module[]{new TestJPAConfigurationModule()})).lifeCycle(JamesServerExtension.Lifecycle.PER_CLASS).extension((GuiceModuleTestExtension)new LdapTestExtension()).build();

    JPAWithLDAPJamesServerTest() {
    }

    @Test
    void userFromLdapShouldLoginViaImapProtocol(GuiceJamesServer server) throws IOException {
        IMAPClient imapClient = new IMAPClient();
        imapClient.connect("127.0.0.1", ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort());
        Assertions.assertThat((boolean)imapClient.login(DockerLdapSingleton.JAMES_USER.asString(), "secret")).isTrue();
    }
}

