/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.base.Strings;
import com.google.inject.Module;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JPAJamesConfiguration;
import org.apache.james.JPAJamesServerMain;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerConcreteContract;
import org.apache.james.JamesServerExtension;
import org.apache.james.TestJPAConfigurationModule;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.TestIMAPClient;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.Test;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;

class JPAJamesServerTest
implements JamesServerConcreteContract {
    @RegisterExtension
    static JamesServerExtension jamesServerExtension = new JamesServerBuilder(tmpDir -> JPAJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().usersRepository(UsersRepositoryModuleChooser.Implementation.DEFAULT).build()).server(configuration -> JPAJamesServerMain.createServer((JPAJamesConfiguration)configuration).overrideWith(new Module[]{new TestJPAConfigurationModule()})).lifeCycle(JamesServerExtension.Lifecycle.PER_CLASS).build();
    private static final ConditionFactory AWAIT = Awaitility.await().atMost(Durations.ONE_MINUTE).with().pollInterval(Durations.FIVE_HUNDRED_MILLISECONDS);
    static final String DOMAIN = "james.local";
    private static final String USER = "toto@james.local";
    private static final String PASSWORD = "123456";
    private TestIMAPClient testIMAPClient;
    private SMTPMessageSender smtpMessageSender;

    JPAJamesServerTest() {
    }

    @BeforeEach
    void setUp() {
        this.testIMAPClient = new TestIMAPClient();
        this.smtpMessageSender = new SMTPMessageSender(DOMAIN);
    }

    @Test
    void jpaGuiceServerShouldUpdateQuota(GuiceJamesServer jamesServer) throws Exception {
        ((DataProbeImpl)jamesServer.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(USER, PASSWORD);
        ((QuotaProbesImpl)jamesServer.getProbe(QuotaProbesImpl.class)).setGlobalMaxStorage(QuotaSizeLimit.size((long)51200L));
        int imapPort = ((ImapGuiceProbe)jamesServer.getProbe(ImapGuiceProbe.class)).getImapPort();
        this.smtpMessageSender.connect("127.0.0.1", ((SmtpGuiceProbe)jamesServer.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).authenticate(USER, PASSWORD).sendMessageWithHeaders(USER, USER, "header: toto\\r\\n\\r\\n" + Strings.repeat((String)"0123456789\n", (int)1024));
        AWAIT.until(() -> this.testIMAPClient.connect("127.0.0.1", imapPort).login(USER, PASSWORD).select("INBOX").hasAMessage());
        ((AbstractStringAssert)Assertions.assertThat((String)this.testIMAPClient.connect("127.0.0.1", imapPort).login(USER, PASSWORD).getQuotaRoot("INBOX")).startsWith((CharSequence)"* QUOTAROOT \"INBOX\" #private&toto@james.local\r\n* QUOTA #private&toto@james.local (STORAGE 12 50)\r\n")).endsWith((CharSequence)"OK GETQUOTAROOT completed.\r\n");
    }
}

