/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.collect.ImmutableSet;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.Version;
import org.apache.james.jmap.VersionParser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class VersionParserTest {
    private static final ImmutableSet<Version> SUPPORTED_VERSIONS = ImmutableSet.of((Object)Version.DRAFT, (Object)Version.RFC8621);
    private VersionParser versionParser;

    VersionParserTest() {
    }

    @BeforeEach
    void setUp() {
        this.versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
    }

    @Test
    void parseShouldReturnCorrectValue() {
        String version = "rfc-8621";
        Assertions.assertThat((Object)this.versionParser.parse(version)).isEqualTo((Object)Version.RFC8621);
    }

    @Test
    void parseShouldThrowWhenVersionNotKnown() {
        String version = "unknown";
        Assertions.assertThatThrownBy(() -> this.versionParser.parse(version)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void parseShouldThrowWhenVersionIsNull() {
        Assertions.assertThatThrownBy(() -> this.versionParser.parse(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void parseShouldThrowWhenVersionIsEmpty() {
        String version = "";
        Assertions.assertThatThrownBy(() -> this.versionParser.parse(version)).isInstanceOf(IllegalArgumentException.class);
    }
}

