/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.JMAPRoutesHandler;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.Version;
import org.apache.james.jmap.VersionParser;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerResponse;

class JMAPServerTest {
    private static final String ACCEPT_JMAP_VERSION_HEADER = "application/json; jmapVersion=";
    private static final String ACCEPT_DRAFT_VERSION_HEADER = "application/json; jmapVersion=" + Version.DRAFT.asString();
    private static final String ACCEPT_RFC8621_VERSION_HEADER = "application/json; jmapVersion=" + Version.RFC8621.asString();
    private static final JMAPConfiguration DISABLED_CONFIGURATION = JMAPConfiguration.builder().disable().build();
    private static final JMAPConfiguration TEST_CONFIGURATION = JMAPConfiguration.builder().enable().randomPort().build();
    private static final ImmutableSet<JMAPRoutesHandler> NO_ROUTES_HANDLERS = ImmutableSet.of();
    private static final ImmutableSet<Endpoint> AUTHENTICATION_ENDPOINTS = ImmutableSet.of((Object)new Endpoint(HttpMethod.POST, "/authentication"), (Object)new Endpoint(HttpMethod.GET, "/authentication"));
    private static final ImmutableSet<Endpoint> JMAP_ENDPOINTS = ImmutableSet.of((Object)new Endpoint(HttpMethod.POST, "/jmap"), (Object)new Endpoint(HttpMethod.DELETE, "/jmap"));
    private static final ImmutableSet<JMAPRoutesHandler> FAKE_ROUTES_HANDLERS = ImmutableSet.of((Object)new JMAPRoutesHandler(Version.DRAFT, new JMAPRoutes[]{new FakeJMAPRoutes((Set<Endpoint>)AUTHENTICATION_ENDPOINTS, Version.DRAFT), new FakeJMAPRoutes((Set<Endpoint>)JMAP_ENDPOINTS, Version.DRAFT)}), (Object)new JMAPRoutesHandler(Version.RFC8621, new JMAPRoutes[]{new FakeJMAPRoutes((Set<Endpoint>)AUTHENTICATION_ENDPOINTS, Version.RFC8621)}));
    private static final ImmutableSet<JMAPRoutesHandler> CORS_ROUTES = ImmutableSet.of((Object)new JMAPRoutesHandler(Version.DRAFT, new JMAPRoutes[]{new FakeJMAPRoutes((Set<Endpoint>)ImmutableSet.of((Object)Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/a")), Version.DRAFT)}), (Object)new JMAPRoutesHandler(Version.RFC8621, new JMAPRoutes[]{new FakeJMAPRoutes((Set<Endpoint>)ImmutableSet.of((Object)new Endpoint(HttpMethod.OPTIONS, "/b")), Version.RFC8621)}));
    private static final ImmutableSet<Version> SUPPORTED_VERSIONS = ImmutableSet.of((Object)Version.DRAFT, (Object)Version.RFC8621);

    JMAPServerTest() {
    }

    @Test
    void serverShouldAnswerWhenStarted() {
        VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
        JMAPServer jmapServer = new JMAPServer(TEST_CONFIGURATION, NO_ROUTES_HANDLERS, versionParser);
        jmapServer.start();
        try {
            ((ValidatableResponse)((Response)RestAssured.given().port(jmapServer.getPort().getValue()).basePath("http://localhost").when().get()).then()).statusCode(404);
        }
        finally {
            jmapServer.stop();
        }
    }

    @Test
    void startShouldNotThrowWhenConfigurationDisabled() {
        VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
        JMAPServer jmapServer = new JMAPServer(DISABLED_CONFIGURATION, NO_ROUTES_HANDLERS, versionParser);
        Assertions.assertThatCode(() -> ((JMAPServer)jmapServer).start()).doesNotThrowAnyException();
    }

    @Test
    void stopShouldNotThrowWhenConfigurationDisabled() {
        VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
        JMAPServer jmapServer = new JMAPServer(DISABLED_CONFIGURATION, NO_ROUTES_HANDLERS, versionParser);
        jmapServer.start();
        Assertions.assertThatCode(() -> ((JMAPServer)jmapServer).stop()).doesNotThrowAnyException();
    }

    @Test
    void getPortShouldThrowWhenServerIsNotStarted() {
        VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
        JMAPServer jmapServer = new JMAPServer(TEST_CONFIGURATION, NO_ROUTES_HANDLERS, versionParser);
        Assertions.assertThatThrownBy(() -> ((JMAPServer)jmapServer).getPort()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void getPortShouldThrowWhenDisabledConfiguration() {
        VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
        JMAPServer jmapServer = new JMAPServer(DISABLED_CONFIGURATION, NO_ROUTES_HANDLERS, versionParser);
        jmapServer.start();
        Assertions.assertThatThrownBy(() -> ((JMAPServer)jmapServer).getPort()).isInstanceOf(IllegalStateException.class);
    }

    private static class FakeJMAPRoutes
    implements JMAPRoutes {
        private final Set<Endpoint> endpoints;
        private final Version version;

        private FakeJMAPRoutes(Set<Endpoint> endpoints, Version version) {
            this.endpoints = endpoints;
            this.version = version;
        }

        public Stream<JMAPRoute> routes() {
            return this.endpoints.stream().map(endpoint -> JMAPRoute.builder().endpoint(endpoint).action((request, response) -> {
                if (endpoint.getMethod().equals((Object)HttpMethod.OPTIONS)) {
                    return JMAPRoutes.CORS_CONTROL.handleRequest(request, response);
                }
                return this.sendVersionResponse(response);
            }).noCorsHeaders());
        }

        private Mono<Void> sendVersionResponse(HttpServerResponse response) {
            return response.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").sendString((Publisher)Mono.just((Object)String.format("{\"Version\":\"%s\"}", this.version.asString()))).then();
        }
    }

    @Nested
    class CorsRouteVersioningTest {
        JMAPServer server;

        CorsRouteVersioningTest() {
        }

        @BeforeEach
        void setUp() {
            VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
            this.server = new JMAPServer(TEST_CONFIGURATION, CORS_ROUTES, versionParser);
            this.server.start();
            RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(this.server.getPort().getValue()).build();
        }

        @AfterEach
        void tearDown() {
            this.server.stop();
        }

        @Test
        void corsRoutesOfAllVersionsShouldBeExposed() {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().options("/b", new Object[0])).then()).statusCode(200)).header("Access-Control-Allow-Origin", "*")).header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT")).header("Access-Control-Allow-Headers", "Content-Type, Authorization, Accept")).header("Access-Control-Max-Age", "86400");
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().options("/a", new Object[0])).then()).statusCode(200)).header("Access-Control-Allow-Origin", "*")).header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT")).header("Access-Control-Allow-Headers", "Content-Type, Authorization, Accept")).header("Access-Control-Max-Age", "86400");
        }
    }

    @Nested
    class RouteVersioningTest {
        JMAPServer server;

        RouteVersioningTest() {
        }

        @BeforeEach
        void setUp() {
            VersionParser versionParser = new VersionParser(SUPPORTED_VERSIONS, JMAPConfiguration.DEFAULT);
            this.server = new JMAPServer(TEST_CONFIGURATION, FAKE_ROUTES_HANDLERS, versionParser);
            this.server.start();
            RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(this.server.getPort().getValue()).build();
        }

        @AfterEach
        void tearDown() {
            this.server.stop();
        }

        @Test
        void serverShouldReturnDefaultVersionRouteWhenNoVersionHeader() {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/authentication").when().get()).then()).statusCode(HttpResponseStatus.OK.code())).body("Version", Matchers.is((Object)Version.DRAFT.asString()), new Object[0]);
        }

        @Test
        void serverShouldReturnCorrectRouteWhenTwoVersionRoutes() {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/authentication").header(HttpHeaderNames.ACCEPT.toString(), (Object)ACCEPT_RFC8621_VERSION_HEADER, new Object[0]).when().get()).then()).statusCode(HttpResponseStatus.OK.code())).body("Version", Matchers.is((Object)Version.RFC8621.asString()), new Object[0]);
        }

        @Test
        void serverShouldReturnCorrectRouteWhenOneVersionRoute() {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/jmap").header(HttpHeaderNames.ACCEPT.toString(), (Object)ACCEPT_DRAFT_VERSION_HEADER, new Object[0]).when().post()).then()).statusCode(HttpResponseStatus.OK.code())).body("Version", Matchers.is((Object)Version.DRAFT.asString()), new Object[0]);
        }

        @Test
        void serverShouldReturnNotFoundWhenRouteVersionDoesNotExist() {
            ((ValidatableResponse)((Response)RestAssured.given().basePath("/jmap").header(HttpHeaderNames.ACCEPT.toString(), (Object)ACCEPT_RFC8621_VERSION_HEADER, new Object[0]).when().post()).then()).statusCode(HttpResponseStatus.NOT_FOUND.code());
        }

        @Test
        void serverShouldReturnBadRequestWhenVersionIsUnknown() {
            ((ValidatableResponse)((Response)RestAssured.given().basePath("/authentication").header(HttpHeaderNames.ACCEPT.toString(), (Object)"application/json; jmapVersion=unknown", new Object[0]).when().get()).then()).statusCode(HttpResponseStatus.BAD_REQUEST.code());
        }
    }
}

